/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool;

import java.lang.Thread.UncaughtExceptionHandler;

import javax.swing.SwingUtilities;

import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;
import jp.co.ogis_ri.citk.policytool.view.common.ViewExceptionHandler;
import jp.co.ogis_ri.citk.policytool.view.policylist.PolicyListView;

import org.springframework.beans.factory.annotation.Autowired;

/**
 * アプリケーション起動クラス.
 */
public class AppLauncher {

    /**
     * PolicyListView.
     */
    @Autowired
    private PolicyListView policyListView = null;

    /**
     * main メソッド. アプリケーションのエントリポイント.
     * 
     * @param args アプリケーション起動時に指定される引数情報.
     */
    public static void main(String[] args) {
        AppLauncher app = null;
        try {
            app = ApplicationContextUtil.getBean(AppLauncher.class);
        } catch (Exception e) {
            ViewExceptionHandler viewExceptionHandler =
                    new ViewExceptionHandler();
            viewExceptionHandler.handle(e);
        }
        app.run(args);
    }

    /**
     * アプリケーションを起動しする.
     * 
     * @param args アプリケーション起動時に指定される引数情報.
     */
    public void run(String[] args) {
        SwingUtilities.invokeLater(new Runnable() {
            private ViewExceptionHandler viewExceptionHandler =
                    new ViewExceptionHandler();

            public void run() {
                // EDTに例外ハンドラーを設定し、RuntimeException を受け取る
                Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandler() {
                    public void uncaughtException(Thread t, Throwable e) {
                        viewExceptionHandler.handle(e);
                    }
                });
                policyListView.setVisible(true);
            }
        });
    }

}
