/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertThat;

import org.junit.Test;

public class PoliciesSsoadmResultParserTest {
    @Test
    public void testParse() {
        String policiesXML = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n"
                + "<!DOCTYPE Policies \n"
                + "PUBLIC \"-//OpenSSO Policy Administration DTD//EN\"\n"
                + "\"jar://com/sun/identity/policy/policyAdmin.dtd\">\n"
                + "\n"
                + "<!-- extracted from realm, / -->\n"
                + "<Policies>\n"
                + "<Policy name=\"testPolicy1234\" createdby=\"id=amadmin,ou=user,dc=opensso,dc=java,dc=net\" lastmodifiedby=\"id=amadmin,ou=user,dc=opensso,dc=java,dc=net\" creationdate=\"1324020372625\" lastmodifieddate=\"1324020372625\" referralPolicy=\"false\" active=\"true\" >\n"
                + "<Rule name=\"rule_1323408196714_1\">\n"
                + "<ServiceName name=\"iPlanetAMWebAgentService\" />\n"
                + "<ResourceName name=\"http://aaaaam.1323408196687\" />\n"
                + "<AttributeValuePair>\n"
                + "<Attribute name=\"GET\" />\n"
                + "<Value>allow</Value>\n"
                + "</AttributeValuePair>\n"
                + "</Rule>\n"
                + "<Rule name=\"rule_1323408196714_0\">\n"
                + "<ServiceName name=\"iPlanetAMWebAgentService\" />\n"
                + "<ResourceName name=\"https://zzzzzm.1323408196687\" />\n"
                + "<AttributeValuePair>\n"
                + "<Attribute name=\"POST\" />\n"
                + "<Value>allow</Value>\n"
                + "</AttributeValuePair>\n"
                + "<AttributeValuePair>\n"
                + "<Attribute name=\"GET\" />\n"
                + "<Value>deny</Value>\n"
                + "</AttributeValuePair>\n"
                + "</Rule>\n"
                + "<Subjects name=\"subjects_1323408196703_0\" description=\"\">\n"
                + "<Subject name=\"Sname_a\" type=\"AMIdentitySubject\" includeType=\"inclusive\">\n"
                + "<AttributeValuePair><Attribute name=\"Values\"/><Value>id=group5,ou=group,dc=opensso,dc=java,dc=net</Value>\n"
                + "</AttributeValuePair>\n"
                + "</Subject>\n"
                + "<Subject name=\"Sname_b\" type=\"AMIdentitySubject\" includeType=\"inclusive\">\n"
                + "<AttributeValuePair><Attribute name=\"Values\"/><Value>id=group5,ou=group,dc=opensso,dc=java,dc=net</Value>\n"
                + "</AttributeValuePair>\n"
                + "</Subject>\n"
                + "</Subjects>\n"
                + "</Policy>\n"
                + "</Policies>";
        
        String input = "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n"
                + "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
                + "<head>\n"
                + "    <title>OpenSSO</title>\n"
                + "    <link rel=\"stylesheet\" type=\"text/css\" href=\"com_sun_web_ui/css/css_ns6up.css\" />\n"
                + "    <link rel=\"shortcut icon\" href=\"com_sun_web_ui/images/favicon/favicon.ico\" type=\"image/x-icon\" />\n"
                + "    <script language=\"Javascript\" src=\"js/admincli.js\"></script>\n"
                + "</head>\n"
                + "<body class=\"DefBdy\">\n"
                + "    <div class=\"SkpMedGry1\"><a href=\"#SkipAnchor3860\"><img src=\"com_sun_web_ui/images/other/dot.gif\" alt=\"Jump to End of Masthead\" border=\"0\" height=\"1\" width=\"1\" /></a></div><div class=\"MstDiv\">\n"
                + "    <table class=\"MstTblBot\" title=\"\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n"
                + "        <tr>\n"
                + "        <td class=\"MstTdTtl\" width=\"99%\">\n"
                + "        <div class=\"MstDivTtl\"><img name=\"AMConfig.configurator.ProdName\" src=\"console/images/PrimaryProductName.png\" alt=\"OpenSSO\" border=\"0\" /></div>\n"
                + "        </td>\n"
                + "        <td class=\"MstTdLogo\" width=\"1%\"><img name=\"AMConfig.configurator.BrandLogo\" src=\"com_sun_web_ui/images/other/javalogo.gif\" alt=\"Java(TM) Logo\" border=\"0\" height=\"55\" width=\"31\" /></td>\n"
                + "        </tr>\n"
                + "    </table>\n"
                + "    <table class=\"MstTblEnd\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td><img name=\"RMRealm.mhCommon.EndorserLogo\" src=\"com_sun_web_ui/images/masthead/masthead-sunname.gif\" alt=\"Sun(TM) Microsystems, Inc.\" align=\"right\" border=\"0\" height=\"10\" width=\"108\" /></td></tr></table>\n"
                + "    </div>\n"
                + "    <table class=\"SkpMedGry1\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" width=\"100%\"><tr><td><img src=\"com_sun_web_ui/images/other/dot.gif\" alt=\"Jump to End of Masthead\" border=\"0\" height=\"1\" width=\"1\" /></a></td></tr></table>\n"
                + "    <table border=\"0\" cellpadding=\"10\" cellspacing=\"0\" width=\"100%\"><tr><td></td></tr></table>\n"
                + "\n"
                + "<table cellpadding=5>\n"
                + "<tr>\n"
                + "<td>\n"
                + "\n"
                + "<pre>\n"
                + "<a href=\"/opensso/ssoadm.jsp\">メインページに戻ります。</a><br /><br />&#xa;レルム &#x2f; にあるポリシー定義が返されました。&#xa;&lt;&#x3f;xml version&#x3d;&quot;1.0&quot; encoding&#x3d;&quot;ISO-8859-1&quot;&#x3f;&gt;&#xa;&lt;&#x21;DOCTYPE Policies &#xa;PUBLIC &quot;-&#x2f;&#x2f;OpenSSO Policy Administration DTD&#x2f;&#x2f;EN&quot;&#xa;&quot;jar&#x3a;&#x2f;&#x2f;com&#x2f;sun&#x2f;identity&#x2f;policy&#x2f;policyAdmin.dtd&quot;&gt;&#xa;&#xa;&lt;&#x21;-- extracted from realm, &#x2f; --&gt;&#xa;&lt;Policies&gt;&#xa;&lt;Policy name&#x3d;&quot;testPolicy1234&quot; createdby&#x3d;&quot;id&#x3d;amadmin,ou&#x3d;user,dc&#x3d;opensso,dc&#x3d;java,dc&#x3d;net&quot; lastmodifiedby&#x3d;&quot;id&#x3d;amadmin,ou&#x3d;user,dc&#x3d;opensso,dc&#x3d;java,dc&#x3d;net&quot; creationdate&#x3d;&quot;1324020372625&quot; lastmodifieddate&#x3d;&quot;1324020372625&quot; referralPolicy&#x3d;&quot;false&quot; active&#x3d;&quot;true&quot; &gt;&#xa;&lt;Rule name&#x3d;&quot;rule_1323408196714_1&quot;&gt;&#xa;&lt;ServiceName name&#x3d;&quot;iPlanetAMWebAgentService&quot; &#x2f;&gt;&#xa;&lt;ResourceName name&#x3d;&quot;http&#x3a;&#x2f;&#x2f;aaaaam.1323408196687&quot; &#x2f;&gt;&#xa;&lt;AttributeValuePair&gt;&#xa;&lt;Attribute name&#x3d;&quot;GET&quot; &#x2f;&gt;&#xa;&lt;Value&gt;allow&lt;&#x2f;Value&gt;&#xa;&lt;&#x2f;AttributeValuePair&gt;&#xa;&lt;&#x2f;Rule&gt;&#xa;&lt;Rule name&#x3d;&quot;rule_1323408196714_0&quot;&gt;&#xa;&lt;ServiceName name&#x3d;&quot;iPlanetAMWebAgentService&quot; &#x2f;&gt;&#xa;&lt;ResourceName name&#x3d;&quot;https&#x3a;&#x2f;&#x2f;zzzzzm.1323408196687&quot; &#x2f;&gt;&#xa;&lt;AttributeValuePair&gt;&#xa;&lt;Attribute name&#x3d;&quot;POST&quot; &#x2f;&gt;&#xa;&lt;Value&gt;allow&lt;&#x2f;Value&gt;&#xa;&lt;&#x2f;AttributeValuePair&gt;&#xa;&lt;AttributeValuePair&gt;&#xa;&lt;Attribute name&#x3d;&quot;GET&quot; &#x2f;&gt;&#xa;&lt;Value&gt;deny&lt;&#x2f;Value&gt;&#xa;&lt;&#x2f;AttributeValuePair&gt;&#xa;&lt;&#x2f;Rule&gt;&#xa;&lt;Subjects name&#x3d;&quot;subjects_1323408196703_0&quot; description&#x3d;&quot;&quot;&gt;&#xa;&lt;Subject name&#x3d;&quot;Sname_a&quot; type&#x3d;&quot;AMIdentitySubject&quot; includeType&#x3d;&quot;inclusive&quot;&gt;&#xa;&lt;AttributeValuePair&gt;&lt;Attribute name&#x3d;&quot;Values&quot;&#x2f;&gt;&lt;Value&gt;id&#x3d;group5,ou&#x3d;group,dc&#x3d;opensso,dc&#x3d;java,dc&#x3d;net&lt;&#x2f;Value&gt;&#xa;&lt;&#x2f;AttributeValuePair&gt;&#xa;&lt;&#x2f;Subject&gt;&#xa;&lt;Subject name&#x3d;&quot;Sname_b&quot; type&#x3d;&quot;AMIdentitySubject&quot; includeType&#x3d;&quot;inclusive&quot;&gt;&#xa;&lt;AttributeValuePair&gt;&lt;Attribute name&#x3d;&quot;Values&quot;&#x2f;&gt;&lt;Value&gt;id&#x3d;group5,ou&#x3d;group,dc&#x3d;opensso,dc&#x3d;java,dc&#x3d;net&lt;&#x2f;Value&gt;&#xa;&lt;&#x2f;AttributeValuePair&gt;&#xa;&lt;&#x2f;Subject&gt;&#xa;&lt;&#x2f;Subjects&gt;&#xa;&lt;&#x2f;Policy&gt;&#xa;&lt;&#x2f;Policies&gt;&#xa;&#xa;\n"
                + "<!-- CLI Exit Code: 980 -->\n"
                + "\n"
                + "\n"
                + "</pre>\n"
                + "</td></tr>\n"
                + "</table>\n"
                + "</body></html>\n"
                + "レルム / にあるポリシー定義が返されました。\n"
                + policiesXML + "\n";
        
        PoliciesSsoadmResultParser parser = new PoliciesSsoadmResultParser();

        SsoadmResult result = parser.parse(input);
        
        assertEquals(policiesXML, result.getData().get(0));
        assertEquals(980, result.getExitCode());
    }

    @Test
    public void testParse_PolicyZERO() {
        String input =
                "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "\n"
                + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n"
                + "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
                + "<head>\n"
                + "    <title>OpenSSO</title>\n"
                + "    <link rel=\"stylesheet\" type=\"text/css\" href=\"com_sun_web_ui/css/css_ns6up.css\" />\n"
                + "    <link rel=\"shortcut icon\" href=\"com_sun_web_ui/images/favicon/favicon.ico\" type=\"image/x-icon\" />\n"
                + "    <script language=\"Javascript\" src=\"js/admincli.js\"></script>\n"
                + "</head>\n"
                + "<body class=\"DefBdy\">\n"
                + "    <div class=\"SkpMedGry1\"><a href=\"#SkipAnchor3860\"><img src=\"com_sun_web_ui/images/other/dot.gif\" alt=\"Jump to End of Masthead\" border=\"0\" height=\"1\" width=\"1\" /></a></div><div class=\"MstDiv\">\n"
                + "    <table class=\"MstTblBot\" title=\"\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n"
                + "        <tr>\n"
                + "        <td class=\"MstTdTtl\" width=\"99%\">\n"
                + "        <div class=\"MstDivTtl\"><img name=\"AMConfig.configurator.ProdName\" src=\"console/images/PrimaryProductName.png\" alt=\"OpenSSO\" border=\"0\" /></div>\n"
                + "        </td>\n"
                + "        <td class=\"MstTdLogo\" width=\"1%\"><img name=\"AMConfig.configurator.BrandLogo\" src=\"com_sun_web_ui/images/other/javalogo.gif\" alt=\"Java(TM) Logo\" border=\"0\" height=\"55\" width=\"31\" /></td>\n"
                + "        </tr>\n"
                + "    </table>\n"
                + "    <table class=\"MstTblEnd\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td><img name=\"RMRealm.mhCommon.EndorserLogo\" src=\"com_sun_web_ui/images/masthead/masthead-sunname.gif\" alt=\"Sun(TM) Microsystems, Inc.\" align=\"right\" border=\"0\" height=\"10\" width=\"108\" /></td></tr></table>\n"
                + "    </div>\n"
                + "    <table class=\"SkpMedGry1\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" width=\"100%\"><tr><td><img src=\"com_sun_web_ui/images/other/dot.gif\" alt=\"Jump to End of Masthead\" border=\"0\" height=\"1\" width=\"1\" /></a></td></tr></table>\n"
                + "    <table border=\"0\" cellpadding=\"10\" cellspacing=\"0\" width=\"100%\"><tr><td></td></tr></table>\n"
                + "\n"
                + "<table cellpadding=5>\n"
                + "<tr>\n"
                + "<td>\n"
                + "\n"
                + "<pre>\n"
                + "<!-- CLI Exit Code: 222 -->\n"
                + "Organization &#x2f;aaaa not present.\n"
                + "\n"
                + "\n"
                + "</pre>\n"
                + "</td></tr>\n"
                + "</table>\n"
                + "</body></html>\n";
        
        PoliciesSsoadmResultParser parser = new PoliciesSsoadmResultParser();

        SsoadmResult result = parser.parse(input);
        
        assertThat(result.getData().get(0), is("<Policies/>"));
        assertThat(result.getExitCode(), is(222));
    }
}
