/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.view.policyset;

/**
 * Permit のコンボボックスの項目.
 */
class PermitComboBoxItem {

    /**
     * 項目の種類.
     */
    private Type type;

    /**
     * 表示名.
     */
    private String name;

    /**
     * 新しい PermitComboBoxItem を構築します.
     * 
     * @param type 項目の種類.
     * @param name 表示名.
     */
    PermitComboBoxItem(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    /**
     * 項目の種類を取得します.
     * 
     * @return 項目の種類.
     * 
     */
    Type getType() {
        return this.type;
    }

    /**
     * 項目の種類を設定します.
     * 
     * @param type 項目の種類.
     * 
     */
    void setType(Type type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PermitComboBoxItem) {
            PermitComboBoxItem itemObj = (PermitComboBoxItem) obj;
            return this.type.equals(itemObj.type);
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return this.type.hashCode();
    }

    /**
     * 項目の種類.
     */
    public enum Type {
        /** なし */
        NONE,

        /** 許可 */
        ALLOW,

        /** 拒否 */
        DENY,
    }
}
