/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.view.common;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 * JTable の コンボボックスセルの, TableCellRenderer.
 */
public class ComboBoxTableCellRenderer extends JComboBox implements
        TableCellRenderer {
    /**
     * シリアルバージョンID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * 新しい ComboBoxTableCellRenderer を構築する.
     * 
     * @param items コンボボックスの項目の配列.
     */
    public ComboBoxTableCellRenderer(Object[] items) {
        super();
        for (Object item : items) {
            addItem(item);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            setForeground(table.getForeground());
            setBackground(table.getBackground());
        }

        this.setSelectedItem(value);

        return this;
    }
}
