/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.service.exportpolicy.impl;

import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.excel.ExcelPolicyWriter;
import jp.co.ogis_ri.citk.policytool.domain.policy.PolicyRepository;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.service.exportpolicy.ExportPolicyService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * ポリシー エクスポート サービス.
 * 
 */
@Service
public class ExportPolicyServiceImpl implements ExportPolicyService {
    /**
     * PolicyRepository.
     */
    @Autowired
    private PolicyRepository policyRepository = null;

    /**
     * ポリシーエクスポートクラス
     */
    @Autowired
    private ExcelPolicyWriter excelPolicyWriter = null;

    @Override
    public void exportPolicy(String realmName, String groupName,
            String resourceUrl, String fileName) {
        List<Policy> policies =
                policyRepository.findPolicies(realmName, groupName, resourceUrl);

        excelPolicyWriter.write(fileName, policies);
    }
}
