/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import java.io.UnsupportedEncodingException;

import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;

import org.apache.commons.logging.Log;

/**
 * 文字列のユーティリティクラス.
 * 
 */
public class StringUtil {
    /**
     * ロガー.
     */
    private static final Log logger =
            LogWrapperFactory.getLog(StringUtil.class);

    /**
     * UTF-8.
     */
    public static final String CHARSET_UTF8 = "UTF-8";

    /**
     * Shift_JIS.
     */
    public static final String CHARSET_SHIFT_JIS = "Shift_JIS";

    /**
     * windows-31j.
     */
    public static final String CHARSET_WIN31J = "windows-31j";

    /**
     * 省略を意味する文字列.
     */
    private static final String SHORT_STR = "...";

    /**
     * コンストラクタ.
     */
    private StringUtil() {
    }

    /**
     * バイト配列を指定されたキャラセットの文字列に変換する.
     * 
     * @param b バイト配列.
     * @param charsetName キャラセット名.
     * @return 変換した文字列.
     */
    public static String encoding(byte[] b, String charsetName) {
        String result = null;
        try {
            result = new String(b, charsetName);
        } catch (UnsupportedEncodingException e) {
            logger.debug(e.getMessage());
            ExceptionUtil.convertRuntimeException(e);
        }
        return result;
    }

    /**
     * 文字列を指定されたキャラセットのバイト配列に変換する.
     * 
     * @param s 文字列.
     * @param charsetName キャラセット名.
     * @return 変換後のバイト配列.
     */
    public static byte[] encoding(String s, String charsetName) {
        byte[] result = null;
        try {
            result = s.getBytes(charsetName);
        } catch (UnsupportedEncodingException e) {
            logger.debug(e.getMessage());
            ExceptionUtil.convertRuntimeException(e);
        }
        return result;
    }

    /**
     * 指定の長さを超える文字列の場合、指定の長さで省略形の文字列に変換する.
     * 
     * @param s 文字列.
     * @param length 指定の文字列長.
     * @return 変換後の文字列.
     */
    public static String shortString(String s, int length) {
        if (s == null) {
            return "";
        }
        if (length <= SHORT_STR.length()) {
            return s;
        }
        return s.length() <= length ? s : s.substring(0,
                length - SHORT_STR.length())
                + SHORT_STR;
    }
}
