/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import static org.junit.Assert.assertThat;
import static org.junit.matchers.JUnitMatchers.containsString;

import org.junit.Test;

public class StringUtilTest {
    
    @Test
    public void testEncoding() throws Exception {
    	final String DATA = "123abcあいうえおー－㈱①";
    	final String DATA_SJIS = "123abcあいうえおー???";
       	final String EXPECTED_UTF8 = "31 32 33 61 62 63 e3 81 82 e3 81 84 e3 81 86 e3 81 88 e3 81 8a e3 83 bc ef bc 8d e3 88 b1 e2 91 a0";
        final String EXPECTED_SJIS = "31 32 33 61 62 63 82 a0 82 a2 82 a4 82 a6 82 a8 81 5b 3f 3f 3f";
    	final String EXPECTED_WIN31J = "31 32 33 61 62 63 82 a0 82 a2 82 a4 82 a6 82 a8 81 5b 81 7c 87 8a 87 40";
 
    	assertThat(toHexString(StringUtil.encoding(DATA, StringUtil.CHARSET_UTF8)), containsString(EXPECTED_UTF8));
    	assertThat(toHexString(StringUtil.encoding(DATA, StringUtil.CHARSET_SHIFT_JIS)), containsString(EXPECTED_SJIS));
    	assertThat(toHexString(StringUtil.encoding(DATA, StringUtil.CHARSET_WIN31J)), containsString(EXPECTED_WIN31J));

    	assertThat(StringUtil.encoding(StringUtil.encoding(DATA, StringUtil.CHARSET_UTF8), StringUtil.CHARSET_UTF8), containsString(DATA));
    	assertThat(StringUtil.encoding(StringUtil.encoding(DATA, StringUtil.CHARSET_SHIFT_JIS), StringUtil.CHARSET_SHIFT_JIS), containsString(DATA_SJIS));
    	assertThat(StringUtil.encoding(StringUtil.encoding(DATA, StringUtil.CHARSET_WIN31J), StringUtil.CHARSET_WIN31J), containsString(DATA));
     }
    
    @Test
    public void testShortString() throws Exception {
        assertThat(StringUtil.shortString(null, 5), containsString(""));
        assertThat(StringUtil.shortString("1234", 5), containsString("1234"));
        assertThat(StringUtil.shortString("12345", 5), containsString("12345"));
        assertThat(StringUtil.shortString("123456", 5), containsString("12..."));
        assertThat(StringUtil.shortString("あいうえ", 5), containsString("あいうえ"));
        assertThat(StringUtil.shortString("あいうえお", 5), containsString("あいうえお"));
        assertThat(StringUtil.shortString("あいうえおか", 5), containsString("あい..."));

        assertThat(StringUtil.shortString("1234", -1), containsString("1234"));
        assertThat(StringUtil.shortString("1234", 0), containsString("1234"));
        assertThat(StringUtil.shortString("1234", 1), containsString("1"));
        assertThat(StringUtil.shortString("1234", 2), containsString("12"));
        assertThat(StringUtil.shortString("1234", 3), containsString("123"));
        assertThat(StringUtil.shortString("1234", 4), containsString("1234"));
        assertThat(StringUtil.shortString("1234", 5), containsString("1234"));
    }

    private String toHexString(byte[] bytes) {
    	StringBuilder sb = new StringBuilder();
    	for(byte b : bytes){
    		sb.append(String.format("%02x ", b));
    	}
    	return sb.toString().trim();
    }
}
