/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

import org.junit.Test;

public class RealmSsoadmResultParserTest {
    @Test
    public void testParse() {
        String input =
            "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n"
            + "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
            + "<head>\n"
            + "    <title>OpenSSO</title>\n"
            + "    <link rel=\"stylesheet\" type=\"text/css\" href=\"com_sun_web_ui/css/css_ns6up.css\" />\n"
            + "    <link rel=\"shortcut icon\" href=\"com_sun_web_ui/images/favicon/favicon.ico\" type=\"image/x-icon\" />\n"
            + "    <script language=\"Javascript\" src=\"js/admincli.js\"></script>\n"
            + "</head>\n"
            + "<body class=\"DefBdy\">\n"
            + "    <div class=\"SkpMedGry1\"><a href=\"#SkipAnchor3860\"><img src=\"com_sun_web_ui/images/other/dot.gif\" alt=\"Jump to End of Masthead\" border=\"0\" height=\"1\" width=\"1\" /></a></div><div class=\"MstDiv\">\n"
            + "    <table class=\"MstTblBot\" title=\"\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n"
            + "        <tr>\n"
            + "        <td class=\"MstTdTtl\" width=\"99%\">\n"
            + "        <div class=\"MstDivTtl\"><img name=\"AMConfig.configurator.ProdName\" src=\"console/images/PrimaryProductName.png\" alt=\"OpenSSO\" border=\"0\" /></div>\n"
            + "        </td>\n"
            + "        <td class=\"MstTdLogo\" width=\"1%\"><img name=\"AMConfig.configurator.BrandLogo\" src=\"com_sun_web_ui/images/other/javalogo.gif\" alt=\"Java(TM) Logo\" border=\"0\" height=\"55\" width=\"31\" /></td>\n"
            + "        </tr>\n"
            + "    </table>\n"
            + "    <table class=\"MstTblEnd\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td><img name=\"RMRealm.mhCommon.EndorserLogo\" src=\"com_sun_web_ui/images/masthead/masthead-sunname.gif\" alt=\"Sun(TM) Microsystems, Inc.\" align=\"right\" border=\"0\" height=\"10\" width=\"108\" /></td></tr></table>\n"
            + "    </div>\n"
            + "    <table class=\"SkpMedGry1\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" width=\"100%\"><tr><td><img src=\"com_sun_web_ui/images/other/dot.gif\" alt=\"Jump to End of Masthead\" border=\"0\" height=\"1\" width=\"1\" /></a></td></tr></table>\n"
            + "    <table border=\"0\" cellpadding=\"10\" cellspacing=\"0\" width=\"100%\"><tr><td></td></tr></table>\n"
            + "\n"
            + "<table cellpadding=5>\n"
            + "<tr>\n"
            + "<td>\n"
            + "\n"
            + "<pre>\n"
            + "<a href=\"/opensso/ssoadm.jsp\">メインページに戻ります。</a><br /><br />&#xa;test1&#xa;test2&#x2f;sub1&#xa;検索が終了しました。&#xa;\n"
            + "<!-- CLI Exit Code: 80 -->\n"
            + "\n"
            + "\n"
            + "</pre>\n"
            + "</td></tr>\n"
            + "</table>\n"
            + "</body></html>\n";
        
        RealmSsoadmResultParser parser = new RealmSsoadmResultParser();

        SsoadmResult result = parser.parse(input);
        
        assertThat(result.getData().get(0), is("test1"));
        assertThat(result.getData().get(1), is("test2/sub1"));
        assertThat(result.getExitCode(), is(80));
    }

    @Test
    public void testParse_RealmZero() {
        String input =
            "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "\n"
            + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n"
            + "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
            + "<head>\n"
            + "    <title>OpenSSO</title>\n"
            + "    <link rel=\"stylesheet\" type=\"text/css\" href=\"com_sun_web_ui/css/css_ns6up.css\" />\n"
            + "    <link rel=\"shortcut icon\" href=\"com_sun_web_ui/images/favicon/favicon.ico\" type=\"image/x-icon\" />\n"
            + "    <script language=\"Javascript\" src=\"js/admincli.js\"></script>\n"
            + "</head>\n"
            + "<body class=\"DefBdy\">\n"
            + "    <div class=\"SkpMedGry1\"><a href=\"#SkipAnchor3860\"><img src=\"com_sun_web_ui/images/other/dot.gif\" alt=\"Jump to End of Masthead\" border=\"0\" height=\"1\" width=\"1\" /></a></div><div class=\"MstDiv\">\n"
            + "    <table class=\"MstTblBot\" title=\"\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n"
            + "        <tr>\n"
            + "        <td class=\"MstTdTtl\" width=\"99%\">\n"
            + "        <div class=\"MstDivTtl\"><img name=\"AMConfig.configurator.ProdName\" src=\"console/images/PrimaryProductName.png\" alt=\"OpenSSO\" border=\"0\" /></div>\n"
            + "        </td>\n"
            + "        <td class=\"MstTdLogo\" width=\"1%\"><img name=\"AMConfig.configurator.BrandLogo\" src=\"com_sun_web_ui/images/other/javalogo.gif\" alt=\"Java(TM) Logo\" border=\"0\" height=\"55\" width=\"31\" /></td>\n"
            + "        </tr>\n"
            + "    </table>\n"
            + "    <table class=\"MstTblEnd\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td><img name=\"RMRealm.mhCommon.EndorserLogo\" src=\"com_sun_web_ui/images/masthead/masthead-sunname.gif\" alt=\"Sun(TM) Microsystems, Inc.\" align=\"right\" border=\"0\" height=\"10\" width=\"108\" /></td></tr></table>\n"
            + "    </div>\n"
            + "    <table class=\"SkpMedGry1\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" width=\"100%\"><tr><td><img src=\"com_sun_web_ui/images/other/dot.gif\" alt=\"Jump to End of Masthead\" border=\"0\" height=\"1\" width=\"1\" /></a></td></tr></table>\n"
            + "    <table border=\"0\" cellpadding=\"10\" cellspacing=\"0\" width=\"100%\"><tr><td></td></tr></table>\n"
            + "\n"
            + "<table cellpadding=5>\n"
            + "<tr>\n"
            + "<td>\n"
            + "\n"
            + "<pre>\n"
            + "<a href=\"/opensso/ssoadm.jsp\">メインページに戻ります。</a><br /><br />&#xa;レルムがありませんでした。&#xa;\n"
            + "<!-- CLI Exit Code: 7 -->\n"
            + "\n"
            + "\n"
            + "</pre>\n"
            + "</td></tr>\n"
            + "</table>\n"
            + "</body></html>\n";
        
        RealmSsoadmResultParser parser = new RealmSsoadmResultParser();

        SsoadmResult result = parser.parse(input);
        
        assertThat(result.getData().size(), is(0));
    }
}
