/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.view.exportpolicy;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

import jp.co.ogis_ri.citk.policytool.common.CommonConstants;
import jp.co.ogis_ri.citk.policytool.service.exportpolicy.ExportPolicyService;
import jp.co.ogis_ri.citk.policytool.view.common.MessageDialog;
import jp.co.ogis_ri.citk.policytool.view.common.ViewExceptionHandler;

import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.MessageSourceAccessor;

/**
 * エクスポート画面の View.
 */
public class ExportPolicyView extends JDialog {
    /**
     * シリアルバージョンID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * エクスポートのサービス.
     */
    @Autowired
    private ExportPolicyService service = null;

    /**
     * メッセージリソース アクセスクラス.
     */
    private MessageSourceAccessor messages = null;

    /**
     * 例外ハンドラ.
     */
    private ViewExceptionHandler viewExceptionHandler =
            new ViewExceptionHandler();

    /**
     * メッセージ表示部のパネル.
     */
    private JPanel messagePanel;

    /**
     * メッセージを表示するラベル.
     */
    private JLabel messageLabel;

    /**
     * 検索条件表示部のパネル.
     */
    private JPanel conditionPanel;

    /**
     * レルム名タイトルラベル.
     */
    private JLabel realmNameTitleLabel;

    /**
     * レルム名テキストフィールド.
     */
    private JTextField realmNameTextField;

    /**
     * グループ名タイトルラベル.
     */
    private JLabel groupNameTitleLabel;

    /**
     * グループ名テキストフィールド.
     */
    private JTextField groupNameTextField;

    /**
     * リソースURLタイトルラベル.
     */
    private JLabel resourceUrlTitleLabel;

    /**
     * リソースURLテキストフィールド.
     */
    private JTextField resourceUrlTextField;

    /**
     * ファイル名表示部パネル.
     */
    private JPanel fileNamePanel;

    /**
     * ファイル名タイトルラベル.
     */
    private JLabel fileNameTitleLabel;

    /**
     * ファイル名テキストフィールド
     */
    private JTextField fileNameTextField;

    /**
     * 参照ボタン.
     */
    private JButton fileReferenceButton;

    /**
     * ボタン表示部パネル.
     */
    private JPanel buttonPanel;

    /**
     * OKボタン.
     */
    private JButton okButton;

    /**
     * キャンセルボタン.
     */
    private JButton cancelButton;

    /**
     * 画面を初期化する.
     */
    public void init() {
        setTitle(messages.getMessage("view.exportView.title"));
        setSize(600, 270);
        setMinimumSize(new Dimension(400, 270));
        setResizable(false);
        setLocationRelativeTo(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[] {0};
        gridBagLayout.rowHeights = new int[] {0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[] {Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};
        getContentPane().setLayout(gridBagLayout);

        messagePanel = new JPanel();
        GridBagConstraints gbc_messagePanel = new GridBagConstraints();
        gbc_messagePanel.insets = new Insets(10, 10, 0, 10);
        gbc_messagePanel.gridx = 0;
        gbc_messagePanel.gridy = 0;
        gbc_messagePanel.fill = GridBagConstraints.BOTH;
        getContentPane().add(messagePanel, gbc_messagePanel);
        messagePanel.setLayout(new FlowLayout(FlowLayout.LEFT, 5, 5));

        messageLabel =
                new JLabel(messages.getMessage("view.exportView.message"));
        messagePanel.add(messageLabel);

        conditionPanel = new JPanel();
        GridBagConstraints gbc_conditionPanel = new GridBagConstraints();
        gbc_conditionPanel.weightx = 1;
        gbc_conditionPanel.weighty = 1;
        gbc_conditionPanel.insets = new Insets(5, 10, 0, 10);
        gbc_conditionPanel.gridy = 1;
        gbc_conditionPanel.gridx = 0;
        gbc_conditionPanel.fill = GridBagConstraints.BOTH;
        getContentPane().add(conditionPanel, gbc_conditionPanel);
        GridBagLayout gbl_conditionPanel = new GridBagLayout();
        gbl_conditionPanel.columnWidths = new int[] {0, 0};
        gbl_conditionPanel.rowHeights = new int[] {0, 0, 0, 0, 0};
        gbl_conditionPanel.columnWeights = new double[] {0.0, Double.MIN_VALUE};
        gbl_conditionPanel.rowWeights = new double[] {0.0, 0.0, 0.0, 0.0, 1.0};
        conditionPanel.setLayout(gbl_conditionPanel);

        realmNameTitleLabel =
                new JLabel(messages.getMessage("view.exportView.realmTitle"));
        GridBagConstraints gbc_realmNameTitleLabel = new GridBagConstraints();
        gbc_realmNameTitleLabel.weightx = 0.0;
        gbc_realmNameTitleLabel.weighty = 0.0;
        gbc_realmNameTitleLabel.insets = new Insets(0, 0, 0, 5);
        gbc_realmNameTitleLabel.fill = GridBagConstraints.BOTH;
        gbc_realmNameTitleLabel.gridx = 0;
        gbc_realmNameTitleLabel.gridy = 0;
        conditionPanel.add(realmNameTitleLabel, gbc_realmNameTitleLabel);

        realmNameTextField = new JTextField();
        GridBagConstraints gbc_realmNameTextField = new GridBagConstraints();
        gbc_realmNameTextField.weightx = 1.0;
        gbc_realmNameTextField.weighty = 0.0;
        gbc_realmNameTextField.insets = new Insets(0, 0, 0, 0);
        gbc_realmNameTextField.fill = GridBagConstraints.BOTH;
        gbc_realmNameTextField.gridx = 1;
        gbc_realmNameTextField.gridy = 0;
        conditionPanel.add(realmNameTextField, gbc_realmNameTextField);
        realmNameTextField.setEditable(false);

        groupNameTitleLabel =
                new JLabel(messages.getMessage("view.exportView.groupTitle"));
        GridBagConstraints gbc_groupNameTitleLabel = new GridBagConstraints();
        gbc_groupNameTitleLabel.weightx = 0.0;
        gbc_groupNameTitleLabel.weighty = 0.0;
        gbc_groupNameTitleLabel.insets = new Insets(5, 0, 0, 5);
        gbc_groupNameTitleLabel.fill = GridBagConstraints.BOTH;
        gbc_groupNameTitleLabel.gridx = 0;
        gbc_groupNameTitleLabel.gridy = 1;
        conditionPanel.add(groupNameTitleLabel, gbc_groupNameTitleLabel);

        groupNameTextField = new JTextField();
        GridBagConstraints gbc_groupNameTextField = new GridBagConstraints();
        gbc_groupNameTextField.weightx = 1.0;
        gbc_groupNameTextField.weighty = 0.0;
        gbc_groupNameTextField.insets = new Insets(5, 0, 0, 0);
        gbc_groupNameTextField.fill = GridBagConstraints.BOTH;
        gbc_groupNameTextField.gridx = 1;
        gbc_groupNameTextField.gridy = 1;
        conditionPanel.add(groupNameTextField, gbc_groupNameTextField);
        groupNameTextField.setEditable(false);

        resourceUrlTitleLabel =
                new JLabel(messages.getMessage("view.exportView.resourceTitle"));
        GridBagConstraints gbc_resourceUrlTitleLabel = new GridBagConstraints();
        gbc_resourceUrlTitleLabel.weightx = 0.0;
        gbc_resourceUrlTitleLabel.weighty = 0.0;
        gbc_resourceUrlTitleLabel.insets = new Insets(5, 0, 0, 5);
        gbc_resourceUrlTitleLabel.fill = GridBagConstraints.BOTH;
        gbc_resourceUrlTitleLabel.gridx = 0;
        gbc_resourceUrlTitleLabel.gridy = 2;
        conditionPanel.add(resourceUrlTitleLabel, gbc_resourceUrlTitleLabel);

        resourceUrlTextField = new JTextField();
        GridBagConstraints gbc_resourceUrlTextField = new GridBagConstraints();
        gbc_resourceUrlTextField.weightx = 1.0;
        gbc_resourceUrlTextField.weighty = 0.0;
        gbc_resourceUrlTextField.insets = new Insets(5, 0, 0, 0);
        gbc_resourceUrlTextField.fill = GridBagConstraints.BOTH;
        gbc_resourceUrlTextField.gridx = 1;
        gbc_resourceUrlTextField.gridy = 2;
        conditionPanel.add(resourceUrlTextField, gbc_resourceUrlTextField);
        resourceUrlTextField.setEditable(false);

        fileNameTitleLabel =
                new JLabel(
                        messages.getMessage("view.exportView.outputFileNameTitle"));
        GridBagConstraints gbc_fileNameTitleLabel = new GridBagConstraints();
        gbc_fileNameTitleLabel.insets = new Insets(0, 0, 0, 5);
        gbc_fileNameTitleLabel.gridx = 0;
        gbc_fileNameTitleLabel.gridy = 3;
        conditionPanel.add(fileNameTitleLabel, gbc_fileNameTitleLabel);

        fileNamePanel = new JPanel();
        GridBagConstraints gbc_fileNamePanel = new GridBagConstraints();
        gbc_fileNamePanel.weightx = 1.0;
        gbc_fileNamePanel.weighty = 0.0;
        gbc_fileNamePanel.insets = new Insets(5, 0, 5, 0);
        gbc_fileNamePanel.fill = GridBagConstraints.BOTH;
        gbc_fileNamePanel.gridx = 1;
        gbc_fileNamePanel.gridy = 3;
        conditionPanel.add(fileNamePanel, gbc_fileNamePanel);
        GridBagLayout gbl_fileNamePanel = new GridBagLayout();
        gbl_fileNamePanel.columnWidths = new int[] {0, 0};
        gbl_fileNamePanel.rowHeights = new int[] {21};
        gbl_fileNamePanel.columnWeights = new double[] {0.0, Double.MIN_VALUE};
        gbl_fileNamePanel.rowWeights = new double[] {Double.MIN_VALUE};
        fileNamePanel.setLayout(gbl_fileNamePanel);

        fileNameTextField = new JTextField();
        GridBagConstraints gbc_fileNameTextField = new GridBagConstraints();
        gbc_fileNameTextField.weightx = 1.0;
        gbc_fileNameTextField.fill = GridBagConstraints.HORIZONTAL;
        gbc_fileNameTextField.insets = new Insets(0, 0, 0, 5);
        gbc_fileNameTextField.gridx = 0;
        gbc_fileNameTextField.gridy = 0;
        fileNamePanel.add(fileNameTextField, gbc_fileNameTextField);

        fileReferenceButton =
                new JButton(
                        messages.getMessage("view.exportView.fileReferenceButton"));
        fileReferenceButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                referenceFile();
            }
        });
        GridBagConstraints gbc_fileReferenceButton = new GridBagConstraints();
        gbc_fileReferenceButton.anchor = GridBagConstraints.NORTHWEST;
        gbc_fileReferenceButton.gridx = 1;
        gbc_fileReferenceButton.gridy = 0;
        fileNamePanel.add(fileReferenceButton, gbc_fileReferenceButton);

        buttonPanel = new JPanel();
        GridBagConstraints gbc_buttonPanel = new GridBagConstraints();
        gbc_buttonPanel.insets = new Insets(0, 10, 10, 10);
        gbc_buttonPanel.fill = GridBagConstraints.BOTH;
        gbc_buttonPanel.gridy = 2;
        gbc_buttonPanel.gridx = 0;
        getContentPane().add(buttonPanel, gbc_buttonPanel);

        okButton = new JButton(messages.getMessage("view.exportView.okButton"));
        okButton.setPreferredSize(new Dimension(120, 32));
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ok();
            }
        });
        buttonPanel.add(okButton);

        cancelButton =
                new JButton(messages.getMessage("view.exportView.cancelButton"));
        cancelButton.setPreferredSize(new Dimension(120, 32));
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                cancel();
            }
        });
        buttonPanel.add(cancelButton);

    }

    /**
     * コンストラクタ.
     * 
     * @param mes メッセージリソース アクセスクラス.
     */
    private ExportPolicyView(MessageSourceAccessor mes) {
        messages = mes;
        init();
    }

    /**
     * この画面の情報を初期化する.
     * 
     * @param realmName レルム名.
     * @param groupName グループ名.
     * @param resourceUrl リソース URL.
     */
    public void initData(String realmName, String groupName, String resourceUrl) {
        realmNameTextField.setText(realmName);
        groupNameTextField.setText(groupName);
        resourceUrlTextField.setText(resourceUrl);
        fileNameTextField.setText("");
    }

    /**
     * 参照ボタンが押された際の処理.
     */
    private void referenceFile() {
        String fileName = fileNameTextField.getText();
        File file = new File(fileName);

        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(file);
        fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        FileFilter filter =
                new FileNameExtensionFilter(
                        messages.getMessage("common.FileNameExtensionFilter.excel"),
                        CommonConstants.EXT_EXCEL);
        fileChooser.setFileFilter(filter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int selected = fileChooser.showSaveDialog(this);
        if (selected == JFileChooser.APPROVE_OPTION) {
            File selectedFile = fileChooser.getSelectedFile();
            fileNameTextField.setText(selectedFile.getAbsolutePath());
        }
    }

    /**
     * OK ボタンが押された際の処理.
     */
    private void ok() {
        // 必要な情報の取得
        String fileName = fileNameTextField.getText();
        if (fileName.length() == 0) {
            MessageDialog.showMessage(this, "I-0401");
            return;
        }

        String realmName = realmNameTextField.getText();
        if (realmName.length() == 0) {
            realmName = null;
        }

        String groupName = groupNameTextField.getText();
        if (groupName.length() == 0) {
            groupName = null;
        }

        String resourceUrl = resourceUrlTextField.getText();
        if (resourceUrl.length() == 0) {
            resourceUrl = null;
        }

        // 拡張子付加済のファイル名.
        String extensionAppendedFileName = getExtensionAppendedFileName();

        // ファイルが存在する場合は確認
        File file = new File(extensionAppendedFileName);
        if (file.exists()) {
            int confirmResult =
                    MessageDialog.showConfirm(this, "C-0402",
                            extensionAppendedFileName);
            if (confirmResult != JOptionPane.YES_OPTION) {
                return;
            }
        }

        // 親ディレクトリが存在しない場合は作成
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            boolean mkdirsResult = parentFile.mkdirs();
            if (!mkdirsResult) {
                MessageDialog.showMessage(this, "E-0403");
                return;
            }
        }

        // エクスポート
        try {
            service.exportPolicy(realmName, groupName, resourceUrl,
                    extensionAppendedFileName);
        } catch (Throwable e) {
            viewExceptionHandler.handle(e);
            return;
        }
        setVisible(false);
    }

    /**
     * キャンセルボタンが押された際の処理.
     */
    private void cancel() {
        setVisible(false);
    }

    /**
     * 現在入力されているファイル名の, 拡張子を付加したファイル名を取得.
     */
    private String getExtensionAppendedFileName() {
        String baseFileName = fileNameTextField.getText();

        // 拡張子取得, "xls" でない場合は付加
        String extension = FilenameUtils.getExtension(baseFileName);
        if (extension != null
                && extension.equalsIgnoreCase(CommonConstants.EXT_EXCEL)) {
            return baseFileName;
        } else {
            return baseFileName + "." + CommonConstants.EXT_EXCEL;
        }
    }
}
