/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.view.about;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.jar.Manifest;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

import jp.co.ogis_ri.citk.policytool.common.util.ManifestUtl;

import org.springframework.context.support.MessageSourceAccessor;

/**
 * バージョン情報画面.
 * 
 */
public class AboutView extends JDialog {
    /**
     * シリアルバージョンID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * MessageSourceAccessor.
     */
    private MessageSourceAccessor messages = null;

    /**
     * バージョン情報を表示する テキストエリア.
     */
    private JTextPane aboutTextArea;

    /**
     * OKボタン.
     */
    private JButton okButton;

    /**
     * 画面の初期化を行う.
     */
    public void init() {
        setTitle(messages.getMessage("view.aboutView.title"));
        setSize(480, 240);
        setMinimumSize(new Dimension(480, 240));
        setLocationRelativeTo(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[] {0};
        gridBagLayout.rowHeights = new int[] {0, 0};
        gridBagLayout.columnWeights = new double[] {Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};
        getContentPane().setLayout(gridBagLayout);

        aboutTextArea = new JTextPane();
        GridBagConstraints gbc_aboutTextField = new GridBagConstraints();
        gbc_aboutTextField.weighty = 1.0;
        gbc_aboutTextField.weightx = 1.0;
        gbc_aboutTextField.insets = new Insets(10, 10, 5, 10);
        gbc_aboutTextField.fill = GridBagConstraints.BOTH;
        gbc_aboutTextField.gridx = 0;
        gbc_aboutTextField.gridy = 0;
        getContentPane().add(aboutTextArea, gbc_aboutTextField);
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setAlignment(attr, StyleConstants.ALIGN_CENTER);
        aboutTextArea.setParagraphAttributes(attr, true);
        aboutTextArea.setBackground(this.getBackground());
        aboutTextArea.setEditable(false);

        Manifest mf = null;
        try {
            mf = ManifestUtl.loadJAR(this.getClass());
        } catch (Exception ex) {
            // NOP
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ManifestUtl.getValue(mf, "Implementation-Title"));
        sb.append("　v" + ManifestUtl.getValue(mf, "Implementation-Version")
                + "\n\n");
        sb.append("Copyright(C) "
                + messages.getMessage("view.aboutView.copyright") + " "
                + ManifestUtl.getValue(mf, "Implementation-Vendor")
                + " All Rights Reserved.\n\n");
        sb.append("Common Public Attribution License Version 1.0 (CPAL)");
        aboutTextArea.setText(sb.toString());

        okButton = new JButton(messages.getMessage("view.aboutView.okButton"));
        GridBagConstraints gbc_okButton = new GridBagConstraints();
        gbc_okButton.weighty = 0.0;
        gbc_okButton.weightx = 1.0;
        gbc_okButton.insets = new Insets(0, 10, 10, 10);
        gbc_okButton.fill = GridBagConstraints.VERTICAL;
        gbc_okButton.gridx = 0;
        gbc_okButton.gridy = 1;
        getContentPane().add(okButton, gbc_okButton);
        okButton.setPreferredSize(new Dimension(120, 32));
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ok();
            }
        });
    }

    /**
     * 新しい PolicySetView を構築する.
     * 
     * @param mes MessageSourceAccessor.
     */
    private AboutView(MessageSourceAccessor mes) {
        messages = mes;
        init();
    }

    /**
     * OKボタン押下時の処理.
     */
    private void ok() {
        setVisible(false);
    }
}
