/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.CommonConstants;
import jp.co.ogis_ri.citk.policytool.common.excel.ExcelPolicyWriter;
import jp.co.ogis_ri.citk.policytool.common.excel.impl.model.ExcelPolicy;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.ExceptionUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;

import org.apache.commons.logging.Log;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Component;

/**
 * ExcelPolicyをファイルに書き込むクラス.
 * 
 */
@Component
public class ExcelPolicyWriterImpl implements ExcelPolicyWriter {
    /**
     * ロガー.
     */
    private static final Log logger =
            LogWrapperFactory.getLog(ExcelPolicyWriterImpl.class);

    /**
     * コンストラクタ.
     */
    public ExcelPolicyWriterImpl() {
        super();
    }

    @Override
    public void write(String fileName, List<Policy> policies) {
        InputStream template = null;
        try {
            template =
                    ExcelPolicyWriterImpl.class.getResourceAsStream(CommonConstants.TMPL_NAME);

            ExcelPolicyBuilder builder = new ExcelPolicyBuilder();
            Workbook workbook = null;
            try {
                workbook = new HSSFWorkbook(template);
            } catch (IOException e) {
                logger.debug(fileName + " : " + e.getMessage(), e);
                throw ExceptionUtil.convertRuntimeException(e);
            }
            // ワークブックラッパを生成
            WorkbookWrapper workbookWrapper = new WorkbookWrapper(workbook);
            workbookWrapper.selectSheet(CommonConstants.TMPL_SHEET_INDEX,
                    CommonConstants.TMPL_SHEET_ROW_OFFSET,
                    CommonConstants.TMPL_SHEET_COLUMN_OFFSET);
            // 　ポリシーをエクスポート用モデルに変換
            builder.addAll(policies);
            List<ExcelPolicy> excelPolicies = builder.build();
            // 変換したモデルをExcelに出力する
            for (ExcelPolicy excelPolicy : excelPolicies) {
                workbookWrapper.writeRow(excelPolicy.toValues());
            }
            // 指定されたファイルに出力する（上書き許可）
            workbookWrapper.saveAs(fileName, true);
        } finally {
            if (template != null) {
                try {
                    template.close();
                } catch (IOException e) {
                    // NOP
                }
            }
        }
    }
}
