/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.CommonConstants;
import jp.co.ogis_ri.citk.policytool.common.excel.ExcelPolicyReader;
import jp.co.ogis_ri.citk.policytool.common.excel.impl.model.ExcelPolicy;
import jp.co.ogis_ri.citk.policytool.common.exception.ExcelPolicyReadException;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.ExceptionUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;

import org.apache.commons.logging.Log;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Component;

/**
 * ExcelPolicyをファイルから読み込むクラス.
 * 
 */
@Component
public class ExcelPolicyReaderImpl implements ExcelPolicyReader {
    /**
     * ロガー.
     */
    private Log logger = LogWrapperFactory.getLog(ExcelPolicyReaderImpl.class);

    /**
     * コンストラクタ.
     */
    public ExcelPolicyReaderImpl() {
        super();
    }

    @Override
    public List<Policy> read(String fileName) throws ExcelPolicyReadException {

        if (fileName.isEmpty()) {
            throw new ExcelPolicyReadException(fileName, "E-0006");
        }

        PolicyBuilder builder = new PolicyBuilder();
        Workbook workbook = null;
        try {
            workbook = WorkbookWrapper.createHSSFWorkbook(fileName);
        } catch (OfficeXmlFileException e) {
            logger.debug(e.getMessage(), e);
            throw new ExcelPolicyReadException(fileName, "E-0007", fileName);
        } catch (FileNotFoundException e) {
            logger.debug(e.getMessage(), e);
            throw new ExcelPolicyReadException(fileName, "E-0008", fileName);
        } catch (IOException e) {
            logger.debug(e.getMessage(), e);
            throw ExceptionUtil.convertRuntimeException(e);
        }
        // ワークブックラッパを生成
        WorkbookWrapper workbookWrapper = new WorkbookWrapper(workbook);
        workbookWrapper.selectSheet(CommonConstants.TMPL_SHEET_INDEX,
                CommonConstants.TMPL_SHEET_ROW_OFFSET,
                CommonConstants.TMPL_SHEET_COLUMN_OFFSET);
        // 　エクスポート用モデルをポリシーに変換
        while (workbookWrapper.existRow()) {
            List<?> values = workbookWrapper.readRow(ExcelPolicy.ITEM_SIZE);
            // 文字列リストに変換.
            List<String> stringValues =
                    new ArrayList<String>(ExcelPolicy.ITEM_SIZE);
            for (Object value : values) {
                try {
                    stringValues.add((String) value);
                } catch (ClassCastException e) {
                    logger.debug(e.getMessage(), e);
                    throw new ExcelPolicyReadException(fileName, e, "E-0009");
                }
            }

            // ExcelPolicy 作成.
            ExcelPolicy excelPolicy = ExcelPolicyFactory.create(stringValues);
            builder.add(excelPolicy);
        }
        return builder.build();
    }
}
