/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.excel;

import java.util.List;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;

/**
 * ファイルから ExcelPolicy を読み込むインターフェース.
 * 
 */
public interface ExcelPolicyReader {
    /**
     * 指定されたファイル名のEXCEL形式のファイルからポリシー定義を読み込む.
     * 
     * @param fileName ファイル名.
     * @return ポリシー リスト.
     */
    List<Policy> read(String fileName);
}
