/* $Id: cnkf.c,v 1.4 2007/01/14 08:54:30 ha-tan Exp $ */

#include <stdio.h>
#include <stdlib.h>

unsigned char *nkf(char *[], int, unsigned char *, size_t);

static int nkf_getc(FILE *);
static int nkf_ungetc(int, FILE *);
static int nkf_putchar(int);
static void nkf_init();
static void nkf_option(char *);
static unsigned char *nkf_conv(unsigned char *, size_t);

#define INIT_BUFSIZE 64

struct buf {
	unsigned char *ptr;
	size_t len;
	size_t index;
};

static struct buf ibuf;
static struct buf obuf;
static int error_occur;

static int
nkf_getc(FILE *fp)
{
	if (ibuf.index >= ibuf.len) 
		return EOF;
	else
		return ibuf.ptr[ibuf.index++];
}

static int
nkf_ungetc(int c, FILE *fp)
{
	if (ibuf.index == 0) {
		return EOF;
	} else {
		ibuf.index--;
		return c;
	}
}

static int
nkf_putchar(int c)
{
	if (obuf.index >= obuf.len) {
		obuf.len *= 2;
		obuf.ptr = realloc(obuf.ptr, obuf.len);
		if (obuf.ptr == NULL) {
			error_occur = 1;
			return EOF;
		}
	}
	obuf.ptr[obuf.index++] = c;
	
	return c;
}

#undef getc
#undef ungetc
#define getc(fp)       nkf_getc(fp)
#define ungetc(c, fp)  nkf_ungetc(c, fp)

#undef putchar
#define putchar(c)     nkf_putchar(c)

#define PERL_XS 1
#include "../contrib/nkf-utf8/config.h"
#include "../contrib/nkf-utf8/utf8tbl.c"
#include "../contrib/nkf-utf8/nkf.c"

static void
nkf_init()
{
	reinit();
}

void
nkf_option(char *opt)
{
    options(opt);
}

unsigned char *
nkf_conv(unsigned char *src, size_t src_len)
{
	ibuf.ptr   = src;
	ibuf.len   = src_len;
	ibuf.index = 0;

	obuf.ptr   = malloc(INIT_BUFSIZE);
	if (obuf.ptr == NULL) 
		goto error;
	obuf.len   = INIT_BUFSIZE;
	obuf.index = 0;
	obuf.ptr[0] = '\0';
	
	if (x0201_f == WISH_TRUE)
		x0201_f = (!iso2022jp_f) ? TRUE : NO_X0201;

	error_occur = 0;
	kanji_convert(NULL);
	if (error_occur)
		goto error;

	obuf.ptr[obuf.index] = '\0';
	return obuf.ptr;
	
  error:
	free(obuf.ptr);
	return NULL;
}

unsigned char *
nkf(char *opts[], int nopts, unsigned char *src, size_t src_len)
{
	int i;

	nkf_init();

	for (i = 0; i < nopts; i++) {
		nkf_option(opts[i]);
	}

	return nkf_conv(src, src_len);
}
