#ifndef __HADDOCK__
-- $Id: Misc.hs,v 1.5 2007/01/02 09:41:56 ha-tan Exp $
#endif
module Cinnamon.Misc (
  groupn,
  join,
  split,
  strip,
  starling,
  basename,
  dirname,
  showComma,
  readFiles,
  readBinaryFiles,
  p,
  t,
  t'
) where

import Data.Char (isSpace)
import Data.List (intersperse)
import Debug.Trace (trace)
import System.IO (stdin, openBinaryFile, IOMode (ReadMode),
                  hSetBinaryMode, hGetContents)

-- | 個数nとリストxsを与えて、xsの要素を
-- n個ずつまとめたリストを返します。
groupn :: Int -> [a] -> [[a]]
groupn _ [] = []
groupn n s
  | n < 1     = error "groupn: n < 1."
  | otherwise = s1 : groupn n s2
  where
    (s1, s2) = splitAt n s

-- | リストxsとリストのリストxxsを与えて、xxsの各要素をxsを間に
-- はさみながら連結したリストを返します。
join :: [a] -> [[a]] -> [a]
join = (concat .) . intersperse

-- | ある要素xとリストxsを与えて、xsをxで分離したリストを返します。
split :: Eq a => a -> [a] -> [[a]]
split _ [] = []
split x xs = 
  case xs2 of
    []       -> [xs1]
    (_ : []) -> xs1 : [] : []
    _        -> xs1 : split x (tail xs2)
  where
    (xs1, xs2) = span (/= x) xs

-- | 文字列を与えて、その両端の空白文字(Data.Char.isSpaceで
-- Trueが返る文字)を削除した文字列を返します。
strip :: String -> String
strip = stripR . stripL
  where
    stripL = dropWhile isSpace
    stripR = reverse . stripL . reverse

-- | Sコンビネータ。
starling :: (a -> b -> c) -> (a -> b) -> a -> c
starling f g x = f x (g x)

-- | パス名を与えて、ディレクトリを削除したファイル名を返します。
-- 拡張子を削除する機能は未サポートです。
basename :: FilePath -> FilePath
basename = reverse . takeWhile (not . isPathSeparator) . reverse

-- | パス名を与えて、ディレクトリを返します。
dirname :: FilePath -> FilePath
dirname = 
  reverse . dropWhile isPathSeparator .
    dropWhile (not . isPathSeparator) . reverse

isPathSeparator :: Char -> Bool
isPathSeparator c = c == '/' || c == '\\'

-- | 整数を与えて、それを3桁ずつカンマで区切った文字列を返します。
showComma :: Integral i => i -> String
showComma = reverse . join "," . groupn 3 . reverse . show

-- | ファイル名のリストを与えて、そのファイルの内容を連結した
-- 文字列を返します。
-- ファイル名のリストが空の場合には、標準入力から読み込みます。
-- Rubyで言うところのARGFのようなものです。
readFiles :: [FilePath] -> IO String
readFiles []    = getContents
readFiles files = return . concat =<< mapM readFile files

-- | ファイル名のリストを与えて、そのファイルの内容をバイナリとして
-- 読み込み、それを連結した文字列を返します。
-- ファイル名のリストが空の場合には、標準入力から読み込みます。
-- Rubyで言うところのARGFのようなものです。
readBinaryFiles :: [FilePath] -> IO String
readBinaryFiles [] = do
  hSetBinaryMode stdin True 
  getContents
readBinaryFiles files =
  return . concat =<< mapM f files
  where
    f file = hGetContents =<< openBinaryFile file ReadMode

-- | printと同じです。
p :: Show a => a -> IO ()
p = print

-- | 簡易トレース関数。
-- Debug.Traceのtraceを利用しています。
-- 副作用がないのでどこにでも埋め込めますが、使用には注意が必要です。
t :: (Show a) => a -> a
t = t' ""

-- | 簡易トレース関数。出力する文字列を指定することができます。
-- Debug.Traceのtraceを利用しています。
-- 副作用がないのでどこにでも埋め込めますが、使用には注意が必要です。
t' :: (Show a) => String -> a -> a
t' s a = trace (s ++ show a) a
