#ifndef __HADDOCK__
-- $Id: Crc.hs,v 1.6 2007/01/02 09:41:56 ha-tan Exp $
#endif
module Cinnamon.Crc (crc32) where

import Data.Array (Array, (!), listArray)
import Data.Bits ((.&.), xor, shiftR)
import Data.Char (ord)
import Data.Word (Word32)

-- | 文字列を与えて、CRC32を計算します。
-- 参照: <http://www.ietf.org/rfc/rfc1952.txt>
crc32 :: String -> Word32
crc32 = xor 0xffffffff . foldl crc' 0xffffffff
  where
    crc' :: Word32 -> Char -> Word32
    crc' c x = 
      let i = (xor c $ fromIntegral $ ord x) .&. 0xff
      in xor (table ! i) $ shiftR c 8

    table :: Array Word32 Word32
    table =
      listArray (0, 255) $ map (\ n -> foldl table' n [0 .. 7]) [0 .. 255]
      where
        table' :: Word32 -> Int -> Word32
        table' c _
          | c .&. 1 == 0 = shiftR c 1
          | otherwise    = xor 0xedb88320 $ shiftR c 1
