#ifndef __HADDOCK__
-- $Id: Bsearch.hs,v 1.5 2007/01/02 09:41:56 ha-tan Exp $
#endif
module Cinnamon.Bsearch (bsearchFirst, bsearchFirstBy) where

import Data.Array (Array, Ix, (!), bounds)

-- | 配列をバイナリサーチして、その結果をMaybeとして返します。
-- 複数の要素がマッチする場合には、先頭の要素を返します。
bsearchFirst :: (Integral i, Ix i, Ord e) => Array i e -> e -> Maybe i
bsearchFirst ary key = bsearchFirstBy compare ary key

-- | 配列をバイナリサーチして、その結果をMaybeとして返します。
-- 複数の要素がマッチする場合には、先頭の要素を返します。
-- bsearchFirstと違い、比較用の関数を指定する必要があります。
bsearchFirstBy :: (Integral i, Ix i, Ord e) => (e -> e -> Ordering) ->
                       Array i e -> e -> Maybe i
bsearchFirstBy comp ary key = bsearch (min - 1) (max + 1)
  where
    min = fst $ bounds ary
    max = snd $ bounds ary

    bsearch low high
      | isJustOne && (high >= max + 1)             = Nothing
      | isJustOne && (comp key (ary ! high) /= EQ) = Nothing
      | isJustOne                                  = Just high
      | comp key (ary ! mid) == GT = bsearch mid high
      | otherwise                  = bsearch low mid
      where
        isJustOne = low + 1 == high
        mid = (low + high) `div` 2
