#!/bin/sh


do_ref()
{
	cat <<EOT
Content-type: text/html

<script>
history.back();
</script>
<html><body></body></html>
EOT
}


do_term()
{
	local zoom
	local res_X
	res_X=$(cat /tmp/res_X)
	[ $res_X -le 800 ] && res_X=800
	zoom=$(echo "scale=2; $res_X / 400" | bc)
	cd /home/okajima
	gnome-terminal --zoom=$zoom
}

doit()
{
	export USER=okajima
	export HOME=/home/okajima
	export DISPLAY=:0
	export PATH=/bin:/sbin:/usr/bin:/usr/sbin
	#nohup metacity &
	#nohup gnome-terminal &
	
	/tmp/usb/okajima/small_screen.sh
	if ps ax -o cmd | grep -vq ^[m]etacity
	then
		metacity &
		pid=$!
	fi
	do_term
	[ -n "$pid" ] && kill $pid
	/tmp/usb/okajima/full_screen.sh
}

do_ref
doit

