#!/bin/sh



# Trace.
T()
{
	echo CHROMIUM $* >/dev/kmsg
}


# exec command with trace and time output.
X()
{
	local ret
	echo CHROMIUM start $* >/dev/kmsg
	$*
	ret=$?
	echo CHROMIUM end $* >/dev/kmsg
	return $ret
}


# Print error and enter shell.
ERR()
{
	echo $*
	/bin/bash
}




# eliminate bogo mips because it changes on each boot.
get_pc_code_sub()
{
	(
	cat /proc/cpuinfo | grep -v MHz | grep -v bogo
	cat /proc/meminfo | grep MemTotal
	#cat /proc/cmdline
	) | md5sum | cut -b1-4
}


# makes 4digit code. the code is always same when the pc is same.
# xxxx -> not vesa
# xxxxV -> vesa
get_pc_code()
{
	local str
	str=$(get_pc_code_sub)
	if /tmp/usb/okajima/use_vesa.sh
	then
		echo PC-${str}V
	else
		echo PC-${str}
	fi
}


del_char()
{
	sed -e 's/[^a-zA-Z0-9]/_/g' |
	sed -e 's/__/_/g' |
	sed -e 's/__/_/g' |
	sed -e 's/^_//g' |
	sed -e 's/_$//g'
}


get_pc_name()
{
	(
	echo -n $(dmidecode -s baseboard-manufacturer)
	echo -n $(dmidecode -s baseboard-product-name)
	echo -n $(dmidecode -s baseboard-version)
	) | del_char
}


get_cpu_name()
{
	(
	dmidecode -s processor-version
	) | del_char
}


# IPv6 slows some network detections.
do_disable_ipv6()
{
	local str
	# Disable ipv6 to faster address look up.
	for str in /proc/sys/net/ipv6/conf/*/disable_ipv6
	do
		echo 1 > $str
	done
}


do_add_hosts()
{
	local str
	cat <<'EOT' >>/etc/hosts

127.0.0.1 localhost
127.0.0.1 homepage
127.0.1.1 ubuntu

# The following lines are desirable for IPv6 capable hosts
::1     ip6-localhost ip6-loopback
fe00::0 ip6-localnet
ff00::0 ip6-mcastprefix
ff02::1 ip6-allnodes
ff02::2 ip6-allrouters
ff02::3 ip6-allhosts

EOT
	str="127.0.0.1 $(cat /etc/hostname)"
	echo $str >>/etc/hosts
}




make_xorg_conf_vesa()
{
	cat <<'EOT' >/etc/X11/xorg.conf
Section "Device"
	Identifier	"Configured Video Device"
	Driver		"vesa"
EndSection

Section "Monitor"
	Identifier	"Configured Monitor"
EndSection

Section "Screen"
	Identifier	"Default Screen"
	Monitor		"Configured Monitor"
	Device		"Configured Video Device"
EndSection
EOT
}

do_make_xorg_conf()
{
	/tmp/usb/okajima/use_vesa.sh && make_xorg_conf_vesa
}

_do_make_blacklist()
{
	cat <<'EOT' >/etc/modprobe.d/okajima.conf
blacklist vga16fb
blacklist fbcon
#blacklist tileblit
#blacklist font
#blacklist bitblit
#blacklist softcursor
alias fbcon off
alias vga16fb off
install fbcon /bin/true
install vga16fb /bin/true
EOT
}


do_make_blacklist()
{
	cat <<'EOT' >/etc/modprobe.d/okajima.conf
blacklist vga16fb
blacklist fbcon
EOT
}


do_mount_all()
{
	mount -t proc none /proc
	mount -t sysfs none /sys
	mount -t devtmpfs none /dev
	mkdir /dev/pts
	mount -t devpts none /dev/pts
	mkdir /dev/shm
	mount -t tmpfs none /dev/shm
	chmod 1777 /dev/shm
	mount -t tmpfs none /home
}


do_adduser()
{
	echo "okajima:x:1000:1000::/home/okajima:/bin/bash" >>/etc/passwd
	echo "okajima:x:1000:" >>/etc/group
	mkdir -p /home/okajima
	#mkdir -p /home/okajima/Desktop
	#mkdir -p /home/okajima/.config
	#cp /tmp/usb/okajima/xdg_user_dirs.dirs /home/okajima/.config/user-dirs.dirs
	chown -R okajima:okajima /home/okajima
}


do_fontconfig()
{
	ls -laR /home/okajima/ >/tmp/fontconfig.1
	[ -f /tmp/usb/save/fontconfig.tgz ] || return
	sudo -u okajima tar -C /home/okajima -xzf /tmp/usb/save/fontconfig.tgz
	ls -laR /home/okajima >/tmp/fontconfig.2
}


do_vals()
{
	DATE=$(date +"%Y%m%d%H%M%S")
	#PC_NAME=$(get_pc_name)
	#CPU_NAME=$(get_cpu_name)
	PC_CODE=$(get_pc_code)
	echo $DATE >/tmp/DATE
	echo $PC_NAME >/tmp/PC_NAME
	echo $CPU_NAME >/tmp/CPU_NAME
	echo $PC_CODE >/tmp/PC_CODE
	#echo "/home/okajima/chrome/" >/tmp/CHROME_PATH
	echo "/tmp/chrome/" >/tmp/CHROME_PATH
}


do_hostname()
{
	hostname $(cat /etc/hostname)
}

do_read_all()
{
	cat /tmp/usb/okajima/* >/dev/null
	cat /tmp/usb/bin/* >/dev/null
}

do_it()
{
	T START ALL
	T mount_all
	do_mount_all
	T read_all
	do_read_all
	T vals
	do_vals
	T hostname
	do_hostname
	T adduser
	do_adduser
	T fontconfig
	do_fontconfig
	T add_hosts
	do_add_hosts
	T make_xorg_conf
	do_make_xorg_conf
	T disable_ipv6
	do_disable_ipv6
	T make_blacklist
	do_make_blacklist
	T init end
}


do_it



