#!/bin/sh

# Trace.
T()
{
	echo CHROMIUM $* >/dev/kmsg
}


get_list()
{
	local a b c
	ureadahead --dump $1 |
	grep ^/ |
	while read a c b
	do
		echo $a
	done | grep -v "/usr/share/fonts/truetype"
}


do_readahead()
{
	while :
	do
		[ -f "$1" ] || return
		# when get_list returns nothing, 
		# cat hangs if no dummy.
		T readahead start $1
		get_list $1 | xargs cat /dummy >/dev/null
		T readahead end $1
		shift || return
	done
}

do_readahead_chrome_1()
{
	local pfn_squash
	T readahead chrome start
	pfn_squash=$(cat /tmp/PFN_SQUASH)
	[ -f "$pfn_squash" ] && cat $pfn_squash >/dev/null
	T readahead chrome end
}



do_readahead_chrome_2()
{
	T readahead chrome start
	ureadahead /tmp/readahead/home.okajima.chrome.pack
	T readahead chrome end
}

readahead_chrome()
{
	[ -f /tmp/usb/config/readahead_chrome ] ||
	grep -q "[^a-z]readahead_chrome" /proc/cmdline
}

out_debug_info()
{
	local pfn
	local fn
	for pfn in /tmp/readahead/*
	do
		fn=$(basename $pfn)
		ureadahead --dump $pfn >/tmp/readahead/$fn.out
	done
}

doit()
{
	#out_debug_info
	do_readahead /tmp/readahead/pack
	readahead_chrome && do_readahead_chrome_1
}

doit

