#!/bin/sh


ERR()
{
	echo ERR $*
	exit 1
}


do_sub()
{
	local pfn
	pfn=$1
	shift
	find $pfn -maxdepth 1 -type f  | xargs $*
}


doit()
{
	local tar_dir
	local tar_base
	TMP="/tmp/chromium.$DATE"
	tar_dir=$(dirname $TMP)
	tar_base=$(basename $TMP)
	mkdir $TMP
	mkdir $TMP/files
	mkdir $TMP/files/bin
	mkdir $TMP/files/scripts
	[ -d $TMP/files/scripts ] || ERR "no tmp dir"
	cp $FROM/okajima/* $TMP/files/scripts
	cp $FROM/bin/* $TMP/files/bin
	cp $FROM/okajima/install.sh $TMP
	echo $DATE >$TMP/files/scripts/ver
	cat <<EOT >$TMP/README

Chromium + Ubuntu :
By Okajima, Jun. Tokyo, Japan.
http://www.chromium.jp/

How to install:

Preface:
My Chromium is implemented as a patch to Ubuntu USB.
So, you need Ubuntu USB stick first.

Required PC:
Any PC is Okay, if you can run Ubuntu USB.
Basically, the spec would be like this:
Mem : More than 512MB.
CPU : More than 1GHz.
HDD : Not necessary.
BIOS : MUST SUPPORT USB BOOT.


1. Prepare these.
  - USB memory. 1GB or more. High speed type is recommended.
  - Ubuntu 10.04 Lucid Lynx Live CD.

2. Boot a live CD.

3. Make a bootable USB.
[Administration] -> [Create a USB startup disk]
Store/Discard -> both works, but "Discard" recommend.

4. Confirm the USB really boots.
If this does not boot, my chromium would not work.

5. Install Chromium.
You do this either on CD or on USB.
The steps are almost same, except USB path.

If you do on Live CD:
[Lucid]\$ tar -xvzf chromium.$DATE.tgz
[Lucid]\$ cd chromium.$DATE
[Lucid]\$ sudo apt-get install squashfs-tools
[Lucid]\$ ./install.sh ./ /media/[your USB path]

If you do on USB boot:
[Lucid]\$ tar -xvzf chromium.$DATE.tgz
[Lucid]\$ cd chromium.$DATE
[Lucid]\$ sudo apt-get install squashfs-tools
[Lucid]\$ sudo mount -o remount,rw /cdrom
[Lucid]\$ sudo ./install.sh ./ /cdrom
( In USB boot, the stick is mounted on /cdrom,
  and you need to be root to write it. )

6. Then reboot it.


ABSOLUTELY NO WARRANTY.
Copyright(C) 2010- Digital Infra, Inc. All Rights Reserved.

EOT
	do_sub $TMP/files/bin/ chmod 755
	do_sub $TMP/files/scripts/ chmod 755
	chmod 755 $TMP/install.sh
	tar -C $tar_dir -czf $TO/chromium.$DATE.tgz $tar_base || ERR "tar"
}


[ -f /tmp/make_release ] && exit 0
DATE=$(cat /tmp/DATE)
FROM=$1
TO=$2
[ -x "$FROM/okajima/startup.sh" ] || ERR "no param1"
[ -d "$TO" ] || ERR "no param2"
touch /tmp/make_release
doit
sync

