#!/bin/sh


#
# The overview of root fs mount:
# usb:/casper/filesystem.squash -> loop+squash -> initrd:/squash
# if fuse
#     initrd:/squash -> fuse -> initrd:/fuse/squash (=DIR_RO)
# if fake_union
#     initrd:DIR_RO -> tmpfs -> initrd:DIR_RW
# if real union
#     initrd:DIR_RO -> aufs/cow -> initrd:DIR_RW
#

T()
{
	echo CHROMIUM $* >/dev/kmsg
}


X()
{
	local ret
	echo CHROMIUM start $* >/dev/kmsg
	$*
	ret=$?
	echo CHROMIUM end $* >/dev/kmsg
	return $ret
}


ERR()
{
	echo $*
	/bin/sh
}



do_init()
{
	mount -t proc none /proc
	mount -t devtmpfs none /dev
	T init2_usb start
	# bind mount does not work on initrd.
	# so, we do it on tmpfs.
	mount -t tmpfs none /tmp
	T $(cat /proc/cmdline)
	DIR_RO="/squash"
}


do_loopback()
{
	mkdir /squash
	X modprobe squashfs
	X dd if=$(cat /usb_dev) of=/dev/null bs=1024 count=5000
	X mount -o loop /usb/casper/filesystem.squashfs /squash
	[ -x /squash/sbin/init ] || ERR
}


allcat()
{
	local dir
	find $1 -type d |
	grep -v /proc |
	grep -v /dev |
	while read dir
	do
		cat $dir/* >/dev/null
	done
}


do_toram()
{
	X cat /usb/casper/filesystem.squashfs >/dev/null
	X cat /usb/chrome-linux.[0-9]*.zip >/dev/null
	X allcat /squash
}



do_fuse()
{
	if grep -q [^a-z]fuse /proc/cmdline
	then
		mkdir /fuse
		mkdir /fuselog
		mount -t tmpfs none /fuselog
		/usb/bin/fusexmp -d -o allow_other /fuse 2>/fuselog/log &
		#/usb/bin/fusexmp -o allow_other /fuse
		[ -d /fuse/squash/bin ] || sleep 0.01
		[ -d /fuse/squash/bin ] || sleep 0.1
		[ -d /fuse/squash/bin ] || sleep 0.2
		[ -d /fuse/squash/bin ] || sleep 0.5
		[ -d /fuse/squash/bin ] || ERR
		DIR_RO=/fuse/squash
	fi
}


fake_union_sub()
{
	T fake_union $1 start
	[ -n "$DIR_RO" ] || ERR
	mkdir /tmp/$1
	#mount -t tmpfs none /tmp/$1
	cp -a /squash/$1 /tmp/
	mount -o bind /tmp/$1 $DIR_RO/$1
	T fake_union $1 end
}


real_union()
{
	mkdir /chroot
	mkdir /cow
	mount -t tmpfs none /cow
	modprobe aufs
	mount -t aufs -o br=/cow=rw:$DIR_RO=ro none /chroot
	DIR_RW=/chroot
	[ -x $DIR_RW/sbin/init ] || ERR
}


fake_union()
{
	mount -t tmpfs none $DIR_RO/tmp || ERR
	chmod 1777 $DIR_RO/tmp || ERR
	fake_union_sub /etc
	#fake_union_sub /var
	#fake_union_sub /home
	#fake_union_sub /root
	mount -t tmpfs none $DIR_RO/home
	mount -t tmpfs none $DIR_RO/root
	mount -t tmpfs none $DIR_RO/var/run
	mount -t tmpfs none $DIR_RO/var/log
	mount -t tmpfs none $DIR_RO/var/lock
	mount -t tmpfs none $DIR_RO/var/cache
	mount -t tmpfs none $DIR_RO/var/spool
	mount -t tmpfs none $DIR_RO/var/lib/dbus
	mount -t tmpfs none $DIR_RO/var/lib/ureadahead
	DIR_RW=$DIR_RO
}





do_union()
{
	[ -d $DIR_RO/bin ] || ERR
	if grep -q [^a-z]fake_union /proc/cmdline
	then
		fake_union
	else
		real_union
	fi
	[ -n "$DIR_RW" ] || ERR
	[ -x $DIR_RW/sbin/init ] || ERR
}


do_rest()
{
	if [ -d /fuselog ]
	then
		mkdir $DIR_RW/tmp/fuselog || ERR
		mount -o bind /fuselog $DIR_RW/tmp/fuselog
	fi
	mkdir $DIR_RW/tmp/initrd
	cp /init* /*.sh $DIR_RW/tmp/initrd
	cp /usb_dev $DIR_RW/tmp/
	mkdir $DIR_RW/tmp/usb
	mount -o bind /usb $DIR_RW/tmp/usb
	[ -x $DIR_RW/tmp/usb/okajima/startup.sh ] || ERR
	[ -s $DIR_RW/etc/passwd ] || ERR
	if [ -d /cow ]
	then
		mkdir $DIR_RW/tmp/dontchange/
		chmod 700 $DIR_RW/tmp/dontchange/
		mkdir $DIR_RW/tmp/dontchange/cow
		mount -o bind /cow $DIR_RW/tmp/dontchange/cow
	fi
	exec chroot $DIR_RW /tmp/usb/okajima/startup.sh
	/bin/sh
}


do_init
do_loopback
#do_toram
do_fuse
do_union
do_rest


