#!/bin/sh



esc_char()
{
	sed -e 's/\&/\&amp;/g' |
	sed -e 's/</\&lt;/g' |
	sed -e 's/>/\&gt;/g'
}


dmesg_chromium()
{
	cat /tmp/dmesg | /tmp/usb/okajima/dmesg_filter.sh | grep CHROMIUM
}


dmesg_normal()
{
	cat /tmp/dmesg | /tmp/usb/okajima/dmesg_filter.sh
}


dmesg_stat()
{
	cat /tmp/dmesg | /tmp/usb/okajima/dmesg_filter.sh | grep "CHROMIUM CPU"
}


boot_time()
{
	local boot_time
	local bios_time
	boot_time=$(cat /tmp/boot_time)
	bios_time=$(cat /tmp/bios_time)
	echo "BOOT $boot_time BIOS $bios_time"
}


usb_speed()
{
	local pfn
	if [ ! -f /tmp/usb_speed ]
	then
		#pfn=$(cat /tmp/chrome-linux_pfn)
		pfn=$(cat /tmp/usb_dev)
		dd if=$pfn of=/dev/null iflag=direct bs=4M count=10 >/tmp/usb_speed 2>&1 
	fi
	cat /tmp/usb_speed
}


xorg_drv()
{
	grep -o modules/drivers.* /var/log/Xorg.0.log |
	sed 's#modules/drivers/##g' |
	head -1
}


do_log_ps()
{
	if [ -f /tmp/LOG_PS_PID ]
	then
		cat <<EOT
		<a href="log_ps.html">log_ps.html</a><br>
EOT
	else
		cat <<EOT
		<s>log_ps.html</s><br>
EOT
	fi
}


cmd()
{
	cat <<EOT
<hr>
<b>$*</b><br>
$($* 2>&1 | esc_char)
<br>
<br>
<br>
EOT
}


do_homepage()
{
	cat <<EOT
Content-Type: text/html

<html>
<body>
<table border="0">

<tr>
<td> </td>
<td>

<br>
<font size="7">
<a href="http://www.chromium.jp/">www.chromium.jp</a><br>
</font>
Ver $(cat /tmp/usb/okajima/ver).<br>
<br>
<br>
<br>
Credits:<br>
Modified by Okajima, Jun. Tokyo, Japan.<br>
Copyright(C) 2010-
<a href="http://www.digitalinfra.co.jp/">Digital Infra, Inc.</a>
Tokyo, Japan. All rights reserved.<br>
<b>ABSOLUTELY NO WARRANTY.</b>
<a href="http://www.gnu.org/licenses/gpl.html">GPL</a><br>
<br>
<br>
<hr>
<br>
$(do_log_ps)
<a href="big_char.cgi">big_char</a><br>
<br>
<br>
<pre>
$(cmd boot_time)
$(cmd xorg_drv)
$(cmd date)
$(cmd cat /proc/cmdline)
$(cmd uname -a)
$(cmd top -b -n 1)
$(cmd printenv)
$(cmd ifconfig -a)
$(cmd route -n)
$(cmd netstat -an)
$(cmd cat /etc/resolv.conf)
$(cmd cat /etc/hosts)
$(cmd dmesg_chromium)
$(cmd dmesg_stat)
$(cmd dmesg_normal)
$(cmd ps aux)
$(cmd pstree)
$(cmd lsmod)
$(cmd cat /proc/meminfo)
$(cmd cat /proc/cpuinfo)
$(cmd lspci)
$(cmd mount)
$(cmd cat /proc/mounts)
$(cmd losetup -a)
$(cmd usb_speed)
</pre>
</td>
</tr>
</table>
</body>
</html>
EOT
}


doit()
{
	export PATH=/bin:/sbin:/usr/bin:/usr/sbin
	/tmp/usb/okajima/boot_time.sh
	/tmp/usb/okajima/full_screen.sh
	dmesg >/tmp/dmesg
	do_homepage
}

doit 2>>/tmp/cgi.log


