#!/bin/sh



get_param()
{
	cat $PFN | grep "^$1" |
	awk '{print $2}'
}


get_mac1()
{
	ifconfig -a |
	grep "^$1" |
	awk '{print $5}' |
	sort | uniq | head -1
}


get_mac2()
{
	 arping -w 1 -c 1 -D -I $1 $2 |
	 grep "reply from" |
	 sed 's/\[//g' |
	 sed 's/\]//g' |
	 awk '{print $5}' |
	 sort | uniq | head -1
}

show_vals()
{
	echo magic $magic
	echo mac1_conf $mac1_conf
	echo mac2_conf $mac2_conf
	echo mac1_pc $mac1_pc
	echo mac2_pc $mac2_pc
	echo ip_conf $ip_conf
	echo if_conf $if_conf
	echo gw_conf $gw_conf
	echo dns_conf $dns_conf
}

ifconfig_up()
{
	ifconfig $1 up && return 0
	sleep 0.1
	ifconfig $1 up && return 0
	sleep 0.2
	ifconfig $1 up && return 0
	sleep 0.3
	ifconfig $1 up && return 0
	sleep 1
	ifconfig $1 up && return 0
}

get_config()
{
	magic=$(get_param magic)
	[ $magic = "okajima" ] || return 1
	mac1_conf=$(get_param mac1)
	mac2_conf=$(get_param mac2)
	ip_conf=$(get_param fixed-address)
	if_conf=$(get_param interface)
	gw_conf=$(get_param routers)
	dns_conf=$(get_param domain-name-servers)
	ifconfig_up $if_conf
	mac1_pc=$(get_mac1 $if_conf)
	[ -n "$mac1_pc" ] || return 1
	mac2_pc=$(get_mac2 $if_conf $gw_conf)
	[ -n "$mac2_pc" ] || return 1
	[ $mac1_pc = $mac1_conf ] || return 1
	[ $mac2_pc = $mac2_conf ] || return 1
}

set_config()
{
	ifconfig $if_conf $ip_conf up || return 1
	route add default gw $gw_conf || return 1
	cat <<EOT >/etc/resolv.conf
nameserver $dns_conf
EOT
}

doit()
{
	get_config || return 1
	set_config || return 1
	return 0
}

for PFN in $1/dhcp*
do
	[ -f "$PFN" ] || exit 1
	doit && exit 0
done



