/*
    ChibiOS - Copyright (C) 2006..2018 Giovanni Di Sirio

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

/**
 * @file    nsc_flash.S
 * @brief   Non-secure callable area configuration.
 *
 * @defgroup NSC_FLASH_CONFIGURATION
 * @{
 */

/*===========================================================================*/
/* Module constants.                                                         */
/*===========================================================================*/

/*===========================================================================*/
/* Module pre-compile time settings.                                         */
/*===========================================================================*/

/*===========================================================================*/
/* Code section.                                                             */
/*===========================================================================*/

#if !defined(__DOXYGEN__)

        .syntax unified
        .cpu    cortex-m33
        .thumb

        .section    .nsc_flash, "ax"
        .align      4
        .globl      __nsc_entries
__nsc_entries:
        .thumb_func
__nsc_entry1:
        sg
.here:
        b           .here

        .section    .ns_flash, "ax"
        .align      4
        .globl      __ns_vectors
__ns_vectors:
        .word       0x20009000
        .word       .loop
        .thumb_func
.loop:
        cpsid       i
        b           .loop


#endif /* !defined(__DOXYGEN__) */

/** @} */
