/*
 * ARM Limited (ARM) is supplying this software for use with Cortex-M
 * processor based microcontroller, but can be equally used for other
 * suitable processor architectures. This file can be freely distributed.
 * Modifications to this file shall be clearly marked.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS". NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * @file     SN32F240B.h
 * @brief    CMSIS HeaderFile
 * @version  1.1
 * @date     09. January 2022
 * @note     Generated by SVDConv V3.3.35 on Sunday, 09.01.2022 18:48:41
 *           from File 'SN32F240B.svd',
 *           last modified on Tuesday, 01.09.2020 10:52:27
 */



/** @addtogroup SONiX Technology Co., Ltd.
  * @{
  */


/** @addtogroup SN32F240B
  * @{
  */


#ifndef SN32F240B_H
#define SN32F240B_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M0 Specific Interrupt Numbers  ======================================== */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* =========================================  SN32F240B Specific Interrupt Numbers  ========================================== */
  NDT_IRQn                  =   0,              /*!< 0  NDT                                                                    */
  USB_IRQn                  =   1,              /*!< 1  USB                                                                    */
  SPI0_IRQn                 =   6,              /*!< 6  SPI0                                                                   */
  I2C0_IRQn                 =  10,              /*!< 10 I2C0                                                                   */
  UART0_IRQn                =  12,              /*!< 12 UART0                                                                  */
  UART1_IRQn                =  13,              /*!< 13 UART1                                                                  */
  UART2_IRQn                =  14,              /*!< 14 UART2                                                                  */
  CT16B0_IRQn               =  15,              /*!< 15 CT16B0                                                                 */
  CT16B1_IRQn               =  16,              /*!< 16 CT16B1                                                                 */
  ADC_IRQn                  =  24,              /*!< 24 ADC                                                                    */
  WDT_IRQn                  =  25,              /*!< 25 WDT                                                                    */
  LVD_IRQn                  =  26,              /*!< 26 LVD                                                                    */
  P3_IRQn                   =  28,              /*!< 28 P3                                                                     */
  P2_IRQn                   =  29,              /*!< 29 P2                                                                     */
  P1_IRQn                   =  30,              /*!< 30 P1                                                                     */
  P0_IRQn                   =  31               /*!< 31 P0                                                                     */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ===========================  Configuration of the ARM Cortex-M0 Processor and Core Peripherals  =========================== */
#define __CM0_REV                 0x0000U       /*!< CM0 Core Revision                                                         */
#define __NVIC_PRIO_BITS               2        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __MPU_PRESENT                  0        /*!< MPU present                                                               */
#define __FPU_PRESENT                  0        /*!< FPU present                                                               */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm0.h"                           /*!< ARM Cortex-M0 processor and core peripherals                              */
#include "system_SN32F2xx.h"                   /*!< SN32F240B System                                                          */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                          SN_SYS0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief System Control Registers (SN_SYS0)
  */

typedef struct {                                /*!< (@ 0x40060000) SN_SYS0 Structure                                          */
  
  union {
    __IOM uint32_t ANBCTRL;                     /*!< (@ 0x00000000) Offset:0x00 Analog Block Control Register                  */
    
    struct {
      __IOM uint32_t IHRCEN     : 1;            /*!< [0..0] IHRC enable                                                        */
            uint32_t            : 31;
    } ANBCTRL_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IM  uint32_t CSST;                        /*!< (@ 0x00000008) Offset:0x08 Clock Source Status Register                   */
    
    struct {
      __IM  uint32_t IHRCRDY    : 1;            /*!< [0..0] IHRC ready flag                                                    */
            uint32_t            : 31;
    } CSST_b;
  } ;
  
  union {
    __IOM uint32_t CLKCFG;                      /*!< (@ 0x0000000C) Offset:0x0C System Clock Configuration Register            */
    
    struct {
      __IOM uint32_t SYSCLKSEL  : 1;            /*!< [0..0] System clock source selection                                      */
            uint32_t            : 3;
      __IM  uint32_t SYSCLKST   : 1;            /*!< [4..4] System clock switch status                                         */
            uint32_t            : 27;
    } CLKCFG_b;
  } ;
  
  union {
    __IOM uint32_t AHBCP;                       /*!< (@ 0x00000010) Offset:0x10 AHB Clock Prescale Register                    */
    
    struct {
      __IOM uint32_t AHBPRE     : 3;            /*!< [2..0] AHB clock source prescaler                                         */
            uint32_t            : 29;
    } AHBCP_b;
  } ;
  
  union {
    __IOM uint32_t RSTST;                       /*!< (@ 0x00000014) Offset:0x14 System Reset Status Register                   */
    
    struct {
      __IOM uint32_t SWRSTF     : 1;            /*!< [0..0] Software reset flag                                                */
      __IOM uint32_t WDTRSTF    : 1;            /*!< [1..1] WDT reset flag                                                     */
      __IOM uint32_t LVDRSTF    : 1;            /*!< [2..2] LVD reset flag                                                     */
      __IOM uint32_t EXTRSTF    : 1;            /*!< [3..3] External reset flag                                                */
      __IOM uint32_t PORRSTF    : 1;            /*!< [4..4] POR reset flag                                                     */
            uint32_t            : 27;
    } RSTST_b;
  } ;
  
  union {
    __IOM uint32_t LVDCTRL;                     /*!< (@ 0x00000018) Offset:0x18 LVD Control Register                           */
    
    struct {
      __IOM uint32_t LVDRSTLVL  : 3;            /*!< [2..0] LVD reset level                                                    */
            uint32_t            : 1;
      __IOM uint32_t LVDINTLVL  : 3;            /*!< [6..4] LVD interrupt level                                                */
            uint32_t            : 7;
      __IOM uint32_t LVDRSTEN   : 1;            /*!< [14..14] LVD Reset enable                                                 */
      __IOM uint32_t LVDEN      : 1;            /*!< [15..15] LVD enable                                                       */
            uint32_t            : 16;
    } LVDCTRL_b;
  } ;
  
  union {
    __IOM uint32_t EXRSTCTRL;                   /*!< (@ 0x0000001C) Offset:0x1C External Reset Pin Control Register            */
    
    struct {
      __IOM uint32_t RESETDIS   : 1;            /*!< [0..0] External reset pin disable                                         */
            uint32_t            : 31;
    } EXRSTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t SWDCTRL;                     /*!< (@ 0x00000020) Offset:0x20 SWD Pin Control Register                       */
    
    struct {
      __IOM uint32_t SWDDIS     : 1;            /*!< [0..0] SWD pin disable                                                    */
            uint32_t            : 31;
    } SWDCTRL_b;
  } ;
  
  union {
    __IOM uint32_t IVTM;                        /*!< (@ 0x00000024) Offset:0x24 Interrupt Vector Table Mapping register        */
    
    struct {
      __IOM uint32_t IVTM       : 2;            /*!< [1..0] Interrupt table mapping selection                                  */
            uint32_t            : 14;
      __OM  uint32_t IVTMKEY    : 16;           /*!< [31..16] IVTM register key                                                */
    } IVTM_b;
  } ;
  
  union {
    __IOM uint32_t NDTCTRL;                     /*!< (@ 0x00000028) Offset:0x28 Noise Detect Control Register                  */
    
    struct {
            uint32_t            : 1;
      __IOM uint32_t NDT5V_IE   : 1;            /*!< [1..1] NDT for VDD 5V interrupt enable bit                                */
            uint32_t            : 30;
    } NDTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t NDTSTS;                      /*!< (@ 0x0000002C) Offset:0x2C Noise Detect Status Register                   */
    
    struct {
            uint32_t            : 1;
      __IOM uint32_t NDT5V_DET  : 1;            /*!< [1..1] Power noise status of NDT5V                                        */
            uint32_t            : 30;
    } NDTSTS_b;
  } ;
  
  union {
    __IOM uint32_t ANTIEFT;                     /*!< (@ 0x00000030) Offset:0x30 Anti-EFT Ability Control Register              */
    
    struct {
      __IOM uint32_t AEFT       : 3;            /*!< [2..0] Anti-EFT ability                                                   */
            uint32_t            : 29;
    } ANTIEFT_b;
  } ;
} SN_SYS0_Type;                                 /*!< Size = 52 (0x34)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_SYS1                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief System Control Registers (SN_SYS1)
  */

typedef struct {                                /*!< (@ 0x4005E000) SN_SYS1 Structure                                          */
  
  union {
    __IOM uint32_t AHBCLKEN;                    /*!< (@ 0x00000000) Offset:0x00 AHB Clock Enable Register                      */
    
    struct {
      __IOM uint32_t P0CLKEN    : 1;            /*!< [0..0] Enable AHB clock for P0                                            */
      __IOM uint32_t P1CLKEN    : 1;            /*!< [1..1] Enable AHB clock for P1                                            */
      __IOM uint32_t P2CLKEN    : 1;            /*!< [2..2] Enable AHB clock for P2                                            */
      __IOM uint32_t P3CLKEN    : 1;            /*!< [3..3] Enable AHB clock for P3                                            */
      __IOM uint32_t USBCLKEN   : 1;            /*!< [4..4] Enable AHB clock for USB                                           */
            uint32_t            : 1;
      __IOM uint32_t CT16B0CLKEN : 1;           /*!< [6..6] Enable AHB clock for CT16B0                                        */
      __IOM uint32_t CT16B1CLKEN : 1;           /*!< [7..7] Enable AHB clock for CT16B1                                        */
            uint32_t            : 3;
      __IOM uint32_t ADCCLKEN   : 1;            /*!< [11..11] Enable AHB clock for ADC                                         */
      __IOM uint32_t SPI0CLKEN  : 1;            /*!< [12..12] Enable AHB clock for SPI0                                        */
            uint32_t            : 3;
      __IOM uint32_t UART0CLKEN : 1;            /*!< [16..16] Enable AHB clock for UART0                                       */
      __IOM uint32_t UART1CLKEN : 1;            /*!< [17..17] Enable AHB clock for UART1                                       */
      __IOM uint32_t UART2CLKEN : 1;            /*!< [18..18] Enable AHB clock for UART2                                       */
            uint32_t            : 2;
      __IOM uint32_t I2C0CLKEN  : 1;            /*!< [21..21] Enable AHB clock for I2C0                                        */
            uint32_t            : 2;
      __IOM uint32_t WDTCLKEN   : 1;            /*!< [24..24] Enable AHB clock for WDT                                         */
            uint32_t            : 3;
      __IOM uint32_t CLKOUTSEL  : 3;            /*!< [30..28] Clock output source selection                                    */
            uint32_t            : 1;
    } AHBCLKEN_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t APBCP1;                      /*!< (@ 0x00000008) Offset:0x08 APB Clock Prescale Register 1                  */
    
    struct {
            uint32_t            : 20;
      __IOM uint32_t WDTPRE     : 3;            /*!< [22..20] WDT APB clock source prescaler                                   */
            uint32_t            : 5;
      __IOM uint32_t CLKOUTPRE  : 3;            /*!< [30..28] CLKOUT APB clock source prescaler                                */
            uint32_t            : 1;
    } APBCP1_b;
  } ;
} SN_SYS1_Type;                                 /*!< Size = 12 (0xc)                                                           */



/* =========================================================================================================================== */
/* ================                                          SN_PMU                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Power Management Unit (SN_PMU)
  */

typedef struct {                                /*!< (@ 0x40032000) SN_PMU Structure                                           */
  __IM  uint32_t  RESERVED[16];
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000040) Offset:0x40 PMU Control Register                           */
    
    struct {
      __IOM uint32_t MODE       : 3;            /*!< [2..0] Low Power mode selection                                           */
            uint32_t            : 29;
    } CTRL_b;
  } ;
} SN_PMU_Type;                                  /*!< Size = 68 (0x44)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_PFPA                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief Peripheral Function Pin Assignment (SN_PFPA)
  */

typedef struct {                                /*!< (@ 0x40042000) SN_PFPA Structure                                          */
  
  union {
    __IOM uint32_t CT16B1;                      /*!< (@ 0x00000000) Offset:0x00 PFPA for CT16B1 Register                       */
    
    struct {
      __IOM uint32_t PWM00      : 1;            /*!< [0..0] CT16B1_PWM00 assigned pin                                          */
      __IOM uint32_t PWM01      : 1;            /*!< [1..1] CT16B1_PWM01 assigned pin                                          */
      __IOM uint32_t PWM02      : 1;            /*!< [2..2] CT16B1_PWM02 assigned pin                                          */
      __IOM uint32_t PWM03      : 1;            /*!< [3..3] CT16B1_PWM03 assigned pin                                          */
      __IOM uint32_t PWM04      : 1;            /*!< [4..4] CT16B1_PWM04 assigned pin                                          */
      __IOM uint32_t PWM05      : 1;            /*!< [5..5] CT16B1_PWM05 assigned pin                                          */
      __IOM uint32_t PWM06      : 1;            /*!< [6..6] CT16B1_PWM06 assigned pin                                          */
      __IOM uint32_t PWM07      : 1;            /*!< [7..7] CT16B1_PWM07 assigned pin                                          */
      __IOM uint32_t PWM08      : 1;            /*!< [8..8] CT16B1_PWM08 assigned pin                                          */
      __IOM uint32_t PWM09      : 1;            /*!< [9..9] CT16B1_PWM09 assigned pin                                          */
      __IOM uint32_t PWM10      : 1;            /*!< [10..10] CT16B1_PWM10 assigned pin                                        */
      __IOM uint32_t PWM11      : 1;            /*!< [11..11] CT16B1_PWM11 assigned pin                                        */
      __IOM uint32_t PWM12      : 1;            /*!< [12..12] CT16B1_PWM12 assigned pin                                        */
      __IOM uint32_t PWM13      : 1;            /*!< [13..13] CT16B1_PWM13 assigned pin                                        */
      __IOM uint32_t PWM14      : 1;            /*!< [14..14] CT16B1_PWM14 assigned pin                                        */
      __IOM uint32_t PWM15      : 1;            /*!< [15..15] CT16B1_PWM15 assigned pin                                        */
      __IOM uint32_t PWM16      : 1;            /*!< [16..16] CT16B1_PWM16 assigned pin                                        */
      __IOM uint32_t PWM17      : 1;            /*!< [17..17] CT16B1_PWM17 assigned pin                                        */
      __IOM uint32_t PWM18      : 1;            /*!< [18..18] CT16B1_PWM18 assigned pin                                        */
      __IOM uint32_t PWM19      : 1;            /*!< [19..19] CT16B1_PWM19 assigned pin                                        */
      __IOM uint32_t PWM20      : 1;            /*!< [20..20] CT16B1_PWM20 assigned pin                                        */
      __IOM uint32_t PWM21      : 1;            /*!< [21..21] CT16B1_PWM21 assigned pin                                        */
      __IOM uint32_t PWM22      : 1;            /*!< [22..22] CT16B1_PWM22 assigned pin                                        */
      __IOM uint32_t PWM23      : 1;            /*!< [23..23] CT16B1_PWM23 assigned pin                                        */
            uint32_t            : 8;
    } CT16B1_b;
  } ;
} SN_PFPA_Type;                                 /*!< Size = 4 (0x4)                                                            */



/* =========================================================================================================================== */
/* ================                                         SN_GPIO0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose I/O (SN_GPIO0)
  */

typedef struct {                                /*!< (@ 0x40044000) SN_GPIO0 Structure                                         */
  
  union {
    __IOM uint32_t DATA;                        /*!< (@ 0x00000000) Offset:0x00 GPIO Port n Data Register                      */
    
    struct {
      __IOM uint32_t DATA0      : 1;            /*!< [0..0] Data of Pn.0                                                       */
      __IOM uint32_t DATA1      : 1;            /*!< [1..1] Data of Pn.1                                                       */
      __IOM uint32_t DATA2      : 1;            /*!< [2..2] Data of Pn.2                                                       */
      __IOM uint32_t DATA3      : 1;            /*!< [3..3] Data of Pn.3                                                       */
      __IOM uint32_t DATA4      : 1;            /*!< [4..4] Data of Pn.4                                                       */
      __IOM uint32_t DATA5      : 1;            /*!< [5..5] Data of Pn.5                                                       */
      __IOM uint32_t DATA6      : 1;            /*!< [6..6] Data of Pn.6                                                       */
      __IOM uint32_t DATA7      : 1;            /*!< [7..7] Data of Pn.7                                                       */
      __IOM uint32_t DATA8      : 1;            /*!< [8..8] Data of Pn.8                                                       */
      __IOM uint32_t DATA9      : 1;            /*!< [9..9] Data of Pn.9                                                       */
      __IOM uint32_t DATA10     : 1;            /*!< [10..10] Data of Pn.10                                                    */
      __IOM uint32_t DATA11     : 1;            /*!< [11..11] Data of Pn.11                                                    */
      __IOM uint32_t DATA12     : 1;            /*!< [12..12] Data of Pn.12                                                    */
      __IOM uint32_t DATA13     : 1;            /*!< [13..13] Data of Pn.13                                                    */
      __IOM uint32_t DATA14     : 1;            /*!< [14..14] Data of Pn.14                                                    */
      __IOM uint32_t DATA15     : 1;            /*!< [15..15] Data of Pn.15                                                    */
            uint32_t            : 16;
    } DATA_b;
  } ;
  
  union {
    __IOM uint32_t MODE;                        /*!< (@ 0x00000004) Offset:0x04 GPIO Port n Mode Register                      */
    
    struct {
      __IOM uint32_t MODE0      : 1;            /*!< [0..0] Mode of Pn.0                                                       */
      __IOM uint32_t MODE1      : 1;            /*!< [1..1] Mode of Pn.1                                                       */
      __IOM uint32_t MODE2      : 1;            /*!< [2..2] Mode of Pn.2                                                       */
      __IOM uint32_t MODE3      : 1;            /*!< [3..3] Mode of Pn.3                                                       */
      __IOM uint32_t MODE4      : 1;            /*!< [4..4] Mode of Pn.4                                                       */
      __IOM uint32_t MODE5      : 1;            /*!< [5..5] Mode of Pn.5                                                       */
      __IOM uint32_t MODE6      : 1;            /*!< [6..6] Mode of Pn.6                                                       */
      __IOM uint32_t MODE7      : 1;            /*!< [7..7] Mode of Pn.7                                                       */
      __IOM uint32_t MODE8      : 1;            /*!< [8..8] Mode of Pn.8                                                       */
      __IOM uint32_t MODE9      : 1;            /*!< [9..9] Mode of Pn.9                                                       */
      __IOM uint32_t MODE10     : 1;            /*!< [10..10] Mode of Pn.10                                                    */
      __IOM uint32_t MODE11     : 1;            /*!< [11..11] Mode of Pn.11                                                    */
      __IOM uint32_t MODE12     : 1;            /*!< [12..12] Mode of Pn.12                                                    */
      __IOM uint32_t MODE13     : 1;            /*!< [13..13] Mode of Pn.13                                                    */
      __IOM uint32_t MODE14     : 1;            /*!< [14..14] Mode of Pn.14                                                    */
      __IOM uint32_t MODE15     : 1;            /*!< [15..15] Mode of Pn.15                                                    */
            uint32_t            : 16;
    } MODE_b;
  } ;
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000008) Offset:0x08 GPIO Port n Configuration Register             */
    
    struct {
      __IOM uint32_t CFG0       : 2;            /*!< [1..0] Configuration of Pn.0                                              */
      __IOM uint32_t CFG1       : 2;            /*!< [3..2] Configuration of Pn.1                                              */
      __IOM uint32_t CFG2       : 2;            /*!< [5..4] Configuration of Pn.2                                              */
      __IOM uint32_t CFG3       : 2;            /*!< [7..6] Configuration of Pn.3                                              */
      __IOM uint32_t CFG4       : 2;            /*!< [9..8] Configuration of Pn.4                                              */
      __IOM uint32_t CFG5       : 2;            /*!< [11..10] Configuration of Pn.5                                            */
      __IOM uint32_t CFG6       : 2;            /*!< [13..12] Configuration of Pn.6                                            */
      __IOM uint32_t CFG7       : 2;            /*!< [15..14] Configuration of Pn.7                                            */
      __IOM uint32_t CFG8       : 2;            /*!< [17..16] Configuration of Pn.8                                            */
      __IOM uint32_t CFG9       : 2;            /*!< [19..18] Configuration of Pn.9                                            */
      __IOM uint32_t CFG10      : 2;            /*!< [21..20] Configuration of Pn.10                                           */
      __IOM uint32_t CFG11      : 2;            /*!< [23..22] Configuration of Pn.11                                           */
      __IOM uint32_t CFG12      : 2;            /*!< [25..24] Configuration of Pn.12                                           */
      __IOM uint32_t CFG13      : 2;            /*!< [27..26] Configuration of Pn.13                                           */
      __IOM uint32_t CFG14      : 2;            /*!< [29..28] Configuration of Pn.14                                           */
      __IOM uint32_t CFG15      : 2;            /*!< [31..30] Configuration of Pn.15                                           */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t IS;                          /*!< (@ 0x0000000C) Offset:0x0C GPIO Port n Interrupt Sense Register           */
    
    struct {
      __IOM uint32_t IS0        : 1;            /*!< [0..0] Interrupt on Pn.0 is event or edge sensitive                       */
      __IOM uint32_t IS1        : 1;            /*!< [1..1] Interrupt on Pn.1 is event or edge sensitive                       */
      __IOM uint32_t IS2        : 1;            /*!< [2..2] Interrupt on Pn.2 is event or edge sensitive                       */
      __IOM uint32_t IS3        : 1;            /*!< [3..3] Interrupt on Pn.3 is event or edge sensitive                       */
      __IOM uint32_t IS4        : 1;            /*!< [4..4] Interrupt on Pn.4 is event or edge sensitive                       */
      __IOM uint32_t IS5        : 1;            /*!< [5..5] Interrupt on Pn.5 is event or edge sensitive                       */
      __IOM uint32_t IS6        : 1;            /*!< [6..6] Interrupt on Pn.6 is event or edge sensitive                       */
      __IOM uint32_t IS7        : 1;            /*!< [7..7] Interrupt on Pn.7 is event or edge sensitive                       */
      __IOM uint32_t IS8        : 1;            /*!< [8..8] Interrupt on Pn.8 is event or edge sensitive                       */
      __IOM uint32_t IS9        : 1;            /*!< [9..9] Interrupt on Pn.9 is event or edge sensitive                       */
      __IOM uint32_t IS10       : 1;            /*!< [10..10] Interrupt on Pn.10 is event or edge sensitive                    */
      __IOM uint32_t IS11       : 1;            /*!< [11..11] Interrupt on Pn.11 is event or edge sensitive                    */
      __IOM uint32_t IS12       : 1;            /*!< [12..12] Interrupt on Pn.12 is event or edge sensitive                    */
      __IOM uint32_t IS13       : 1;            /*!< [13..13] Interrupt on Pn.13 is event or edge sensitive                    */
      __IOM uint32_t IS14       : 1;            /*!< [14..14] Interrupt on Pn.14 is event or edge sensitive                    */
      __IOM uint32_t IS15       : 1;            /*!< [15..15] Interrupt on Pn.15 is event or edge sensitive                    */
            uint32_t            : 16;
    } IS_b;
  } ;
  
  union {
    __IOM uint32_t IBS;                         /*!< (@ 0x00000010) Offset:0x10 GPIO Port n Interrupt Both-edge Sense
                                                                    Register                                                   */
    
    struct {
      __IOM uint32_t IBS0       : 1;            /*!< [0..0] Interrupt on Pn.0 is triggered ob both edges                       */
      __IOM uint32_t IBS1       : 1;            /*!< [1..1] Interrupt on Pn.1 is triggered ob both edges                       */
      __IOM uint32_t IBS2       : 1;            /*!< [2..2] Interrupt on Pn.2 is triggered ob both edges                       */
      __IOM uint32_t IBS3       : 1;            /*!< [3..3] Interrupt on Pn.3 is triggered ob both edges                       */
      __IOM uint32_t IBS4       : 1;            /*!< [4..4] Interrupt on Pn.4 is triggered ob both edges                       */
      __IOM uint32_t IBS5       : 1;            /*!< [5..5] Interrupt on Pn.5 is triggered ob both edges                       */
      __IOM uint32_t IBS6       : 1;            /*!< [6..6] Interrupt on Pn.6 is triggered ob both edges                       */
      __IOM uint32_t IBS7       : 1;            /*!< [7..7] Interrupt on Pn.7 is triggered ob both edges                       */
      __IOM uint32_t IBS8       : 1;            /*!< [8..8] Interrupt on Pn.8 is triggered ob both edges                       */
      __IOM uint32_t IBS9       : 1;            /*!< [9..9] Interrupt on Pn.9 is triggered ob both edges                       */
      __IOM uint32_t IBS10      : 1;            /*!< [10..10] Interrupt on Pn.10 is triggered ob both edges                    */
      __IOM uint32_t IBS11      : 1;            /*!< [11..11] Interrupt on Pn.11 is triggered ob both edges                    */
      __IOM uint32_t IBS12      : 1;            /*!< [12..12] Interrupt on Pn.12 is triggered ob both edges                    */
      __IOM uint32_t IBS13      : 1;            /*!< [13..13] Interrupt on Pn.13 is triggered ob both edges                    */
      __IOM uint32_t IBS14      : 1;            /*!< [14..14] Interrupt on Pn.14 is triggered ob both edges                    */
      __IOM uint32_t IBS15      : 1;            /*!< [15..15] Interrupt on Pn.15 is triggered ob both edges                    */
            uint32_t            : 16;
    } IBS_b;
  } ;
  
  union {
    __IOM uint32_t IEV;                         /*!< (@ 0x00000014) Offset:0x14 GPIO Port n Interrupt Event Register           */
    
    struct {
      __IOM uint32_t IEV0       : 1;            /*!< [0..0] Interrupt trigged evnet on Pn.0                                    */
      __IOM uint32_t IEV1       : 1;            /*!< [1..1] Interrupt trigged evnet on Pn.1                                    */
      __IOM uint32_t IEV2       : 1;            /*!< [2..2] Interrupt trigged evnet on Pn.2                                    */
      __IOM uint32_t IEV3       : 1;            /*!< [3..3] Interrupt trigged evnet on Pn.3                                    */
      __IOM uint32_t IEV4       : 1;            /*!< [4..4] Interrupt trigged evnet on Pn.4                                    */
      __IOM uint32_t IEV5       : 1;            /*!< [5..5] Interrupt trigged evnet on Pn.5                                    */
      __IOM uint32_t IEV6       : 1;            /*!< [6..6] Interrupt trigged evnet on Pn.6                                    */
      __IOM uint32_t IEV7       : 1;            /*!< [7..7] Interrupt trigged evnet on Pn.7                                    */
      __IOM uint32_t IEV8       : 1;            /*!< [8..8] Interrupt trigged evnet on Pn.8                                    */
      __IOM uint32_t IEV9       : 1;            /*!< [9..9] Interrupt trigged evnet on Pn.9                                    */
      __IOM uint32_t IEV10      : 1;            /*!< [10..10] Interrupt trigged evnet on Pn.10                                 */
      __IOM uint32_t IEV11      : 1;            /*!< [11..11] Interrupt trigged evnet on Pn.11                                 */
      __IOM uint32_t IEV12      : 1;            /*!< [12..12] Interrupt trigged evnet on Pn.12                                 */
      __IOM uint32_t IEV13      : 1;            /*!< [13..13] Interrupt trigged evnet on Pn.13                                 */
      __IOM uint32_t IEV14      : 1;            /*!< [14..14] Interrupt trigged evnet on Pn.14                                 */
      __IOM uint32_t IEV15      : 1;            /*!< [15..15] Interrupt trigged evnet on Pn.15                                 */
            uint32_t            : 16;
    } IEV_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000018) Offset:0x18 GPIO Port n Interrupt Enable Register          */
    
    struct {
      __IOM uint32_t IE0        : 1;            /*!< [0..0] Interrupt on Pn.0 enable                                           */
      __IOM uint32_t IE1        : 1;            /*!< [1..1] Interrupt on Pn.1 enable                                           */
      __IOM uint32_t IE2        : 1;            /*!< [2..2] Interrupt on Pn.2 enable                                           */
      __IOM uint32_t IE3        : 1;            /*!< [3..3] Interrupt on Pn.3 enable                                           */
      __IOM uint32_t IE4        : 1;            /*!< [4..4] Interrupt on Pn.4 enable                                           */
      __IOM uint32_t IE5        : 1;            /*!< [5..5] Interrupt on Pn.5 enable                                           */
      __IOM uint32_t IE6        : 1;            /*!< [6..6] Interrupt on Pn.6 enable                                           */
      __IOM uint32_t IE7        : 1;            /*!< [7..7] Interrupt on Pn.7 enable                                           */
      __IOM uint32_t IE8        : 1;            /*!< [8..8] Interrupt on Pn.8 enable                                           */
      __IOM uint32_t IE9        : 1;            /*!< [9..9] Interrupt on Pn.9 enable                                           */
      __IOM uint32_t IE10       : 1;            /*!< [10..10] Interrupt on Pn.10 enable                                        */
      __IOM uint32_t IE11       : 1;            /*!< [11..11] Interrupt on Pn.11 enable                                        */
      __IOM uint32_t IE12       : 1;            /*!< [12..12] Interrupt on Pn.11 enable                                        */
      __IOM uint32_t IE13       : 1;            /*!< [13..13] Interrupt on Pn.13 enable                                        */
      __IOM uint32_t IE14       : 1;            /*!< [14..14] Interrupt on Pn.14 enable                                        */
      __IOM uint32_t IE15       : 1;            /*!< [15..15] Interrupt on Pn.15 enable                                        */
            uint32_t            : 16;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x0000001C) Offset:0x1C GPIO Port n Raw Interrupt Status
                                                                    Register                                                   */
    
    struct {
      __IM  uint32_t IF0        : 1;            /*!< [0..0] Pn.0 raw interrupt flag                                            */
      __IM  uint32_t IF1        : 1;            /*!< [1..1] Pn.1 raw interrupt flag                                            */
      __IM  uint32_t IF2        : 1;            /*!< [2..2] Pn.2 raw interrupt flag                                            */
      __IM  uint32_t IF3        : 1;            /*!< [3..3] Pn.3 raw interrupt flag                                            */
      __IM  uint32_t IF4        : 1;            /*!< [4..4] Pn.4 raw interrupt flag                                            */
      __IM  uint32_t IF5        : 1;            /*!< [5..5] Pn.5 raw interrupt flag                                            */
      __IM  uint32_t IF6        : 1;            /*!< [6..6] Pn.6 raw interrupt flag                                            */
      __IM  uint32_t IF7        : 1;            /*!< [7..7] Pn.7 raw interrupt flag                                            */
      __IM  uint32_t IF8        : 1;            /*!< [8..8] Pn.8 raw interrupt flag                                            */
      __IM  uint32_t IF9        : 1;            /*!< [9..9] Pn.9 raw interrupt flag                                            */
      __IM  uint32_t IF10       : 1;            /*!< [10..10] Pn.10 raw interrupt flag                                         */
      __IM  uint32_t IF11       : 1;            /*!< [11..11] Pn.11 raw interrupt flag                                         */
      __IM  uint32_t IF12       : 1;            /*!< [12..12] Pn.12 raw interrupt flag                                         */
      __IM  uint32_t IF13       : 1;            /*!< [13..13] Pn.13 raw interrupt flag                                         */
      __IM  uint32_t IF14       : 1;            /*!< [14..14] Pn.14 raw interrupt flag                                         */
      __IM  uint32_t IF15       : 1;            /*!< [15..15] Pn.15 raw interrupt flag                                         */
            uint32_t            : 16;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000020) Offset:0x20 GPIO Port n Interrupt Clear Register           */
    
    struct {
      __OM  uint32_t IC0        : 1;            /*!< [0..0] Pn.0 interrupt flag clear                                          */
      __OM  uint32_t IC1        : 1;            /*!< [1..1] Pn.1 interrupt flag clear                                          */
      __OM  uint32_t IC2        : 1;            /*!< [2..2] Pn.2 interrupt flag clear                                          */
      __OM  uint32_t IC3        : 1;            /*!< [3..3] Pn.3 interrupt flag clear                                          */
      __OM  uint32_t IC4        : 1;            /*!< [4..4] Pn.4 interrupt flag clear                                          */
      __OM  uint32_t IC5        : 1;            /*!< [5..5] Pn.5 interrupt flag clear                                          */
      __OM  uint32_t IC6        : 1;            /*!< [6..6] Pn.6 interrupt flag clear                                          */
      __OM  uint32_t IC7        : 1;            /*!< [7..7] Pn.7 interrupt flag clear                                          */
      __OM  uint32_t IC8        : 1;            /*!< [8..8] Pn.8 interrupt flag clear                                          */
      __OM  uint32_t IC9        : 1;            /*!< [9..9] Pn.9 interrupt flag clear                                          */
      __OM  uint32_t IC10       : 1;            /*!< [10..10] Pn.10 interrupt flag clear                                       */
      __OM  uint32_t IC11       : 1;            /*!< [11..11] Pn.11 interrupt flag clear                                       */
      __OM  uint32_t IC12       : 1;            /*!< [12..12] Pn.12 interrupt flag clear                                       */
      __OM  uint32_t IC13       : 1;            /*!< [13..13] Pn.13 interrupt flag clear                                       */
      __OM  uint32_t IC14       : 1;            /*!< [14..14] Pn.14 interrupt flag clear                                       */
      __OM  uint32_t IC15       : 1;            /*!< [15..15] Pn.15 interrupt flag clear                                       */
            uint32_t            : 16;
    } IC_b;
  } ;
  
  union {
    __OM  uint32_t BSET;                        /*!< (@ 0x00000024) Offset:0x24 GPIO Port n Bits Set Operation Register        */
    
    struct {
      __OM  uint32_t BSET0      : 1;            /*!< [0..0] Set Pn.0                                                           */
      __OM  uint32_t BSET1      : 1;            /*!< [1..1] Set Pn.1                                                           */
      __OM  uint32_t BSET2      : 1;            /*!< [2..2] Set Pn.2                                                           */
      __OM  uint32_t BSET3      : 1;            /*!< [3..3] Set Pn.3                                                           */
      __OM  uint32_t BSET4      : 1;            /*!< [4..4] Set Pn.4                                                           */
      __OM  uint32_t BSET5      : 1;            /*!< [5..5] Set Pn.5                                                           */
      __OM  uint32_t BSET6      : 1;            /*!< [6..6] Set Pn.6                                                           */
      __OM  uint32_t BSET7      : 1;            /*!< [7..7] Set Pn.7                                                           */
      __OM  uint32_t BSET8      : 1;            /*!< [8..8] Set Pn.8                                                           */
      __OM  uint32_t BSET9      : 1;            /*!< [9..9] Set Pn.9                                                           */
      __OM  uint32_t BSET10     : 1;            /*!< [10..10] Set Pn.10                                                        */
      __OM  uint32_t BSET11     : 1;            /*!< [11..11] Set Pn.11                                                        */
      __OM  uint32_t BSET12     : 1;            /*!< [12..12] Set Pn.12                                                        */
      __OM  uint32_t BSET13     : 1;            /*!< [13..13] Set Pn.13                                                        */
      __OM  uint32_t BSET14     : 1;            /*!< [14..14] Set Pn.14                                                        */
      __OM  uint32_t BSET15     : 1;            /*!< [15..15] Set Pn.15                                                        */
            uint32_t            : 16;
    } BSET_b;
  } ;
  
  union {
    __OM  uint32_t BCLR;                        /*!< (@ 0x00000028) Offset:0x28 GPIO Port n Bits Clear Operation
                                                                    Register                                                   */
    
    struct {
      __OM  uint32_t BCLR0      : 1;            /*!< [0..0] Clear Pn.0                                                         */
      __OM  uint32_t BCLR1      : 1;            /*!< [1..1] Clear Pn.1                                                         */
      __OM  uint32_t BCLR2      : 1;            /*!< [2..2] Clear Pn.2                                                         */
      __OM  uint32_t BCLR3      : 1;            /*!< [3..3] Clear Pn.3                                                         */
      __OM  uint32_t BCLR4      : 1;            /*!< [4..4] Clear Pn.4                                                         */
      __OM  uint32_t BCLR5      : 1;            /*!< [5..5] Clear Pn.5                                                         */
      __OM  uint32_t BCLR6      : 1;            /*!< [6..6] Clear Pn.6                                                         */
      __OM  uint32_t BCLR7      : 1;            /*!< [7..7] Clear Pn.7                                                         */
      __OM  uint32_t BCLR8      : 1;            /*!< [8..8] Clear Pn.8                                                         */
      __OM  uint32_t BCLR9      : 1;            /*!< [9..9] Clear Pn.9                                                         */
      __OM  uint32_t BCLR10     : 1;            /*!< [10..10] Clear Pn.10                                                      */
      __OM  uint32_t BCLR11     : 1;            /*!< [11..11] Clear Pn.11                                                      */
      __OM  uint32_t BCLR12     : 1;            /*!< [12..12] Clear Pn.12                                                      */
      __OM  uint32_t BCLR13     : 1;            /*!< [13..13] Clear Pn.13                                                      */
      __OM  uint32_t BCLR14     : 1;            /*!< [14..14] Clear Pn.14                                                      */
      __OM  uint32_t BCLR15     : 1;            /*!< [15..15] Clear Pn.15                                                      */
            uint32_t            : 16;
    } BCLR_b;
  } ;
} SN_GPIO0_Type;                                /*!< Size = 44 (0x2c)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_GPIO3                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose I/O (SN_GPIO3)
  */

typedef struct {                                /*!< (@ 0x4004A000) SN_GPIO3 Structure                                         */
  
  union {
    __IOM uint32_t DATA;                        /*!< (@ 0x00000000) Offset:0x00 GPIO Port n Data Register                      */
    
    struct {
            uint32_t            : 3;
      __IOM uint32_t DATA3      : 1;            /*!< [3..3] Data of Pn.3                                                       */
      __IOM uint32_t DATA4      : 1;            /*!< [4..4] Data of Pn.4                                                       */
      __IOM uint32_t DATA5      : 1;            /*!< [5..5] Data of Pn.5                                                       */
      __IOM uint32_t DATA6      : 1;            /*!< [6..6] Data of Pn.6                                                       */
      __IOM uint32_t DATA7      : 1;            /*!< [7..7] Data of Pn.7                                                       */
      __IOM uint32_t DATA8      : 1;            /*!< [8..8] Data of Pn.8                                                       */
      __IOM uint32_t DATA9      : 1;            /*!< [9..9] Data of Pn.9                                                       */
      __IOM uint32_t DATA10     : 1;            /*!< [10..10] Data of Pn.10                                                    */
      __IOM uint32_t DATA11     : 1;            /*!< [11..11] Data of Pn.11                                                    */
            uint32_t            : 20;
    } DATA_b;
  } ;
  
  union {
    __IOM uint32_t MODE;                        /*!< (@ 0x00000004) Offset:0x04 GPIO Port n Mode Register                      */
    
    struct {
            uint32_t            : 3;
      __IOM uint32_t MODE3      : 1;            /*!< [3..3] Mode of Pn.3                                                       */
      __IOM uint32_t MODE4      : 1;            /*!< [4..4] Mode of Pn.4                                                       */
      __IOM uint32_t MODE5      : 1;            /*!< [5..5] Mode of Pn.5                                                       */
      __IOM uint32_t MODE6      : 1;            /*!< [6..6] Mode of Pn.6                                                       */
      __IOM uint32_t MODE7      : 1;            /*!< [7..7] Mode of Pn.7                                                       */
      __IOM uint32_t MODE8      : 1;            /*!< [8..8] Mode of Pn.8                                                       */
      __IOM uint32_t MODE9      : 1;            /*!< [9..9] Mode of Pn.9                                                       */
      __IOM uint32_t MODE10     : 1;            /*!< [10..10] Mode of Pn.10                                                    */
      __IOM uint32_t MODE11     : 1;            /*!< [11..11] Mode of Pn.11                                                    */
            uint32_t            : 20;
    } MODE_b;
  } ;
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000008) Offset:0x08 GPIO Port n Configuration Register             */
    
    struct {
            uint32_t            : 6;
      __IOM uint32_t CFG3       : 2;            /*!< [7..6] Configuration of Pn.3                                              */
      __IOM uint32_t CFG4       : 2;            /*!< [9..8] Configuration of Pn.4                                              */
      __IOM uint32_t CFG5       : 2;            /*!< [11..10] Configuration of Pn.5                                            */
      __IOM uint32_t CFG6       : 2;            /*!< [13..12] Configuration of Pn.6                                            */
      __IOM uint32_t CFG7       : 2;            /*!< [15..14] Configuration of Pn.7                                            */
      __IOM uint32_t CFG8       : 2;            /*!< [17..16] Configuration of Pn.8                                            */
      __IOM uint32_t CFG9       : 2;            /*!< [19..18] Configuration of Pn.9                                            */
      __IOM uint32_t CFG10      : 2;            /*!< [21..20] Configuration of Pn.10                                           */
      __IOM uint32_t CFG11      : 2;            /*!< [23..22] Configuration of Pn.11                                           */
            uint32_t            : 8;
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t IS;                          /*!< (@ 0x0000000C) Offset:0x0C GPIO Port n Interrupt Sense Register           */
    
    struct {
            uint32_t            : 3;
      __IOM uint32_t IS3        : 1;            /*!< [3..3] Interrupt on Pn.3 is event or edge sensitive                       */
      __IOM uint32_t IS4        : 1;            /*!< [4..4] Interrupt on Pn.4 is event or edge sensitive                       */
      __IOM uint32_t IS5        : 1;            /*!< [5..5] Interrupt on Pn.5 is event or edge sensitive                       */
      __IOM uint32_t IS6        : 1;            /*!< [6..6] Interrupt on Pn.6 is event or edge sensitive                       */
      __IOM uint32_t IS7        : 1;            /*!< [7..7] Interrupt on Pn.7 is event or edge sensitive                       */
      __IOM uint32_t IS8        : 1;            /*!< [8..8] Interrupt on Pn.8 is event or edge sensitive                       */
      __IOM uint32_t IS9        : 1;            /*!< [9..9] Interrupt on Pn.9 is event or edge sensitive                       */
      __IOM uint32_t IS10       : 1;            /*!< [10..10] Interrupt on Pn.10 is event or edge sensitive                    */
      __IOM uint32_t IS11       : 1;            /*!< [11..11] Interrupt on Pn.11 is event or edge sensitive                    */
            uint32_t            : 20;
    } IS_b;
  } ;
  
  union {
    __IOM uint32_t IBS;                         /*!< (@ 0x00000010) Offset:0x10 GPIO Port n Interrupt Both-edge Sense
                                                                    Register                                                   */
    
    struct {
            uint32_t            : 3;
      __IOM uint32_t IBS3       : 1;            /*!< [3..3] Interrupt on Pn.3 is triggered ob both edges                       */
      __IOM uint32_t IBS4       : 1;            /*!< [4..4] Interrupt on Pn.4 is triggered ob both edges                       */
      __IOM uint32_t IBS5       : 1;            /*!< [5..5] Interrupt on Pn.5 is triggered ob both edges                       */
      __IOM uint32_t IBS6       : 1;            /*!< [6..6] Interrupt on Pn.6 is triggered ob both edges                       */
      __IOM uint32_t IBS7       : 1;            /*!< [7..7] Interrupt on Pn.7 is triggered ob both edges                       */
      __IOM uint32_t IBS8       : 1;            /*!< [8..8] Interrupt on Pn.8 is triggered ob both edges                       */
      __IOM uint32_t IBS9       : 1;            /*!< [9..9] Interrupt on Pn.9 is triggered ob both edges                       */
      __IOM uint32_t IBS10      : 1;            /*!< [10..10] Interrupt on Pn.10 is triggered ob both edges                    */
      __IOM uint32_t IBS11      : 1;            /*!< [11..11] Interrupt on Pn.11 is triggered ob both edges                    */
            uint32_t            : 20;
    } IBS_b;
  } ;
  
  union {
    __IOM uint32_t IEV;                         /*!< (@ 0x00000014) Offset:0x14 GPIO Port n Interrupt Event Register           */
    
    struct {
            uint32_t            : 3;
      __IOM uint32_t IEV3       : 1;            /*!< [3..3] Interrupt trigged evnet on Pn.3                                    */
      __IOM uint32_t IEV4       : 1;            /*!< [4..4] Interrupt trigged evnet on Pn.4                                    */
      __IOM uint32_t IEV5       : 1;            /*!< [5..5] Interrupt trigged evnet on Pn.5                                    */
      __IOM uint32_t IEV6       : 1;            /*!< [6..6] Interrupt trigged evnet on Pn.6                                    */
      __IOM uint32_t IEV7       : 1;            /*!< [7..7] Interrupt trigged evnet on Pn.7                                    */
      __IOM uint32_t IEV8       : 1;            /*!< [8..8] Interrupt trigged evnet on Pn.8                                    */
      __IOM uint32_t IEV9       : 1;            /*!< [9..9] Interrupt trigged evnet on Pn.9                                    */
      __IOM uint32_t IEV10      : 1;            /*!< [10..10] Interrupt trigged evnet on Pn.10                                 */
      __IOM uint32_t IEV11      : 1;            /*!< [11..11] Interrupt trigged evnet on Pn.11                                 */
            uint32_t            : 20;
    } IEV_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000018) Offset:0x18 GPIO Port n Interrupt Enable Register          */
    
    struct {
            uint32_t            : 3;
      __IOM uint32_t IE3        : 1;            /*!< [3..3] Interrupt on Pn.3 enable                                           */
      __IOM uint32_t IE4        : 1;            /*!< [4..4] Interrupt on Pn.4 enable                                           */
      __IOM uint32_t IE5        : 1;            /*!< [5..5] Interrupt on Pn.5 enable                                           */
      __IOM uint32_t IE6        : 1;            /*!< [6..6] Interrupt on Pn.6 enable                                           */
      __IOM uint32_t IE7        : 1;            /*!< [7..7] Interrupt on Pn.7 enable                                           */
      __IOM uint32_t IE8        : 1;            /*!< [8..8] Interrupt on Pn.8 enable                                           */
      __IOM uint32_t IE9        : 1;            /*!< [9..9] Interrupt on Pn.9 enable                                           */
      __IOM uint32_t IE10       : 1;            /*!< [10..10] Interrupt on Pn.10 enable                                        */
      __IOM uint32_t IE11       : 1;            /*!< [11..11] Interrupt on Pn.11 enable                                        */
            uint32_t            : 20;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x0000001C) Offset:0x1C GPIO Port n Raw Interrupt Status
                                                                    Register                                                   */
    
    struct {
            uint32_t            : 3;
      __IM  uint32_t IF3        : 1;            /*!< [3..3] Pn.3 raw interrupt flag                                            */
      __IM  uint32_t IF4        : 1;            /*!< [4..4] Pn.4 raw interrupt flag                                            */
      __IM  uint32_t IF5        : 1;            /*!< [5..5] Pn.5 raw interrupt flag                                            */
      __IM  uint32_t IF6        : 1;            /*!< [6..6] Pn.6 raw interrupt flag                                            */
      __IM  uint32_t IF7        : 1;            /*!< [7..7] Pn.7 raw interrupt flag                                            */
      __IM  uint32_t IF8        : 1;            /*!< [8..8] Pn.8 raw interrupt flag                                            */
      __IM  uint32_t IF9        : 1;            /*!< [9..9] Pn.9 raw interrupt flag                                            */
      __IM  uint32_t IF10       : 1;            /*!< [10..10] Pn.10 raw interrupt flag                                         */
      __IM  uint32_t IF11       : 1;            /*!< [11..11] Pn.11 raw interrupt flag                                         */
            uint32_t            : 20;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000020) Offset:0x20 GPIO Port n Interrupt Clear Register           */
    
    struct {
            uint32_t            : 3;
      __OM  uint32_t IC3        : 1;            /*!< [3..3] Pn.3 interrupt flag clear                                          */
      __OM  uint32_t IC4        : 1;            /*!< [4..4] Pn.4 interrupt flag clear                                          */
      __OM  uint32_t IC5        : 1;            /*!< [5..5] Pn.5 interrupt flag clear                                          */
      __OM  uint32_t IC6        : 1;            /*!< [6..6] Pn.6 interrupt flag clear                                          */
      __OM  uint32_t IC7        : 1;            /*!< [7..7] Pn.7 interrupt flag clear                                          */
      __OM  uint32_t IC8        : 1;            /*!< [8..8] Pn.8 interrupt flag clear                                          */
      __OM  uint32_t IC9        : 1;            /*!< [9..9] Pn.9 interrupt flag clear                                          */
      __OM  uint32_t IC10       : 1;            /*!< [10..10] Pn.10 interrupt flag clear                                       */
      __OM  uint32_t IC11       : 1;            /*!< [11..11] Pn.11 interrupt flag clear                                       */
            uint32_t            : 20;
    } IC_b;
  } ;
  
  union {
    __OM  uint32_t BSET;                        /*!< (@ 0x00000024) Offset:0x24 GPIO Port n Bits Set Operation Register        */
    
    struct {
            uint32_t            : 3;
      __OM  uint32_t BSET3      : 1;            /*!< [3..3] Set Pn.3                                                           */
      __OM  uint32_t BSET4      : 1;            /*!< [4..4] Set Pn.4                                                           */
      __OM  uint32_t BSET5      : 1;            /*!< [5..5] Set Pn.5                                                           */
      __OM  uint32_t BSET6      : 1;            /*!< [6..6] Set Pn.6                                                           */
      __OM  uint32_t BSET7      : 1;            /*!< [7..7] Set Pn.7                                                           */
      __OM  uint32_t BSET8      : 1;            /*!< [8..8] Set Pn.8                                                           */
      __OM  uint32_t BSET9      : 1;            /*!< [9..9] Set Pn.9                                                           */
      __OM  uint32_t BSET10     : 1;            /*!< [10..10] Set Pn.10                                                        */
      __OM  uint32_t BSET11     : 1;            /*!< [11..11] Set Pn.11                                                        */
            uint32_t            : 20;
    } BSET_b;
  } ;
  
  union {
    __OM  uint32_t BCLR;                        /*!< (@ 0x00000028) Offset:0x28 GPIO Port n Bits Clear Operation
                                                                    Register                                                   */
    
    struct {
            uint32_t            : 3;
      __OM  uint32_t BCLR3      : 1;            /*!< [3..3] Clear Pn.3                                                         */
      __OM  uint32_t BCLR4      : 1;            /*!< [4..4] Clear Pn.4                                                         */
      __OM  uint32_t BCLR5      : 1;            /*!< [5..5] Clear Pn.5                                                         */
      __OM  uint32_t BCLR6      : 1;            /*!< [6..6] Clear Pn.6                                                         */
      __OM  uint32_t BCLR7      : 1;            /*!< [7..7] Clear Pn.7                                                         */
      __OM  uint32_t BCLR8      : 1;            /*!< [8..8] Clear Pn.8                                                         */
      __OM  uint32_t BCLR9      : 1;            /*!< [9..9] Clear Pn.9                                                         */
      __OM  uint32_t BCLR10     : 1;            /*!< [10..10] Clear Pn.10                                                      */
      __OM  uint32_t BCLR11     : 1;            /*!< [11..11] Clear Pn.11                                                      */
            uint32_t            : 20;
    } BCLR_b;
  } ;
} SN_GPIO3_Type;                                /*!< Size = 44 (0x2c)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_ADC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief ADC (SN_ADC)
  */

typedef struct {                                /*!< (@ 0x40026000) SN_ADC Structure                                           */
  
  union {
    __IOM uint32_t ADM;                         /*!< (@ 0x00000000) Offset:0x00 ADC Management Register                        */
    
    struct {
      __IOM uint32_t CHS        : 5;            /*!< [4..0] ADC input channel                                                  */
      __IOM uint32_t EOC        : 1;            /*!< [5..5] ADC status                                                         */
      __IOM uint32_t ADS        : 1;            /*!< [6..6] ADC start control                                                  */
      __IOM uint32_t ADLEN      : 1;            /*!< [7..7] ADC resolution                                                     */
      __IOM uint32_t ADCKS      : 3;            /*!< [10..8] ADC clock source divider                                          */
      __IOM uint32_t ADENB      : 1;            /*!< [11..11] ADC enable                                                       */
      __IOM uint32_t AVREFHSEL  : 1;            /*!< [12..12] ADC high reference voltage source                                */
      __IOM uint32_t VHS        : 3;            /*!< [15..13] Internal Ref. voltage source                                     */
      __IOM uint32_t GCHS       : 1;            /*!< [16..16] ADC global channel enable                                        */
            uint32_t            : 15;
    } ADM_b;
  } ;
  __IM  uint32_t  ADB;                          /*!< (@ 0x00000004) Offset:0x04 ADC Data Register                              */
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x0000000C) Offset:0x0C ADC Interrupt Enable Register                  */
    
    struct {
      __IOM uint32_t IE0        : 1;            /*!< [0..0] AIN0 interrupt enable                                              */
      __IOM uint32_t IE1        : 1;            /*!< [1..1] AIN1 interrupt enable                                              */
      __IOM uint32_t IE2        : 1;            /*!< [2..2] AIN2 interrupt enable                                              */
      __IOM uint32_t IE3        : 1;            /*!< [3..3] AIN3 interrupt enable                                              */
      __IOM uint32_t IE4        : 1;            /*!< [4..4] AIN4 interrupt enable                                              */
      __IOM uint32_t IE5        : 1;            /*!< [5..5] AIN5 interrupt enable                                              */
      __IOM uint32_t IE6        : 1;            /*!< [6..6] AIN6 interrupt enable                                              */
      __IOM uint32_t IE7        : 1;            /*!< [7..7] AIN7 interrupt enable                                              */
      __IOM uint32_t IE8        : 1;            /*!< [8..8] AIN8 interrupt enable                                              */
      __IOM uint32_t IE9        : 1;            /*!< [9..9] AIN9 interrupt enable                                              */
      __IOM uint32_t IE10       : 1;            /*!< [10..10] AIN10 interrupt enable                                           */
      __IOM uint32_t IE11       : 1;            /*!< [11..11] AIN11 interrupt enable                                           */
      __IOM uint32_t IE12       : 1;            /*!< [12..12] AIN12 interrupt enable                                           */
      __IOM uint32_t IE13       : 1;            /*!< [13..13] AIN13 interrupt enable                                           */
      __IOM uint32_t IE14       : 1;            /*!< [14..14] AIN14 interrupt enable                                           */
      __IOM uint32_t IE15       : 1;            /*!< [15..15] AIN15 interrupt enable                                           */
      __IOM uint32_t IE16       : 1;            /*!< [16..16] AIN16 interrupt enable                                           */
      __IOM uint32_t IE17       : 1;            /*!< [17..17] AIN17 interrupt enable                                           */
      __IOM uint32_t IE18       : 1;            /*!< [18..18] AIN18 interrupt enable                                           */
            uint32_t            : 13;
    } IE_b;
  } ;
  __IOM uint32_t  RIS;                          /*!< (@ 0x00000010) Offset:0x10 ADC Raw Interrupt Status Register              */
} SN_ADC_Type;                                  /*!< Size = 20 (0x14)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_CT16B0                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief 16-bit Timer 0 with Capture function (SN_CT16B0)
  */

typedef struct {                                /*!< (@ 0x40000000) SN_CT16B0 Structure                                        */
  
  union {
    __IOM uint32_t TMRCTRL;                     /*!< (@ 0x00000000) Offset:0x00 CT16Bn Timer Control Register                  */
    
    struct {
      __IOM uint32_t CEN        : 1;            /*!< [0..0] Counter enable                                                     */
      __IOM uint32_t CRST       : 1;            /*!< [1..1] Counter Reset                                                      */
            uint32_t            : 30;
    } TMRCTRL_b;
  } ;
  
  union {
    __IOM uint32_t TC;                          /*!< (@ 0x00000004) Offset:0x04 CT16Bn Timer Counter Register                  */
    
    struct {
      __IOM uint32_t TC         : 16;           /*!< [15..0] Timer Counter                                                     */
            uint32_t            : 16;
    } TC_b;
  } ;
  
  union {
    __IOM uint32_t PRE;                         /*!< (@ 0x00000008) Offset:0x08 CT16Bn Prescale Register                       */
    
    struct {
      __IOM uint32_t PRE        : 8;            /*!< [7..0] Prescaler                                                          */
            uint32_t            : 24;
    } PRE_b;
  } ;
  
  union {
    __IOM uint32_t PC;                          /*!< (@ 0x0000000C) Offset:0x0C CT16Bn Prescale Counter Register               */
    
    struct {
      __IOM uint32_t PC         : 8;            /*!< [7..0] Prescaler Counter                                                  */
            uint32_t            : 24;
    } PC_b;
  } ;
  
  union {
    __IOM uint32_t CNTCTRL;                     /*!< (@ 0x00000010) Offset:0x10 CT16Bn Counter Control Register                */
    
    struct {
      __IOM uint32_t CTM        : 2;            /*!< [1..0] Counter/Timer Mode                                                 */
      __IOM uint32_t CIS        : 2;            /*!< [3..2] Counter Input Select                                               */
            uint32_t            : 28;
    } CNTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t MCTRL;                       /*!< (@ 0x00000014) Offset:0x14 CT16Bn Match Control Register                  */
    
    struct {
      __IOM uint32_t MR0IE      : 1;            /*!< [0..0] Enable generating an interrupt when MR0 matches TC                 */
      __IOM uint32_t MR0RST     : 1;            /*!< [1..1] Enable reset TC when MR0 matches TC                                */
      __IOM uint32_t MR0STOP    : 1;            /*!< [2..2] Stop TC and PC and clear CEN bit when MR0 matches TC               */
            uint32_t            : 29;
    } MCTRL_b;
  } ;
  __IM  uint32_t  RESERVED[2];
  __IOM uint32_t  MR0;                          /*!< (@ 0x00000020) Offset:0x20 CT16Bn MR0 Register                            */
  __IM  uint32_t  RESERVED1[23];
  
  union {
    __IOM uint32_t CAPCTRL;                     /*!< (@ 0x00000080) Offset:0x80 CT16Bn Capture Control Register                */
    
    struct {
      __IOM uint32_t CAP0RE     : 1;            /*!< [0..0] Capture on CT16Bn_CAP0 rising edge                                 */
      __IOM uint32_t CAP0FE     : 1;            /*!< [1..1] Capture on CT16Bn_CAP0 falling edge                                */
      __IOM uint32_t CAP0IE     : 1;            /*!< [2..2] Interrupt on CT16Bn_CAP0 event                                     */
      __IOM uint32_t CAP0EN     : 1;            /*!< [3..3] CAP0 function enable                                               */
            uint32_t            : 28;
    } CAPCTRL_b;
  } ;
  
  union {
    __IM  uint32_t CAP0;                        /*!< (@ 0x00000084) Offset:0x84 CT16Bn CAP0 Register                           */
    
    struct {
      __IM  uint32_t CAP0       : 16;           /*!< [15..0] Timer counter capture value                                       */
            uint32_t            : 16;
    } CAP0_b;
  } ;
  __IM  uint32_t  RESERVED2[7];
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x000000A4) Offset:0xA4 CT16Bn Raw Interrupt Status Register           */
    
    struct {
      __IM  uint32_t MR0IF      : 1;            /*!< [0..0] Match channel 0 interrupt flag                                     */
            uint32_t            : 24;
      __IM  uint32_t CAP0IF     : 1;            /*!< [25..25] Interrupt flag for capture channel 0                             */
            uint32_t            : 6;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x000000A8) Offset:0xA8 CT16Bn Interrupt Clear Register                */
    
    struct {
      __OM  uint32_t MR0IC      : 1;            /*!< [0..0] MR0IF clear bit                                                    */
            uint32_t            : 24;
      __OM  uint32_t CAP0IC     : 1;            /*!< [25..25] CAP0IF clear bit                                                 */
            uint32_t            : 6;
    } IC_b;
  } ;
} SN_CT16B0_Type;                               /*!< Size = 172 (0xac)                                                         */



/* =========================================================================================================================== */
/* ================                                         SN_CT16B1                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief 16-bit Timer 0 with Capture function (SN_CT16B1)
  */

typedef struct {                                /*!< (@ 0x40002000) SN_CT16B1 Structure                                        */
  
  union {
    __IOM uint32_t TMRCTRL;                     /*!< (@ 0x00000000) Offset:0x00 CT16Bn Timer Control Register                  */
    
    struct {
      __IOM uint32_t CEN        : 1;            /*!< [0..0] Counter enable                                                     */
      __IOM uint32_t CRST       : 1;            /*!< [1..1] Counter Reset                                                      */
            uint32_t            : 30;
    } TMRCTRL_b;
  } ;
  
  union {
    __IOM uint32_t TC;                          /*!< (@ 0x00000004) Offset:0x04 CT16Bn Timer Counter Register                  */
    
    struct {
      __IOM uint32_t TC         : 16;           /*!< [15..0] Timer Counter                                                     */
            uint32_t            : 16;
    } TC_b;
  } ;
  
  union {
    __IOM uint32_t PRE;                         /*!< (@ 0x00000008) Offset:0x08 CT16Bn Prescale Register                       */
    
    struct {
      __IOM uint32_t PRE        : 8;            /*!< [7..0] Prescaler                                                          */
            uint32_t            : 24;
    } PRE_b;
  } ;
  
  union {
    __IOM uint32_t PC;                          /*!< (@ 0x0000000C) Offset:0x0C CT16Bn Prescale Counter Register               */
    
    struct {
      __IOM uint32_t PC         : 8;            /*!< [7..0] Prescaler Counter                                                  */
            uint32_t            : 24;
    } PC_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t MCTRL;                       /*!< (@ 0x00000014) Offset:0x14 CT16Bn Match Control Register                  */
    
    struct {
      __IOM uint32_t MR0IE      : 1;            /*!< [0..0] Enable generating an interrupt when MR0 matches TC                 */
      __IOM uint32_t MR0RST     : 1;            /*!< [1..1] Enable reset TC when MR0 matches TC                                */
      __IOM uint32_t MR0STOP    : 1;            /*!< [2..2] Stop TC and PC and clear CEN bit when MR0 matches TC               */
      __IOM uint32_t MR1IE      : 1;            /*!< [3..3] Enable generating an interrupt when MR1 matches TC                 */
      __IOM uint32_t MR1RST     : 1;            /*!< [4..4] Enable reset TC when MR1 matches TC                                */
      __IOM uint32_t MR1STOP    : 1;            /*!< [5..5] Stop TC and PC and clear CEN bit when MR1 matches TC               */
      __IOM uint32_t MR2IE      : 1;            /*!< [6..6] Enable generating an interrupt when MR2 matches TC                 */
      __IOM uint32_t MR2RST     : 1;            /*!< [7..7] Enable reset TC when MR2 matches TC                                */
      __IOM uint32_t MR2STOP    : 1;            /*!< [8..8] Stop TC and PC and clear CEN bit when MR2 matches TC               */
      __IOM uint32_t MR3IE      : 1;            /*!< [9..9] Enable generating an interrupt when MR3 matches TC                 */
      __IOM uint32_t MR3RST     : 1;            /*!< [10..10] Enable reset TC when MR3 matches TC                              */
      __IOM uint32_t MR3STOP    : 1;            /*!< [11..11] Stop TC and PC and clear CEN bit when MR3 matches TC             */
      __IOM uint32_t MR4IE      : 1;            /*!< [12..12] Enable generating an interrupt when MR4 matches TC               */
      __IOM uint32_t MR4RST     : 1;            /*!< [13..13] Enable reset TC when MR4 matches TC                              */
      __IOM uint32_t MR4STOP    : 1;            /*!< [14..14] Stop TC and PC and clear CEN bit when MR4 matches TC             */
      __IOM uint32_t MR5IE      : 1;            /*!< [15..15] Enable generating an interrupt when MR5 matches TC               */
      __IOM uint32_t MR5RST     : 1;            /*!< [16..16] Enable reset TC when MR5 matches TC                              */
      __IOM uint32_t MR5STOP    : 1;            /*!< [17..17] Stop TC and PC and clear CEN bit when MR5 matches TC             */
      __IOM uint32_t MR6IE      : 1;            /*!< [18..18] Enable generating an interrupt when MR6 matches TC               */
      __IOM uint32_t MR6RST     : 1;            /*!< [19..19] Enable reset TC when MR6 matches TC                              */
      __IOM uint32_t MR6STOP    : 1;            /*!< [20..20] Stop TC and PC and clear CEN bit when MR6 matches TC             */
      __IOM uint32_t MR7IE      : 1;            /*!< [21..21] Enable generating an interrupt when MR7 matches TC               */
      __IOM uint32_t MR7RST     : 1;            /*!< [22..22] Enable reset TC when MR7 matches TC                              */
      __IOM uint32_t MR7STOP    : 1;            /*!< [23..23] Stop TC and PC and clear CEN bit when MR7 matches TC             */
      __IOM uint32_t MR8IE      : 1;            /*!< [24..24] Enable generating an interrupt when MR8 matches TC               */
      __IOM uint32_t MR8RST     : 1;            /*!< [25..25] Enable reset TC when MR8 matches TC                              */
      __IOM uint32_t MR8STOP    : 1;            /*!< [26..26] Stop TC and PC and clear CEN bit when MR8 matches TC             */
      __IOM uint32_t MR9IE      : 1;            /*!< [27..27] Enable generating an interrupt when MR9 matches TC               */
      __IOM uint32_t MR9RST     : 1;            /*!< [28..28] Enable reset TC when MR9 matches TC                              */
      __IOM uint32_t MR9STOP    : 1;            /*!< [29..29] Stop TC and PC and clear CEN bit when MR9 matches TC             */
            uint32_t            : 2;
    } MCTRL_b;
  } ;
  
  union {
    __IOM uint32_t MCTRL2;                      /*!< (@ 0x00000018) Offset:0x18 CT16Bn Match Control Register 2                */
    
    struct {
      __IOM uint32_t MR10IE     : 1;            /*!< [0..0] Enable generating an interrupt when MR10 matches TC                */
      __IOM uint32_t MR10RST    : 1;            /*!< [1..1] Enable reset TC when MR10 matches TC                               */
      __IOM uint32_t MR10STOP   : 1;            /*!< [2..2] Stop TC and PC and clear CEN bit when MR10 matches TC              */
      __IOM uint32_t MR11IE     : 1;            /*!< [3..3] Enable generating an interrupt when MR11 matches TC                */
      __IOM uint32_t MR11RST    : 1;            /*!< [4..4] Enable reset TC when MR11 matches TC                               */
      __IOM uint32_t MR11STOP   : 1;            /*!< [5..5] Stop TC and PC and clear CEN bit when MR11 matches TC              */
      __IOM uint32_t MR12IE     : 1;            /*!< [6..6] Enable generating an interrupt when MR12 matches TC                */
      __IOM uint32_t MR12RST    : 1;            /*!< [7..7] Enable reset TC when MR12 matches TC                               */
      __IOM uint32_t MR12STOP   : 1;            /*!< [8..8] Stop TC and PC and clear CEN bit when MR12 matches TC              */
      __IOM uint32_t MR13IE     : 1;            /*!< [9..9] Enable generating an interrupt when MR13 matches TC                */
      __IOM uint32_t MR13RST    : 1;            /*!< [10..10] Enable reset TC when MR13 matches TC                             */
      __IOM uint32_t MR13STOP   : 1;            /*!< [11..11] Stop TC and PC and clear CEN bit when MR13 matches
                                                     TC                                                                        */
      __IOM uint32_t MR14IE     : 1;            /*!< [12..12] Enable generating an interrupt when MR14 matches TC              */
      __IOM uint32_t MR14RST    : 1;            /*!< [13..13] Enable reset TC when MR14 matches TC                             */
      __IOM uint32_t MR14STOP   : 1;            /*!< [14..14] Stop TC and PC and clear CEN bit when MR14 matches
                                                     TC                                                                        */
      __IOM uint32_t MR15IE     : 1;            /*!< [15..15] Enable generating an interrupt when MR15 matches TC              */
      __IOM uint32_t MR15RST    : 1;            /*!< [16..16] Enable reset TC when MR15 matches TC                             */
      __IOM uint32_t MR15STOP   : 1;            /*!< [17..17] Stop TC and PC and clear CEN bit when MR15 matches
                                                     TC                                                                        */
      __IOM uint32_t MR16IE     : 1;            /*!< [18..18] Enable generating an interrupt when MR16 matches TC              */
      __IOM uint32_t MR16RST    : 1;            /*!< [19..19] Enable reset TC when MR16 matches TC                             */
      __IOM uint32_t MR16STOP   : 1;            /*!< [20..20] Stop TC and PC and clear CEN bit when MR16 matches
                                                     TC                                                                        */
      __IOM uint32_t MR17IE     : 1;            /*!< [21..21] Enable generating an interrupt when MR17 matches TC              */
      __IOM uint32_t MR17RST    : 1;            /*!< [22..22] Enable reset TC when MR17 matches TC                             */
      __IOM uint32_t MR17STOP   : 1;            /*!< [23..23] Stop TC and PC and clear CEN bit when MR17 matches
                                                     TC                                                                        */
      __IOM uint32_t MR18IE     : 1;            /*!< [24..24] Enable generating an interrupt when MR18 matches TC              */
      __IOM uint32_t MR18RST    : 1;            /*!< [25..25] Enable reset TC when MR18 matches TC                             */
      __IOM uint32_t MR18STOP   : 1;            /*!< [26..26] Stop TC and PC and clear CEN bit when MR18 matches
                                                     TC                                                                        */
      __IOM uint32_t MR19IE     : 1;            /*!< [27..27] Enable generating an interrupt when MR19 matches TC              */
      __IOM uint32_t MR19RST    : 1;            /*!< [28..28] Enable reset TC when MR19 matches TC                             */
      __IOM uint32_t MR19STOP   : 1;            /*!< [29..29] Stop TC and PC and clear CEN bit when MR19 matches
                                                     TC                                                                        */
            uint32_t            : 2;
    } MCTRL2_b;
  } ;
  
  union {
    __IOM uint32_t MCTRL3;                      /*!< (@ 0x0000001C) Offset:0x1C CT16Bn Match Control Register 3                */
    
    struct {
      __IOM uint32_t MR20IE     : 1;            /*!< [0..0] Enable generating an interrupt when MR20 matches TC                */
      __IOM uint32_t MR20RST    : 1;            /*!< [1..1] Enable reset TC when MR20 matches TC                               */
      __IOM uint32_t MR20STOP   : 1;            /*!< [2..2] Stop TC and PC and clear CEN bit when MR20 matches TC              */
      __IOM uint32_t MR21IE     : 1;            /*!< [3..3] Enable generating an interrupt when MR21 matches TC                */
      __IOM uint32_t MR21RST    : 1;            /*!< [4..4] Enable reset TC when MR21 matches TC                               */
      __IOM uint32_t MR21STOP   : 1;            /*!< [5..5] Stop TC and PC and clear CEN bit when MR21 matches TC              */
      __IOM uint32_t MR22IE     : 1;            /*!< [6..6] Enable generating an interrupt when MR22 matches TC                */
      __IOM uint32_t MR22RST    : 1;            /*!< [7..7] Enable reset TC when MR22 matches TC                               */
      __IOM uint32_t MR22STOP   : 1;            /*!< [8..8] Stop TC and PC and clear CEN bit when MR22 matches TC              */
      __IOM uint32_t MR23IE     : 1;            /*!< [9..9] Enable generating an interrupt when MR23 matches TC                */
      __IOM uint32_t MR23RST    : 1;            /*!< [10..10] Enable reset TC when MR23 matches TC                             */
      __IOM uint32_t MR23STOP   : 1;            /*!< [11..11] Stop TC and PC and clear CEN bit when MR23 matches
                                                     TC                                                                        */
      __IOM uint32_t MR24IE     : 1;            /*!< [12..12] Enable generating an interrupt when MR24 matches TC              */
      __IOM uint32_t MR24RST    : 1;            /*!< [13..13] Enable reset TC when MR24 matches TC                             */
      __IOM uint32_t MR24STOP   : 1;            /*!< [14..14] Stop TC and PC and clear CEN bit when MR24 matches
                                                     TC                                                                        */
            uint32_t            : 17;
    } MCTRL3_b;
  } ;
  __IOM uint32_t  MR0;                          /*!< (@ 0x00000020) Offset:0x20 CT16Bn MR0 Register                            */
  __IOM uint32_t  MR1;                          /*!< (@ 0x00000024) Offset:0x24 CT16Bn MR1 Register                            */
  __IOM uint32_t  MR2;                          /*!< (@ 0x00000028) Offset:0x28 CT16Bn MR2 Register                            */
  __IOM uint32_t  MR3;                          /*!< (@ 0x0000002C) Offset:0x2C CT16Bn MR3 Register                            */
  __IOM uint32_t  MR4;                          /*!< (@ 0x00000030) Offset:0x30 CT16Bn MR4 Register                            */
  __IOM uint32_t  MR5;                          /*!< (@ 0x00000034) Offset:0x34 CT16Bn MR5 Register                            */
  __IOM uint32_t  MR6;                          /*!< (@ 0x00000038) Offset:0x38 CT16Bn MR6 Register                            */
  __IOM uint32_t  MR7;                          /*!< (@ 0x0000003C) Offset:0x3C CT16Bn MR7 Register                            */
  __IOM uint32_t  MR8;                          /*!< (@ 0x00000040) Offset:0x40 CT16Bn MR8 Register                            */
  __IOM uint32_t  MR9;                          /*!< (@ 0x00000044) Offset:0x44 CT16Bn MR9 Register                            */
  __IOM uint32_t  MR10;                         /*!< (@ 0x00000048) Offset:0x48 CT16Bn MR10 Register                           */
  __IOM uint32_t  MR11;                         /*!< (@ 0x0000004C) Offset:0x4C CT16Bn MR11 Register                           */
  __IOM uint32_t  MR12;                         /*!< (@ 0x00000050) Offset:0x50 CT16Bn MR12 Register                           */
  __IOM uint32_t  MR13;                         /*!< (@ 0x00000054) Offset:0x54 CT16Bn MR13 Register                           */
  __IOM uint32_t  MR14;                         /*!< (@ 0x00000058) Offset:0x58 CT16Bn MR14 Register                           */
  __IOM uint32_t  MR15;                         /*!< (@ 0x0000005C) Offset:0x5C CT16Bn MR15 Register                           */
  __IOM uint32_t  MR16;                         /*!< (@ 0x00000060) Offset:0x60 CT16Bn MR16 Register                           */
  __IOM uint32_t  MR17;                         /*!< (@ 0x00000064) Offset:0x64 CT16Bn MR17 Register                           */
  __IOM uint32_t  MR18;                         /*!< (@ 0x00000068) Offset:0x68 CT16Bn MR18 Register                           */
  __IOM uint32_t  MR19;                         /*!< (@ 0x0000006C) Offset:0x6C CT16Bn MR19 Register                           */
  __IOM uint32_t  MR20;                         /*!< (@ 0x00000070) Offset:0x70 CT16Bn MR20 Register                           */
  __IOM uint32_t  MR21;                         /*!< (@ 0x00000074) Offset:0x74 CT16Bn MR21 Register                           */
  __IOM uint32_t  MR22;                         /*!< (@ 0x00000078) Offset:0x78 CT16Bn MR22 Register                           */
  __IOM uint32_t  MR23;                         /*!< (@ 0x0000007C) Offset:0x7C CT16Bn MR23 Register                           */
  __IOM uint32_t  MR24;                         /*!< (@ 0x00000080) Offset:0x80 CT16Bn MR24 Register                           */
  __IM  uint32_t  RESERVED1;
  
  union {
    __IOM uint32_t EM;                          /*!< (@ 0x00000088) Offset:0x88 CT16Bn External Match Register                 */
    
    struct {
      __IOM uint32_t EM0        : 1;            /*!< [0..0] When the TC doesn't match MR0 and EMC0 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM0 output.                           */
      __IOM uint32_t EM1        : 1;            /*!< [1..1] When the TC doesn't match MR1 and EMC1 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM1 output.                           */
      __IOM uint32_t EM2        : 1;            /*!< [2..2] When the TC doesn't match MR2 and EMC2 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM2 output.                           */
      __IOM uint32_t EM3        : 1;            /*!< [3..3] When the TC doesn't match MR3 and EMC3 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM3 output.                           */
      __IOM uint32_t EM4        : 1;            /*!< [4..4] When the TC doesn't match MR4 and EMC4 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM4 output.                           */
      __IOM uint32_t EM5        : 1;            /*!< [5..5] When the TC doesn't match MR5 and EMC5 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM5 output.                           */
      __IOM uint32_t EM6        : 1;            /*!< [6..6] When the TC doesn't match MR6 and EMC6 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM6 output.                           */
      __IOM uint32_t EM7        : 1;            /*!< [7..7] When the TC doesn't match MR7 and EMC7 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM7 output.                           */
      __IOM uint32_t EM8        : 1;            /*!< [8..8] When the TC doesn't match MR8 and EMC8 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM8 output.                           */
      __IOM uint32_t EM9        : 1;            /*!< [9..9] When the TC doesn't match MR9 and EMC9 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM9 output.                           */
      __IOM uint32_t EM10       : 1;            /*!< [10..10] When the TC doesn't match MR10 and EMC10 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM10 output.                     */
      __IOM uint32_t EM11       : 1;            /*!< [11..11] When the TC doesn't match MR11 and EMC11 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM11 output.                     */
      __IOM uint32_t EM12       : 1;            /*!< [12..12] When the TC doesn't match MR12 and EMC12 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM12 output.                     */
      __IOM uint32_t EM13       : 1;            /*!< [13..13] When the TC doesn't match MR13 and EMC13 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM13 output.                     */
      __IOM uint32_t EM14       : 1;            /*!< [14..14] When the TC doesn't match MR14 and EMC14 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM14 output.                     */
      __IOM uint32_t EM15       : 1;            /*!< [15..15] When the TC doesn't match MR15 and EMC15 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM15 output.                     */
      __IOM uint32_t EM16       : 1;            /*!< [16..16] When the TC doesn't match MR16 and EMC16 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM16 output.                     */
      __IOM uint32_t EM17       : 1;            /*!< [17..17] When the TC doesn't match MR17 and EMC17 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM17 output.                     */
      __IOM uint32_t EM18       : 1;            /*!< [18..18] When the TC doesn't match MR18 and EMC18 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM18 output.                     */
      __IOM uint32_t EM19       : 1;            /*!< [19..19] When the TC doesn't match MR19 and EMC19 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM19 output.                     */
      __IOM uint32_t EM20       : 1;            /*!< [20..20] When the TC doesn't match MR20 and EMC20 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM20 output.                     */
      __IOM uint32_t EM21       : 1;            /*!< [21..21] When the TC doesn't match MR21 and EMC21 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM21 output.                     */
      __IOM uint32_t EM22       : 1;            /*!< [22..22] When the TC doesn't match MR22 and EMC22 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM22 output.                     */
      __IOM uint32_t EM23       : 1;            /*!< [23..23] When the TC doesn't match MR23 and EMC23 is not 0,
                                                     this bit will drive the state of CT16Bn_PWM23 output.                     */
            uint32_t            : 8;
    } EM_b;
  } ;
  
  union {
    __IOM uint32_t EMC;                         /*!< (@ 0x0000008C) Offset:0x8C CT16Bn External Match Control register         */
    
    struct {
      __IOM uint32_t EMC0       : 2;            /*!< [1..0] CT16Bn_PWM0 functionality when the TC matches MR0                  */
      __IOM uint32_t EMC1       : 2;            /*!< [3..2] CT16Bn_PWM1 functionality when the TC matches MR1                  */
      __IOM uint32_t EMC2       : 2;            /*!< [5..4] CT16Bn_PWM2 functionality when the TC matches MR2                  */
      __IOM uint32_t EMC3       : 2;            /*!< [7..6] CT16Bn_PWM3 functionality when the TC matches MR3                  */
      __IOM uint32_t EMC4       : 2;            /*!< [9..8] CT16Bn_PWM4 functionality when the TC matches MR4                  */
      __IOM uint32_t EMC5       : 2;            /*!< [11..10] CT16Bn_PWM5 functionality when the TC matches MR5                */
      __IOM uint32_t EMC6       : 2;            /*!< [13..12] CT16Bn_PWM6 functionality when the TC matches MR6                */
      __IOM uint32_t EMC7       : 2;            /*!< [15..14] CT16Bn_PWM7 functionality when the TC matches MR7                */
      __IOM uint32_t EMC8       : 2;            /*!< [17..16] CT16Bn_PWM8 functionality when the TC matches MR8                */
      __IOM uint32_t EMC9       : 2;            /*!< [19..18] CT16Bn_PWM9 functionality when the TC matches MR9                */
      __IOM uint32_t EMC10      : 2;            /*!< [21..20] CT16Bn_PWM10 functionality when the TC matches MR10              */
      __IOM uint32_t EMC11      : 2;            /*!< [23..22] CT16Bn_PWM11 functionality when the TC matches MR11              */
      __IOM uint32_t EMC12      : 2;            /*!< [25..24] CT16Bn_PWM12 functionality when the TC matches MR12              */
      __IOM uint32_t EMC13      : 2;            /*!< [27..26] CT16Bn_PWM13 functionality when the TC matches MR13              */
      __IOM uint32_t EMC14      : 2;            /*!< [29..28] CT16Bn_PWM14 functionality when the TC matches MR14              */
      __IOM uint32_t EMC15      : 2;            /*!< [31..30] CT16Bn_PWM15 functionality when the TC matches MR15              */
    } EMC_b;
  } ;
  
  union {
    __IOM uint32_t EMC2;                        /*!< (@ 0x00000090) Offset:0x90 CT16Bn External Match Control register
                                                                    2                                                          */
    
    struct {
      __IOM uint32_t EMC16      : 2;            /*!< [1..0] CT16Bn_PWM16 functionality when the TC matches MR16                */
      __IOM uint32_t EMC17      : 2;            /*!< [3..2] CT16Bn_PWM17 functionality when the TC matches MR17                */
      __IOM uint32_t EMC18      : 2;            /*!< [5..4] CT16Bn_PWM18 functionality when the TC matches MR18                */
      __IOM uint32_t EMC19      : 2;            /*!< [7..6] CT16Bn_PWM19 functionality when the TC matches MR19                */
      __IOM uint32_t EMC20      : 2;            /*!< [9..8] CT16Bn_PWM20 functionality when the TC matches MR20                */
      __IOM uint32_t EMC21      : 2;            /*!< [11..10] CT16Bn_PWM21 functionality when the TC matches MR21              */
      __IOM uint32_t EMC22      : 2;            /*!< [13..12] CT16Bn_PWM22 functionality when the TC matches MR22              */
      __IOM uint32_t EMC23      : 2;            /*!< [15..14] CT16Bn_PWM23 functionality when the TC matches MR23              */
            uint32_t            : 16;
    } EMC2_b;
  } ;
  
  union {
    __IOM uint32_t PWMCTRL;                     /*!< (@ 0x00000094) Offset:0x94 CT16Bn PWM Control Register                    */
    
    struct {
      __IOM uint32_t PWM0MODE   : 2;            /*!< [1..0] PWM0 output mode                                                   */
      __IOM uint32_t PWM1MODE   : 2;            /*!< [3..2] PWM1 output mode                                                   */
      __IOM uint32_t PWM2MODE   : 2;            /*!< [5..4] PWM2 output mode                                                   */
      __IOM uint32_t PWM3MODE   : 2;            /*!< [7..6] PWM3 output mode                                                   */
      __IOM uint32_t PWM4MODE   : 2;            /*!< [9..8] PWM4 output mode                                                   */
      __IOM uint32_t PWM5MODE   : 2;            /*!< [11..10] PWM5 output mode                                                 */
      __IOM uint32_t PWM6MODE   : 2;            /*!< [13..12] PWM6 output mode                                                 */
      __IOM uint32_t PWM7MODE   : 2;            /*!< [15..14] PWM7 output mode                                                 */
      __IOM uint32_t PWM8MODE   : 2;            /*!< [17..16] PWM8 output mode                                                 */
      __IOM uint32_t PWM9MODE   : 2;            /*!< [19..18] PWM9 output mode                                                 */
      __IOM uint32_t PWM10MODE  : 2;            /*!< [21..20] PWM10 output mode                                                */
      __IOM uint32_t PWM11MODE  : 2;            /*!< [23..22] PWM11 output mode                                                */
      __IOM uint32_t PWM12MODE  : 2;            /*!< [25..24] PWM12 output mode                                                */
      __IOM uint32_t PWM13MODE  : 2;            /*!< [27..26] PWM13 output mode                                                */
      __IOM uint32_t PWM14MODE  : 2;            /*!< [29..28] PWM14 output mode                                                */
      __IOM uint32_t PWM15MODE  : 2;            /*!< [31..30] PWM15 output mode                                                */
    } PWMCTRL_b;
  } ;
  
  union {
    __IOM uint32_t PWMCTRL2;                    /*!< (@ 0x00000098) Offset:0x98 CT16Bn PWM Control Register 2                  */
    
    struct {
      __IOM uint32_t PWM16MODE  : 2;            /*!< [1..0] PWM16 output mode                                                  */
      __IOM uint32_t PWM17MODE  : 2;            /*!< [3..2] PWM17 output mode                                                  */
      __IOM uint32_t PWM18MODE  : 2;            /*!< [5..4] PWM18 output mode                                                  */
      __IOM uint32_t PWM19MODE  : 2;            /*!< [7..6] PWM19 output mode                                                  */
      __IOM uint32_t PWM20MODE  : 2;            /*!< [9..8] PWM20 output mode                                                  */
      __IOM uint32_t PWM21MODE  : 2;            /*!< [11..10] PWM21 output mode                                                */
      __IOM uint32_t PWM22MODE  : 2;            /*!< [13..12] PWM22 output mode                                                */
      __IOM uint32_t PWM23MODE  : 2;            /*!< [15..14] PWM23 output mode                                                */
            uint32_t            : 16;
    } PWMCTRL2_b;
  } ;
  
  union {
    __IOM uint32_t PWMENB;                      /*!< (@ 0x0000009C) Offset:0x9C CT16Bn PWM Enable register                     */
    
    struct {
      __IOM uint32_t PWM0EN     : 1;            /*!< [0..0] PWM0 enable                                                        */
      __IOM uint32_t PWM1EN     : 1;            /*!< [1..1] PWM1 enable                                                        */
      __IOM uint32_t PWM2EN     : 1;            /*!< [2..2] PWM2 enable                                                        */
      __IOM uint32_t PWM3EN     : 1;            /*!< [3..3] PWM3 enable                                                        */
      __IOM uint32_t PWM4EN     : 1;            /*!< [4..4] PWM4 enable                                                        */
      __IOM uint32_t PWM5EN     : 1;            /*!< [5..5] PWM5 enable                                                        */
      __IOM uint32_t PWM6EN     : 1;            /*!< [6..6] PWM6 enable                                                        */
      __IOM uint32_t PWM7EN     : 1;            /*!< [7..7] PWM7 enable                                                        */
      __IOM uint32_t PWM8EN     : 1;            /*!< [8..8] PWM8 enable                                                        */
      __IOM uint32_t PWM9EN     : 1;            /*!< [9..9] PWM9 enable                                                        */
      __IOM uint32_t PWM10EN    : 1;            /*!< [10..10] PWM10 enable                                                     */
      __IOM uint32_t PWM11EN    : 1;            /*!< [11..11] PWM11 enable                                                     */
      __IOM uint32_t PWM12EN    : 1;            /*!< [12..12] PWM12 enable                                                     */
      __IOM uint32_t PWM13EN    : 1;            /*!< [13..13] PWM13 enable                                                     */
      __IOM uint32_t PWM14EN    : 1;            /*!< [14..14] PWM14 enable                                                     */
      __IOM uint32_t PWM15EN    : 1;            /*!< [15..15] PWM15 enable                                                     */
      __IOM uint32_t PWM16EN    : 1;            /*!< [16..16] PWM16 enable                                                     */
      __IOM uint32_t PWM17EN    : 1;            /*!< [17..17] PWM17 enable                                                     */
      __IOM uint32_t PWM18EN    : 1;            /*!< [18..18] PWM18 enable                                                     */
      __IOM uint32_t PWM19EN    : 1;            /*!< [19..19] PWM19 enable                                                     */
      __IOM uint32_t PWM20EN    : 1;            /*!< [20..20] PWM20 enable                                                     */
      __IOM uint32_t PWM21EN    : 1;            /*!< [21..21] PWM21 enable                                                     */
      __IOM uint32_t PWM22EN    : 1;            /*!< [22..22] PWM22 enable                                                     */
      __IOM uint32_t PWM23EN    : 1;            /*!< [23..23] PWM23 enable                                                     */
            uint32_t            : 8;
    } PWMENB_b;
  } ;
  
  union {
    __IOM uint32_t PWMIOENB;                    /*!< (@ 0x000000A0) Offset:0xA0 CT16Bn PWM IO Enable register                  */
    
    struct {
      __IOM uint32_t PWM0IOEN   : 1;            /*!< [0..0] CT16Bn_PWM0/GPIO selection                                         */
      __IOM uint32_t PWM1IOEN   : 1;            /*!< [1..1] CT16Bn_PWM1/GPIO selection                                         */
      __IOM uint32_t PWM2IOEN   : 1;            /*!< [2..2] CT16Bn_PWM2/GPIO selection                                         */
      __IOM uint32_t PWM3IOEN   : 1;            /*!< [3..3] CT16Bn_PWM3/GPIO selection                                         */
      __IOM uint32_t PWM4IOEN   : 1;            /*!< [4..4] CT16Bn_PWM4/GPIO selection                                         */
      __IOM uint32_t PWM5IOEN   : 1;            /*!< [5..5] CT16Bn_PWM5/GPIO selection                                         */
      __IOM uint32_t PWM6IOEN   : 1;            /*!< [6..6] CT16Bn_PWM6/GPIO selection                                         */
      __IOM uint32_t PWM7IOEN   : 1;            /*!< [7..7] CT16Bn_PWM7/GPIO selection                                         */
      __IOM uint32_t PWM8IOEN   : 1;            /*!< [8..8] CT16Bn_PWM8/GPIO selection                                         */
      __IOM uint32_t PWM9IOEN   : 1;            /*!< [9..9] CT16Bn_PWM9/GPIO selection                                         */
      __IOM uint32_t PWM10IOEN  : 1;            /*!< [10..10] CT16Bn_PWM10/GPIO selection                                      */
      __IOM uint32_t PWM11IOEN  : 1;            /*!< [11..11] CT16Bn_PWM11/GPIO selection                                      */
      __IOM uint32_t PWM12IOEN  : 1;            /*!< [12..12] CT16Bn_PWM12/GPIO selection                                      */
      __IOM uint32_t PWM13IOEN  : 1;            /*!< [13..13] CT16Bn_PWM13/GPIO selection                                      */
      __IOM uint32_t PWM14IOEN  : 1;            /*!< [14..14] CT16Bn_PWM14/GPIO selection                                      */
      __IOM uint32_t PWM15IOEN  : 1;            /*!< [15..15] CT16Bn_PWM15/GPIO selection                                      */
      __IOM uint32_t PWM16IOEN  : 1;            /*!< [16..16] CT16Bn_PWM16/GPIO selection                                      */
      __IOM uint32_t PWM17IOEN  : 1;            /*!< [17..17] CT16Bn_PWM17/GPIO selection                                      */
      __IOM uint32_t PWM18IOEN  : 1;            /*!< [18..18] CT16Bn_PWM18/GPIO selection                                      */
      __IOM uint32_t PWM19IOEN  : 1;            /*!< [19..19] CT16Bn_PWM19/GPIO selection                                      */
      __IOM uint32_t PWM20IOEN  : 1;            /*!< [20..20] CT16Bn_PWM20/GPIO selection                                      */
      __IOM uint32_t PWM21IOEN  : 1;            /*!< [21..21] CT16Bn_PWM21/GPIO selection                                      */
      __IOM uint32_t PWM22IOEN  : 1;            /*!< [22..22] CT16Bn_PWM22/GPIO selection                                      */
      __IOM uint32_t PWM23IOEN  : 1;            /*!< [23..23] CT16Bn_PWM23/GPIO selection                                      */
            uint32_t            : 8;
    } PWMIOENB_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x000000A4) Offset:0xA4 CT16Bn Raw Interrupt Status Register           */
    
    struct {
      __IM  uint32_t MR0IF      : 1;            /*!< [0..0] Match channel 0 interrupt flag                                     */
      __IM  uint32_t MR1IF      : 1;            /*!< [1..1] Match channel 1 interrupt flag                                     */
      __IM  uint32_t MR2IF      : 1;            /*!< [2..2] Match channel 2 interrupt flag                                     */
      __IM  uint32_t MR3IF      : 1;            /*!< [3..3] Match channel 3 interrupt flag                                     */
      __IM  uint32_t MR4IF      : 1;            /*!< [4..4] Match channel 4 interrupt flag                                     */
      __IM  uint32_t MR5IF      : 1;            /*!< [5..5] Match channel 5 interrupt flag                                     */
      __IM  uint32_t MR6IF      : 1;            /*!< [6..6] Match channel 6 interrupt flag                                     */
      __IM  uint32_t MR7IF      : 1;            /*!< [7..7] Match channel 7 interrupt flag                                     */
      __IM  uint32_t MR8IF      : 1;            /*!< [8..8] Match channel 8 interrupt flag                                     */
      __IM  uint32_t MR9IF      : 1;            /*!< [9..9] Match channel 9 interrupt flag                                     */
      __IM  uint32_t MR10IF     : 1;            /*!< [10..10] Match channel 10 interrupt flag                                  */
      __IM  uint32_t MR11IF     : 1;            /*!< [11..11] Match channel 11 interrupt flag                                  */
      __IM  uint32_t MR12IF     : 1;            /*!< [12..12] Match channel 12 interrupt flag                                  */
      __IM  uint32_t MR13IF     : 1;            /*!< [13..13] Match channel 13 interrupt flag                                  */
      __IM  uint32_t MR14IF     : 1;            /*!< [14..14] Match channel 14 interrupt flag                                  */
      __IM  uint32_t MR15IF     : 1;            /*!< [15..15] Match channel 15 interrupt flag                                  */
      __IM  uint32_t MR16IF     : 1;            /*!< [16..16] Match channel 16 interrupt flag                                  */
      __IM  uint32_t MR17IF     : 1;            /*!< [17..17] Match channel 17 interrupt flag                                  */
      __IM  uint32_t MR18IF     : 1;            /*!< [18..18] Match channel 18 interrupt flag                                  */
      __IM  uint32_t MR19IF     : 1;            /*!< [19..19] Match channel 19 interrupt flag                                  */
      __IM  uint32_t MR20IF     : 1;            /*!< [20..20] Match channel 20 interrupt flag                                  */
      __IM  uint32_t MR21IF     : 1;            /*!< [21..21] Match channel 21 interrupt flag                                  */
      __IM  uint32_t MR22IF     : 1;            /*!< [22..22] Match channel 22 interrupt flag                                  */
      __IM  uint32_t MR23IF     : 1;            /*!< [23..23] Match channel 23 interrupt flag                                  */
      __IM  uint32_t MR24IF     : 1;            /*!< [24..24] Match channel 24 interrupt flag                                  */
            uint32_t            : 7;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x000000A8) Offset:0xA8 CT16Bn Interrupt Clear Register                */
    
    struct {
      __OM  uint32_t MR0IC      : 1;            /*!< [0..0] MR0IF clear bit                                                    */
      __OM  uint32_t MR1IC      : 1;            /*!< [1..1] MR1IF clear bit                                                    */
      __OM  uint32_t MR2IC      : 1;            /*!< [2..2] MR2IF clear bit                                                    */
      __OM  uint32_t MR3IC      : 1;            /*!< [3..3] MR3IF clear bit                                                    */
      __OM  uint32_t MR4IC      : 1;            /*!< [4..4] MR4IF clear bit                                                    */
      __OM  uint32_t MR5IC      : 1;            /*!< [5..5] MR5IF clear bit                                                    */
      __OM  uint32_t MR6IC      : 1;            /*!< [6..6] MR6IF clear bit                                                    */
      __OM  uint32_t MR7IC      : 1;            /*!< [7..7] MR7IF clear bit                                                    */
      __OM  uint32_t MR8IC      : 1;            /*!< [8..8] MR8IF clear bit                                                    */
      __OM  uint32_t MR9IC      : 1;            /*!< [9..9] MR9IF clear bit                                                    */
      __OM  uint32_t MR10IC     : 1;            /*!< [10..10] MR10IF clear bit                                                 */
      __OM  uint32_t MR11IC     : 1;            /*!< [11..11] MR11IF clear bit                                                 */
      __OM  uint32_t MR12IC     : 1;            /*!< [12..12] MR12IF clear bit                                                 */
      __OM  uint32_t MR13IC     : 1;            /*!< [13..13] MR13IF clear bit                                                 */
      __OM  uint32_t MR14IC     : 1;            /*!< [14..14] MR14IF clear bit                                                 */
      __OM  uint32_t MR15IC     : 1;            /*!< [15..15] MR15IF clear bit                                                 */
      __OM  uint32_t MR16IC     : 1;            /*!< [16..16] MR16IF clear bit                                                 */
      __OM  uint32_t MR17IC     : 1;            /*!< [17..17] MR17IF clear bit                                                 */
      __OM  uint32_t MR18IC     : 1;            /*!< [18..18] MR18IF clear bit                                                 */
      __OM  uint32_t MR19IC     : 1;            /*!< [19..19] MR19IF clear bit                                                 */
      __OM  uint32_t MR20IC     : 1;            /*!< [20..20] MR20IF clear bit                                                 */
      __OM  uint32_t MR21IC     : 1;            /*!< [21..21] MR21IF clear bit                                                 */
      __OM  uint32_t MR22IC     : 1;            /*!< [22..22] MR22IF clear bit                                                 */
      __OM  uint32_t MR23IC     : 1;            /*!< [23..23] MR23IF clear bit                                                 */
      __OM  uint32_t MR24IC     : 1;            /*!< [24..24] MR24IF clear bit                                                 */
            uint32_t            : 7;
    } IC_b;
  } ;
} SN_CT16B1_Type;                               /*!< Size = 172 (0xac)                                                         */



/* =========================================================================================================================== */
/* ================                                          SN_WDT                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Watchdog Timer (SN_WDT)
  */

typedef struct {                                /*!< (@ 0x40010000) SN_WDT Structure                                           */
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Offset:0x00 WDT Configuration Register                     */
    
    struct {
      __IOM uint32_t WDTEN      : 1;            /*!< [0..0] WDT enable                                                         */
      __IOM uint32_t WDTIE      : 1;            /*!< [1..1] WDT interrupt enable                                               */
      __IOM uint32_t WDTINT     : 1;            /*!< [2..2] WDT interrupt flag                                                 */
            uint32_t            : 13;
      __OM  uint32_t WDKEY      : 16;           /*!< [31..16] WDT register key                                                 */
    } CFG_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t TC;                          /*!< (@ 0x00000008) Offset:0x08 WDT Timer Constant Register                    */
    
    struct {
      __IOM uint32_t TC         : 8;            /*!< [7..0] Watchdog timer constant reload value                               */
            uint32_t            : 8;
      __OM  uint32_t WDKEY      : 16;           /*!< [31..16] WDT register key                                                 */
    } TC_b;
  } ;
  
  union {
    __OM  uint32_t FEED;                        /*!< (@ 0x0000000C) Offset:0x0C WDT Feed Register                              */
    
    struct {
      __OM  uint32_t FV         : 16;           /*!< [15..0] Watchdog feed value                                               */
      __OM  uint32_t WDKEY      : 16;           /*!< [31..16] WDT register key                                                 */
    } FEED_b;
  } ;
} SN_WDT_Type;                                  /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_SPI0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief SPI0 (SN_SPI0)
  */

typedef struct {                                /*!< (@ 0x4001C000) SN_SPI0 Structure                                          */
  
  union {
    __IOM uint32_t CTRL0;                       /*!< (@ 0x00000000) Offset:0x00 SPI0 Control Register 0                        */
    
    struct {
      __IOM uint32_t SPIEN      : 1;            /*!< [0..0] SPI enable                                                         */
      __IOM uint32_t LOOPBACK   : 1;            /*!< [1..1] Loopback mode enable                                               */
      __IOM uint32_t SDODIS     : 1;            /*!< [2..2] Slave data out disable                                             */
      __IOM uint32_t MS         : 1;            /*!< [3..3] Master/Slave selection                                             */
      __IOM uint32_t FORMAT     : 1;            /*!< [4..4] Interface format                                                   */
            uint32_t            : 1;
      __OM  uint32_t FRESET     : 2;            /*!< [7..6] SPI FSM and FIFO Reset                                             */
      __IOM uint32_t DL         : 4;            /*!< [11..8] Data length = DL[3:0]+1                                           */
      __IOM uint32_t TXFIFOTH   : 3;            /*!< [14..12] TX FIFO Threshold level                                          */
      __IOM uint32_t RXFIFOTH   : 3;            /*!< [17..15] RX FIFO Threshold level                                          */
      __IOM uint32_t SELDIS     : 1;            /*!< [18..18] Auto-SEL disable bit                                             */
            uint32_t            : 13;
    } CTRL0_b;
  } ;
  
  union {
    __IOM uint32_t CTRL1;                       /*!< (@ 0x00000004) Offset:0x04 SPI0 Control Register 1                        */
    
    struct {
      __IOM uint32_t MLSB       : 1;            /*!< [0..0] MSB/LSB seletion                                                   */
      __IOM uint32_t CPOL       : 1;            /*!< [1..1] Clock priority selection                                           */
      __IOM uint32_t CPHA       : 1;            /*!< [2..2] Clock phase of edge sampling                                       */
            uint32_t            : 29;
    } CTRL1_b;
  } ;
  
  union {
    __IOM uint32_t CLKDIV;                      /*!< (@ 0x00000008) Offset:0x08 SPI0 Clock Divider Register                    */
    
    struct {
      __IOM uint32_t DIV        : 8;            /*!< [7..0] SPI0 SCK                                                           */
            uint32_t            : 24;
    } CLKDIV_b;
  } ;
  
  union {
    __IM  uint32_t STAT;                        /*!< (@ 0x0000000C) Offset:0x0C SPI0 Status Register                           */
    
    struct {
      __IM  uint32_t TX_EMPTY   : 1;            /*!< [0..0] TX FIFO empty flag                                                 */
      __IM  uint32_t TX_FULL    : 1;            /*!< [1..1] TX FIFO full flag                                                  */
      __IM  uint32_t RX_EMPTY   : 1;            /*!< [2..2] RX FIFO empty flag                                                 */
      __IM  uint32_t RX_FULL    : 1;            /*!< [3..3] RX FIFO full flag                                                  */
      __IM  uint32_t BUSY       : 1;            /*!< [4..4] Busy flag                                                          */
      __IM  uint32_t TXFIFOTHF  : 1;            /*!< [5..5] TX FIFO threshold flag                                             */
      __IM  uint32_t RXFIFOTHF  : 1;            /*!< [6..6] RX FIFO threshold flag                                             */
            uint32_t            : 25;
    } STAT_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000010) Offset:0x10 SPI0 Interrupt Enable Register                 */
    
    struct {
      __IOM uint32_t RXOVFIE    : 1;            /*!< [0..0] RX FIFO overflow interrupt enable                                  */
      __IOM uint32_t RXTOIE     : 1;            /*!< [1..1] RX time-out interrupt enable                                       */
      __IOM uint32_t RXFIFOTHIE : 1;            /*!< [2..2] RX FIFO threshold interrupt enable                                 */
      __IOM uint32_t TXFIFOTHIE : 1;            /*!< [3..3] TX FIFO threshold interrupt enable                                 */
            uint32_t            : 28;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x00000014) Offset:0x14 SPI0 Raw Interrupt Status Register             */
    
    struct {
      __IM  uint32_t RXOVFIF    : 1;            /*!< [0..0] RX FIFO overflow interrupt flag                                    */
      __IM  uint32_t RXTOIF     : 1;            /*!< [1..1] RX time-out interrupt flag                                         */
      __IM  uint32_t RXFIFOTHIF : 1;            /*!< [2..2] RX FIFO threshold interrupt flag                                   */
      __IM  uint32_t TXFIFOTHIF : 1;            /*!< [3..3] TX FIFO threshold interrupt flag                                   */
            uint32_t            : 28;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000018) Offset:0x18 SPI0 Interrupt Clear Register                  */
    
    struct {
      __OM  uint32_t RXOVFIC    : 1;            /*!< [0..0] RX FIFO overflow flag clear                                        */
      __OM  uint32_t RXTOIC     : 1;            /*!< [1..1] RX time-out interrupt flag clear                                   */
      __OM  uint32_t RXFIFOTHIC : 1;            /*!< [2..2] RX Interrupt flag Clear                                            */
      __OM  uint32_t TXFIFOTHIC : 1;            /*!< [3..3] TX Interrupt flag Clear                                            */
            uint32_t            : 28;
    } IC_b;
  } ;
  
  union {
    __IOM uint32_t DATA;                        /*!< (@ 0x0000001C) Offset:0x1C SPI0 Data Register                             */
    
    struct {
      __IOM uint32_t Data       : 16;           /*!< [15..0] Data                                                              */
            uint32_t            : 16;
    } DATA_b;
  } ;
  
  union {
    __IOM uint32_t DFDLY;                       /*!< (@ 0x00000020) Offset:0x20 SPI0 Data Fetch Register                       */
    
    struct {
      __IOM uint32_t DFETCH_EN  : 1;            /*!< [0..0] SPI0 data fetch control bit                                        */
            uint32_t            : 31;
    } DFDLY_b;
  } ;
} SN_SPI0_Type;                                 /*!< Size = 36 (0x24)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_I2C0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C0 (SN_I2C0)
  */

typedef struct {                                /*!< (@ 0x40018000) SN_I2C0 Structure                                          */
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Offset:0x00 I2Cn Control Register                          */
    
    struct {
            uint32_t            : 1;
      __IOM uint32_t NACK       : 1;            /*!< [1..1] NACK assert flag                                                   */
      __IOM uint32_t ACK        : 1;            /*!< [2..2] ACK assert flag                                                    */
            uint32_t            : 1;
      __IOM uint32_t STO        : 1;            /*!< [4..4] STOP assert flag                                                   */
      __IOM uint32_t STA        : 1;            /*!< [5..5] START assert flag                                                  */
            uint32_t            : 1;
      __IOM uint32_t I2CMODE    : 1;            /*!< [7..7] I2C mode                                                           */
      __IOM uint32_t I2CEN      : 1;            /*!< [8..8] I2Cn interface enable                                              */
            uint32_t            : 23;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) Offset:0x04 I2Cn Status Register                           */
    
    struct {
      __IM  uint32_t RX_DN      : 1;            /*!< [0..0] RX done status                                                     */
      __IM  uint32_t ACK_STAT   : 1;            /*!< [1..1] ACK done status                                                    */
      __IM  uint32_t NACK_STAT  : 1;            /*!< [2..2] NACK done status                                                   */
      __IM  uint32_t STOP_DN    : 1;            /*!< [3..3] STOP done status                                                   */
      __IM  uint32_t START_DN   : 1;            /*!< [4..4] START done status                                                  */
      __IM  uint32_t MST        : 1;            /*!< [5..5] I2C master/slave status                                            */
      __IM  uint32_t SLV_RX_HIT : 1;            /*!< [6..6] Slave RX address hit flag                                          */
      __IM  uint32_t SLV_TX_HIT : 1;            /*!< [7..7] Slave TX address hit flag                                          */
      __IM  uint32_t LOST_ARB   : 1;            /*!< [8..8] Lost arbitration status                                            */
      __IM  uint32_t TIMEOUT    : 1;            /*!< [9..9] Time-out status                                                    */
            uint32_t            : 5;
      __IOM uint32_t I2CIF      : 1;            /*!< [15..15] I2C interrupt flag                                               */
            uint32_t            : 16;
    } STAT_b;
  } ;
  
  union {
    __IOM uint32_t TXDATA;                      /*!< (@ 0x00000008) Offset:0x08 I2Cn TX Data Register                          */
    
    struct {
      __IOM uint32_t Data       : 8;            /*!< [7..0] TX Data                                                            */
            uint32_t            : 24;
    } TXDATA_b;
  } ;
  
  union {
    __IM  uint32_t RXDATA;                      /*!< (@ 0x0000000C) Offset:0x0C I2Cn RX Data Register                          */
    
    struct {
      __IM  uint32_t Data       : 8;            /*!< [7..0] RX Data received when RX_DN=1                                      */
            uint32_t            : 24;
    } RXDATA_b;
  } ;
  
  union {
    __IOM uint32_t SLVADDR0;                    /*!< (@ 0x00000010) Offset:0x10 I2Cn Slave Address 0 Register                  */
    
    struct {
      __IOM uint32_t ADDR       : 10;           /*!< [9..0] I2Cn slave address 0                                               */
            uint32_t            : 20;
      __IOM uint32_t GCEN       : 1;            /*!< [30..30] General call address enable                                      */
      __IOM uint32_t ADD_MODE   : 1;            /*!< [31..31] Slave address mode                                               */
    } SLVADDR0_b;
  } ;
  
  union {
    __IOM uint32_t SLVADDR1;                    /*!< (@ 0x00000014) Offset:0x14 I2Cn Slave Address 1 Register                  */
    
    struct {
      __IOM uint32_t ADDR       : 10;           /*!< [9..0] I2Cn slave address 1                                               */
            uint32_t            : 22;
    } SLVADDR1_b;
  } ;
  
  union {
    __IOM uint32_t SLVADDR2;                    /*!< (@ 0x00000018) Offset:0x18 I2Cn Slave Address 2 Register                  */
    
    struct {
      __IOM uint32_t ADDR       : 10;           /*!< [9..0] I2Cn slave address 2                                               */
            uint32_t            : 22;
    } SLVADDR2_b;
  } ;
  
  union {
    __IOM uint32_t SLVADDR3;                    /*!< (@ 0x0000001C) Offset:0x1C I2Cn Slave Address 3 Register                  */
    
    struct {
      __IOM uint32_t ADDR       : 10;           /*!< [9..0] I2Cn slave address 3                                               */
            uint32_t            : 22;
    } SLVADDR3_b;
  } ;
  
  union {
    __IOM uint32_t SCLHT;                       /*!< (@ 0x00000020) Offset:0x20 I2Cn SCL High Time Register                    */
    
    struct {
      __IOM uint32_t SCLH       : 8;            /*!< [7..0] SCLn High period time=(SCLHT+1)*I2Cn_PCLK cycle                    */
            uint32_t            : 24;
    } SCLHT_b;
  } ;
  
  union {
    __IOM uint32_t SCLLT;                       /*!< (@ 0x00000024) Offset:0x24 I2Cn SCL Low Time Register                     */
    
    struct {
      __IOM uint32_t SCLL       : 8;            /*!< [7..0] SCLn Low period time=(SCLLT+1)*I2Cn_PCLK cycle                     */
            uint32_t            : 24;
    } SCLLT_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t TOCTRL;                      /*!< (@ 0x0000002C) Offset:0x2C I2Cn Timeout Control Register                  */
    
    struct {
      __IOM uint32_t TO         : 16;           /*!< [15..0] Timeout period time = TO*I2Cn_PCLK cycle                          */
            uint32_t            : 16;
    } TOCTRL_b;
  } ;
} SN_I2C0_Type;                                 /*!< Size = 48 (0x30)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_UART0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief UART0 (SN_UART0)
  */

typedef struct {                                /*!< (@ 0x40016000) SN_UART0 Structure                                         */
  
  union {
    union {
      __IM  uint32_t RB;                        /*!< (@ 0x00000000) Offset:0x00 UARTn Receiver Buffer Register                 */
      
      struct {
        __IM  uint32_t RB       : 8;            /*!< [7..0] The received byte in UART RX FIFO                                  */
              uint32_t          : 24;
      } RB_b;
    } ;
    
    union {
      __OM  uint32_t TH;                        /*!< (@ 0x00000000) Offset:0x00 UARTn Transmit Holding Register                */
      
      struct {
        __OM  uint32_t TH       : 8;            /*!< [7..0] The byte to be transmitted in UART TX FIFO when transmitter
                                                     is available                                                              */
              uint32_t          : 24;
      } TH_b;
    } ;
    
    union {
      __IOM uint32_t DLL;                       /*!< (@ 0x00000000) Offset:0x00 UARTn Divisor Latch LSB Register               */
      
      struct {
        __IOM uint32_t DLL      : 8;            /*!< [7..0] DLL and DLM register determines the baud rate of UARTn             */
              uint32_t          : 24;
      } DLL_b;
    } ;
  };
  
  union {
    union {
      __IOM uint32_t DLM;                       /*!< (@ 0x00000004) Offset:0x04 UARTn Divisor Latch MSB Register               */
      
      struct {
        __IOM uint32_t DLM      : 8;            /*!< [7..0] DLL and DLM register determines the baud rate of USARTn            */
              uint32_t          : 24;
      } DLM_b;
    } ;
    
    union {
      __IOM uint32_t IE;                        /*!< (@ 0x00000004) Offset:0x04 UARTn Interrupt Enable Register                */
      
      struct {
        __IOM uint32_t RDAIE    : 1;            /*!< [0..0] RDA interrupt enable                                               */
        __IOM uint32_t THREIE   : 1;            /*!< [1..1] THRE interrupt enable                                              */
        __IOM uint32_t RLSIE    : 1;            /*!< [2..2] RLS interrupt enable                                               */
              uint32_t          : 1;
        __IOM uint32_t TEMTIE   : 1;            /*!< [4..4] TEMT interrupt enable                                              */
              uint32_t          : 3;
        __IOM uint32_t ABEOIE   : 1;            /*!< [8..8] ABE0 interrupt enable                                              */
        __IOM uint32_t ABTOIE   : 1;            /*!< [9..9] ABT0 interrupt enable                                              */
              uint32_t          : 22;
      } IE_b;
    } ;
  };
  
  union {
    union {
      __IM  uint32_t II;                        /*!< (@ 0x00000008) Offset:0x08 UARTn Interrupt Identification Register        */
      
      struct {
        __IM  uint32_t INTSTATUS : 1;           /*!< [0..0] Interrupt status                                                   */
        __IM  uint32_t INTID    : 3;            /*!< [3..1] Interrupt ID of RX FIFO                                            */
              uint32_t          : 2;
        __IM  uint32_t FIFOEN   : 2;            /*!< [7..6] Equal to FIFOEN bits in USARTn_FIFOCTRL register                   */
        __IM  uint32_t ABEOIF   : 1;            /*!< [8..8] ABEO interrupt flag                                                */
        __IM  uint32_t ABTOIF   : 1;            /*!< [9..9] ABTO interrupt flag                                                */
              uint32_t          : 22;
      } II_b;
    } ;
    
    union {
      __OM  uint32_t FIFOCTRL;                  /*!< (@ 0x00000008) Offset:0x08 UARTn FIFO Control Register                    */
      
      struct {
        __OM  uint32_t FIFOEN   : 1;            /*!< [0..0] FIFO enable                                                        */
              uint32_t          : 5;
        __OM  uint32_t RXTL     : 2;            /*!< [7..6] RX trigger level                                                   */
              uint32_t          : 24;
      } FIFOCTRL_b;
    } ;
  };
  
  union {
    __IOM uint32_t LC;                          /*!< (@ 0x0000000C) Offset:0x0C UARTn Line Control Register                    */
    
    struct {
      __IOM uint32_t WLS        : 2;            /*!< [1..0] Word length selection                                              */
      __IOM uint32_t SBS        : 1;            /*!< [2..2] Stop bit selection                                                 */
      __IOM uint32_t PE         : 1;            /*!< [3..3] Parity enable                                                      */
      __IOM uint32_t PS         : 2;            /*!< [5..4] Parity selection                                                   */
      __IOM uint32_t BC         : 1;            /*!< [6..6] Break control                                                      */
      __IOM uint32_t DLAB       : 1;            /*!< [7..7] Divisor Latch access                                               */
            uint32_t            : 24;
    } LC_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IM  uint32_t LS;                          /*!< (@ 0x00000014) Offset:0x14 UARTn Line Status Register                     */
    
    struct {
      __IM  uint32_t RDR        : 1;            /*!< [0..0] Receiver data ready flag                                           */
      __IM  uint32_t OE         : 1;            /*!< [1..1] Overrun error flag                                                 */
      __IM  uint32_t PE         : 1;            /*!< [2..2] Parity error flag                                                  */
      __IM  uint32_t FE         : 1;            /*!< [3..3] Framing error flag                                                 */
      __IM  uint32_t BI         : 1;            /*!< [4..4] Break interrupt flag                                               */
      __IM  uint32_t THRE       : 1;            /*!< [5..5] THR empty flag                                                     */
      __IM  uint32_t TEMT       : 1;            /*!< [6..6] Transmitter empty flag                                             */
      __IM  uint32_t RXFE       : 1;            /*!< [7..7] Receiver FIFO error flag                                           */
            uint32_t            : 24;
    } LS_b;
  } ;
  __IM  uint32_t  RESERVED1;
  
  union {
    __IOM uint32_t SP;                          /*!< (@ 0x0000001C) Offset:0x1C UARTn Scratch Pad Register                     */
    
    struct {
      __IOM uint32_t PAD        : 8;            /*!< [7..0] Pad informaton                                                     */
            uint32_t            : 24;
    } SP_b;
  } ;
  
  union {
    __IOM uint32_t ABCTRL;                      /*!< (@ 0x00000020) Offset:0x20 UARTn Auto-baud Control Register               */
    
    struct {
      __IOM uint32_t START      : 1;            /*!< [0..0] Auto-baud run bit                                                  */
      __IOM uint32_t MODE       : 1;            /*!< [1..1] Auto-baud mode selection                                           */
      __IOM uint32_t AUTORESTART : 1;           /*!< [2..2] Restart mode selection                                             */
            uint32_t            : 5;
      __OM  uint32_t ABEOIFC    : 1;            /*!< [8..8] Clear ABEOIF flag                                                  */
      __OM  uint32_t ABTOIFC    : 1;            /*!< [9..9] Clear ABTOIF flag                                                  */
            uint32_t            : 22;
    } ABCTRL_b;
  } ;
  __IM  uint32_t  RESERVED2;
  
  union {
    __IOM uint32_t FD;                          /*!< (@ 0x00000028) Offset:0x28 UARTn Fractional Divider Register              */
    
    struct {
      __IOM uint32_t DIVADDVAL  : 4;            /*!< [3..0] Baud rate generation prescaler divisor value                       */
      __IOM uint32_t MULVAL     : 4;            /*!< [7..4] Baud rate generation prescaler multiplier value                    */
      __IOM uint32_t OVER8      : 1;            /*!< [8..8] Oversampling value                                                 */
            uint32_t            : 23;
    } FD_b;
  } ;
  __IM  uint32_t  RESERVED3;
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000030) Offset:0x30 UARTn Control Register                         */
    
    struct {
      __IOM uint32_t UARTEN     : 1;            /*!< [0..0] USART enable                                                       */
      __IOM uint32_t MODE       : 3;            /*!< [3..1] UART mode                                                          */
            uint32_t            : 2;
      __IOM uint32_t RXEN       : 1;            /*!< [6..6] RX enable                                                          */
      __IOM uint32_t TXEN       : 1;            /*!< [7..7] TX enable                                                          */
            uint32_t            : 24;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t HDEN;                        /*!< (@ 0x00000034) Offset:0x34 UARTn Control Register                         */
    
    struct {
      __IOM uint32_t HDEN       : 1;            /*!< [0..0] Half-duplex mode enable                                            */
            uint32_t            : 31;
    } HDEN_b;
  } ;
} SN_UART0_Type;                                /*!< Size = 56 (0x38)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_UART1                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief UART1 (SN_UART1)
  */

typedef struct {                                /*!< (@ 0x40014000) SN_UART1 Structure                                         */
  
  union {
    union {
      __IM  uint32_t RB;                        /*!< (@ 0x00000000) Offset:0x00 UARTn Receiver Buffer Register                 */
      
      struct {
        __IM  uint32_t RB       : 8;            /*!< [7..0] The received byte in UART RX FIFO                                  */
              uint32_t          : 24;
      } RB_b;
    } ;
    
    union {
      __OM  uint32_t TH;                        /*!< (@ 0x00000000) Offset:0x00 UARTn Transmit Holding Register                */
      
      struct {
        __OM  uint32_t TH       : 8;            /*!< [7..0] The byte to be transmitted in UART TX FIFO when transmitter
                                                     is available                                                              */
              uint32_t          : 24;
      } TH_b;
    } ;
    
    union {
      __IOM uint32_t DLL;                       /*!< (@ 0x00000000) Offset:0x00 UARTn Divisor Latch LSB Register               */
      
      struct {
        __IOM uint32_t DLL      : 8;            /*!< [7..0] DLL and DLM register determines the baud rate of UARTn             */
              uint32_t          : 24;
      } DLL_b;
    } ;
  };
  
  union {
    union {
      __IOM uint32_t DLM;                       /*!< (@ 0x00000004) Offset:0x04 UARTn Divisor Latch MSB Register               */
      
      struct {
        __IOM uint32_t DLM      : 8;            /*!< [7..0] DLL and DLM register determines the baud rate of USARTn            */
              uint32_t          : 24;
      } DLM_b;
    } ;
    
    union {
      __IOM uint32_t IE;                        /*!< (@ 0x00000004) Offset:0x04 UARTn Interrupt Enable Register                */
      
      struct {
        __IOM uint32_t RDAIE    : 1;            /*!< [0..0] RDA interrupt enable                                               */
        __IOM uint32_t THREIE   : 1;            /*!< [1..1] THRE interrupt enable                                              */
        __IOM uint32_t RLSIE    : 1;            /*!< [2..2] RLS interrupt enable                                               */
              uint32_t          : 1;
        __IOM uint32_t TEMTIE   : 1;            /*!< [4..4] TEMT interrupt enable                                              */
              uint32_t          : 3;
        __IOM uint32_t ABEOIE   : 1;            /*!< [8..8] ABE0 interrupt enable                                              */
        __IOM uint32_t ABTOIE   : 1;            /*!< [9..9] ABT0 interrupt enable                                              */
              uint32_t          : 22;
      } IE_b;
    } ;
  };
  
  union {
    union {
      __IM  uint32_t II;                        /*!< (@ 0x00000008) Offset:0x08 UARTn Interrupt Identification Register        */
      
      struct {
        __IM  uint32_t INTSTATUS : 1;           /*!< [0..0] Interrupt status                                                   */
        __IM  uint32_t INTID    : 3;            /*!< [3..1] Interrupt ID of RX FIFO                                            */
              uint32_t          : 2;
        __IM  uint32_t FIFOEN   : 2;            /*!< [7..6] Equal to FIFOEN bits in USARTn_FIFOCTRL register                   */
        __IM  uint32_t ABEOIF   : 1;            /*!< [8..8] ABEO interrupt flag                                                */
        __IM  uint32_t ABTOIF   : 1;            /*!< [9..9] ABTO interrupt flag                                                */
              uint32_t          : 22;
      } II_b;
    } ;
    
    union {
      __OM  uint32_t FIFOCTRL;                  /*!< (@ 0x00000008) Offset:0x08 UARTn FIFO Control Register                    */
      
      struct {
        __OM  uint32_t FIFOEN   : 1;            /*!< [0..0] FIFO enable                                                        */
              uint32_t          : 5;
        __OM  uint32_t RXTL     : 2;            /*!< [7..6] RX trigger level                                                   */
              uint32_t          : 24;
      } FIFOCTRL_b;
    } ;
  };
  
  union {
    __IOM uint32_t LC;                          /*!< (@ 0x0000000C) Offset:0x0C UARTn Line Control Register                    */
    
    struct {
      __IOM uint32_t WLS        : 2;            /*!< [1..0] Word length selection                                              */
      __IOM uint32_t SBS        : 1;            /*!< [2..2] Stop bit selection                                                 */
      __IOM uint32_t PE         : 1;            /*!< [3..3] Parity enable                                                      */
      __IOM uint32_t PS         : 2;            /*!< [5..4] Parity selection                                                   */
      __IOM uint32_t BC         : 1;            /*!< [6..6] Break control                                                      */
      __IOM uint32_t DLAB       : 1;            /*!< [7..7] Divisor Latch access                                               */
            uint32_t            : 24;
    } LC_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IM  uint32_t LS;                          /*!< (@ 0x00000014) Offset:0x14 UARTn Line Status Register                     */
    
    struct {
      __IM  uint32_t RDR        : 1;            /*!< [0..0] Receiver data ready flag                                           */
      __IM  uint32_t OE         : 1;            /*!< [1..1] Overrun error flag                                                 */
      __IM  uint32_t PE         : 1;            /*!< [2..2] Parity error flag                                                  */
      __IM  uint32_t FE         : 1;            /*!< [3..3] Framing error flag                                                 */
      __IM  uint32_t BI         : 1;            /*!< [4..4] Break interrupt flag                                               */
      __IM  uint32_t THRE       : 1;            /*!< [5..5] THR empty flag                                                     */
      __IM  uint32_t TEMT       : 1;            /*!< [6..6] Transmitter empty flag                                             */
      __IM  uint32_t RXFE       : 1;            /*!< [7..7] Receiver FIFO error flag                                           */
            uint32_t            : 24;
    } LS_b;
  } ;
  __IM  uint32_t  RESERVED1;
  
  union {
    __IOM uint32_t SP;                          /*!< (@ 0x0000001C) Offset:0x1C UARTn Scratch Pad Register                     */
    
    struct {
      __IOM uint32_t PAD        : 8;            /*!< [7..0] Pad informaton                                                     */
            uint32_t            : 24;
    } SP_b;
  } ;
  
  union {
    __IOM uint32_t ABCTRL;                      /*!< (@ 0x00000020) Offset:0x20 UARTn Auto-baud Control Register               */
    
    struct {
      __IOM uint32_t START      : 1;            /*!< [0..0] Auto-baud run bit                                                  */
      __IOM uint32_t MODE       : 1;            /*!< [1..1] Auto-baud mode selection                                           */
      __IOM uint32_t AUTORESTART : 1;           /*!< [2..2] Restart mode selection                                             */
            uint32_t            : 5;
      __OM  uint32_t ABEOIFC    : 1;            /*!< [8..8] Clear ABEOIF flag                                                  */
      __OM  uint32_t ABTOIFC    : 1;            /*!< [9..9] Clear ABTOIF flag                                                  */
            uint32_t            : 22;
    } ABCTRL_b;
  } ;
  __IM  uint32_t  RESERVED2;
  
  union {
    __IOM uint32_t FD;                          /*!< (@ 0x00000028) Offset:0x28 UARTn Fractional Divider Register              */
    
    struct {
      __IOM uint32_t DIVADDVAL  : 4;            /*!< [3..0] Baud rate generation prescaler divisor value                       */
      __IOM uint32_t MULVAL     : 4;            /*!< [7..4] Baud rate generation prescaler multiplier value                    */
      __IOM uint32_t OVER8      : 1;            /*!< [8..8] Oversampling value                                                 */
            uint32_t            : 23;
    } FD_b;
  } ;
  __IM  uint32_t  RESERVED3;
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000030) Offset:0x30 UARTn Control Register                         */
    
    struct {
      __IOM uint32_t UARTEN     : 1;            /*!< [0..0] USART enable                                                       */
      __IOM uint32_t MODE       : 3;            /*!< [3..1] UART mode                                                          */
            uint32_t            : 2;
      __IOM uint32_t RXEN       : 1;            /*!< [6..6] RX enable                                                          */
      __IOM uint32_t TXEN       : 1;            /*!< [7..7] TX enable                                                          */
            uint32_t            : 24;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t HDEN;                        /*!< (@ 0x00000034) Offset:0x34 UARTn Control Register                         */
    
    struct {
      __IOM uint32_t HDEN       : 1;            /*!< [0..0] Half-duplex mode enable                                            */
            uint32_t            : 31;
    } HDEN_b;
  } ;
} SN_UART1_Type;                                /*!< Size = 56 (0x38)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_UART2                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief UART2 (SN_UART2)
  */

typedef struct {                                /*!< (@ 0x40012000) SN_UART2 Structure                                         */
  
  union {
    union {
      __IM  uint32_t RB;                        /*!< (@ 0x00000000) Offset:0x00 UARTn Receiver Buffer Register                 */
      
      struct {
        __IM  uint32_t RB       : 8;            /*!< [7..0] The received byte in UART RX FIFO                                  */
              uint32_t          : 24;
      } RB_b;
    } ;
    
    union {
      __OM  uint32_t TH;                        /*!< (@ 0x00000000) Offset:0x00 UARTn Transmit Holding Register                */
      
      struct {
        __OM  uint32_t TH       : 8;            /*!< [7..0] The byte to be transmitted in UART TX FIFO when transmitter
                                                     is available                                                              */
              uint32_t          : 24;
      } TH_b;
    } ;
    
    union {
      __IOM uint32_t DLL;                       /*!< (@ 0x00000000) Offset:0x00 UARTn Divisor Latch LSB Register               */
      
      struct {
        __IOM uint32_t DLL      : 8;            /*!< [7..0] DLL and DLM register determines the baud rate of UARTn             */
              uint32_t          : 24;
      } DLL_b;
    } ;
  };
  
  union {
    union {
      __IOM uint32_t DLM;                       /*!< (@ 0x00000004) Offset:0x04 UARTn Divisor Latch MSB Register               */
      
      struct {
        __IOM uint32_t DLM      : 8;            /*!< [7..0] DLL and DLM register determines the baud rate of USARTn            */
              uint32_t          : 24;
      } DLM_b;
    } ;
    
    union {
      __IOM uint32_t IE;                        /*!< (@ 0x00000004) Offset:0x04 UARTn Interrupt Enable Register                */
      
      struct {
        __IOM uint32_t RDAIE    : 1;            /*!< [0..0] RDA interrupt enable                                               */
        __IOM uint32_t THREIE   : 1;            /*!< [1..1] THRE interrupt enable                                              */
        __IOM uint32_t RLSIE    : 1;            /*!< [2..2] RLS interrupt enable                                               */
              uint32_t          : 1;
        __IOM uint32_t TEMTIE   : 1;            /*!< [4..4] TEMT interrupt enable                                              */
              uint32_t          : 3;
        __IOM uint32_t ABEOIE   : 1;            /*!< [8..8] ABE0 interrupt enable                                              */
        __IOM uint32_t ABTOIE   : 1;            /*!< [9..9] ABT0 interrupt enable                                              */
              uint32_t          : 22;
      } IE_b;
    } ;
  };
  
  union {
    union {
      __IM  uint32_t II;                        /*!< (@ 0x00000008) Offset:0x08 UARTn Interrupt Identification Register        */
      
      struct {
        __IM  uint32_t INTSTATUS : 1;           /*!< [0..0] Interrupt status                                                   */
        __IM  uint32_t INTID    : 3;            /*!< [3..1] Interrupt ID of RX FIFO                                            */
              uint32_t          : 2;
        __IM  uint32_t FIFOEN   : 2;            /*!< [7..6] Equal to FIFOEN bits in USARTn_FIFOCTRL register                   */
        __IM  uint32_t ABEOIF   : 1;            /*!< [8..8] ABEO interrupt flag                                                */
        __IM  uint32_t ABTOIF   : 1;            /*!< [9..9] ABTO interrupt flag                                                */
              uint32_t          : 22;
      } II_b;
    } ;
    
    union {
      __OM  uint32_t FIFOCTRL;                  /*!< (@ 0x00000008) Offset:0x08 UARTn FIFO Control Register                    */
      
      struct {
        __OM  uint32_t FIFOEN   : 1;            /*!< [0..0] FIFO enable                                                        */
              uint32_t          : 5;
        __OM  uint32_t RXTL     : 2;            /*!< [7..6] RX trigger level                                                   */
              uint32_t          : 24;
      } FIFOCTRL_b;
    } ;
  };
  
  union {
    __IOM uint32_t LC;                          /*!< (@ 0x0000000C) Offset:0x0C UARTn Line Control Register                    */
    
    struct {
      __IOM uint32_t WLS        : 2;            /*!< [1..0] Word length selection                                              */
      __IOM uint32_t SBS        : 1;            /*!< [2..2] Stop bit selection                                                 */
      __IOM uint32_t PE         : 1;            /*!< [3..3] Parity enable                                                      */
      __IOM uint32_t PS         : 2;            /*!< [5..4] Parity selection                                                   */
      __IOM uint32_t BC         : 1;            /*!< [6..6] Break control                                                      */
      __IOM uint32_t DLAB       : 1;            /*!< [7..7] Divisor Latch access                                               */
            uint32_t            : 24;
    } LC_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IM  uint32_t LS;                          /*!< (@ 0x00000014) Offset:0x14 UARTn Line Status Register                     */
    
    struct {
      __IM  uint32_t RDR        : 1;            /*!< [0..0] Receiver data ready flag                                           */
      __IM  uint32_t OE         : 1;            /*!< [1..1] Overrun error flag                                                 */
      __IM  uint32_t PE         : 1;            /*!< [2..2] Parity error flag                                                  */
      __IM  uint32_t FE         : 1;            /*!< [3..3] Framing error flag                                                 */
      __IM  uint32_t BI         : 1;            /*!< [4..4] Break interrupt flag                                               */
      __IM  uint32_t THRE       : 1;            /*!< [5..5] THR empty flag                                                     */
      __IM  uint32_t TEMT       : 1;            /*!< [6..6] Transmitter empty flag                                             */
      __IM  uint32_t RXFE       : 1;            /*!< [7..7] Receiver FIFO error flag                                           */
            uint32_t            : 24;
    } LS_b;
  } ;
  __IM  uint32_t  RESERVED1;
  
  union {
    __IOM uint32_t SP;                          /*!< (@ 0x0000001C) Offset:0x1C UARTn Scratch Pad Register                     */
    
    struct {
      __IOM uint32_t PAD        : 8;            /*!< [7..0] Pad informaton                                                     */
            uint32_t            : 24;
    } SP_b;
  } ;
  
  union {
    __IOM uint32_t ABCTRL;                      /*!< (@ 0x00000020) Offset:0x20 UARTn Auto-baud Control Register               */
    
    struct {
      __IOM uint32_t START      : 1;            /*!< [0..0] Auto-baud run bit                                                  */
      __IOM uint32_t MODE       : 1;            /*!< [1..1] Auto-baud mode selection                                           */
      __IOM uint32_t AUTORESTART : 1;           /*!< [2..2] Restart mode selection                                             */
            uint32_t            : 5;
      __OM  uint32_t ABEOIFC    : 1;            /*!< [8..8] Clear ABEOIF flag                                                  */
      __OM  uint32_t ABTOIFC    : 1;            /*!< [9..9] Clear ABTOIF flag                                                  */
            uint32_t            : 22;
    } ABCTRL_b;
  } ;
  __IM  uint32_t  RESERVED2;
  
  union {
    __IOM uint32_t FD;                          /*!< (@ 0x00000028) Offset:0x28 UARTn Fractional Divider Register              */
    
    struct {
      __IOM uint32_t DIVADDVAL  : 4;            /*!< [3..0] Baud rate generation prescaler divisor value                       */
      __IOM uint32_t MULVAL     : 4;            /*!< [7..4] Baud rate generation prescaler multiplier value                    */
      __IOM uint32_t OVER8      : 1;            /*!< [8..8] Oversampling value                                                 */
            uint32_t            : 23;
    } FD_b;
  } ;
  __IM  uint32_t  RESERVED3;
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000030) Offset:0x30 UARTn Control Register                         */
    
    struct {
      __IOM uint32_t UARTEN     : 1;            /*!< [0..0] USART enable                                                       */
      __IOM uint32_t MODE       : 3;            /*!< [3..1] UART mode                                                          */
            uint32_t            : 2;
      __IOM uint32_t RXEN       : 1;            /*!< [6..6] RX enable                                                          */
      __IOM uint32_t TXEN       : 1;            /*!< [7..7] TX enable                                                          */
            uint32_t            : 24;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t HDEN;                        /*!< (@ 0x00000034) Offset:0x34 UARTn Control Register                         */
    
    struct {
      __IOM uint32_t HDEN       : 1;            /*!< [0..0] Half-duplex mode enable                                            */
            uint32_t            : 31;
    } HDEN_b;
  } ;
} SN_UART2_Type;                                /*!< Size = 56 (0x38)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_USB                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Universal Serial Bus Full Speed Device Interface (USB) (SN_USB)
  */

typedef struct {                                /*!< (@ 0x4005C000) SN_USB Structure                                           */
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000000) Offset:0x00 USB Interrupt Enable Register                  */
    
    struct {
      __IOM uint32_t EP1_NAK_EN : 1;            /*!< [0..0] EP1 NAK Interrupt Enable                                           */
      __IOM uint32_t EP2_NAK_EN : 1;            /*!< [1..1] EP2 NAK Interrupt Enable                                           */
      __IOM uint32_t EP3_NAK_EN : 1;            /*!< [2..2] EP3 NAK Interrupt Enable                                           */
      __IOM uint32_t EP4_NAK_EN : 1;            /*!< [3..3] EP4 NAK Interrupt Enable                                           */
      __IOM uint32_t EPN_ACK_EN : 1;            /*!< [4..4] EPN ACK Interrupt Enable                                           */
            uint32_t            : 23;
      __IOM uint32_t BUSWK_IE   : 1;            /*!< [28..28] USB Bus Wake Up Interrupt Enable                                 */
      __IOM uint32_t USB_IE     : 1;            /*!< [29..29] USB Event Interrupt Enable                                       */
      __IOM uint32_t USB_SOF_IE : 1;            /*!< [30..30] USB SOF Interrupt Enable                                         */
      __IOM uint32_t BUS_IE     : 1;            /*!< [31..31] Bus Event Interrupt Enable                                       */
    } INTEN_b;
  } ;
  
  union {
    __IM  uint32_t INSTS;                       /*!< (@ 0x00000004) Offset:0x04 USB Interrupt Event Status Register            */
    
    struct {
      __IM  uint32_t EP1_NAK    : 1;            /*!< [0..0] Endpoint 1 NAK transaction flag                                    */
      __IM  uint32_t EP2_NAK    : 1;            /*!< [1..1] Endpoint 2 NAK transaction flag                                    */
      __IM  uint32_t EP3_NAK    : 1;            /*!< [2..2] Endpoint 3 NAK transaction flag                                    */
      __IM  uint32_t EP4_NAK    : 1;            /*!< [3..3] Endpoint 4 NAK transaction flag                                    */
            uint32_t            : 4;
      __IM  uint32_t EP1_ACK    : 1;            /*!< [8..8] Endpoint 1 ACK transaction flag                                    */
      __IM  uint32_t EP2_ACK    : 1;            /*!< [9..9] Endpoint 2 ACK transaction flag                                    */
      __IM  uint32_t EP3_ACK    : 1;            /*!< [10..10] Endpoint 3 ACK transaction flag                                  */
      __IM  uint32_t EP4_ACK    : 1;            /*!< [11..11] Endpoint 4 ACK transaction flag                                  */
            uint32_t            : 5;
      __IM  uint32_t ERR_TIMEOUT : 1;           /*!< [17..17] Timeout Status                                                   */
      __IM  uint32_t ERR_SETUP  : 1;            /*!< [18..18] Wrong Setup data received                                        */
      __IM  uint32_t EP0_OUT_STALL : 1;         /*!< [19..19] EP0 OUT STALL transaction                                        */
      __IM  uint32_t EP0_IN_STALL : 1;          /*!< [20..20] EP0 IN STALL Transaction is completed                            */
      __IM  uint32_t EP0_OUT    : 1;            /*!< [21..21] EP0 OUT ACK Transaction Flag                                     */
      __IM  uint32_t EP0_IN     : 1;            /*!< [22..22] EP0 IN ACK Transaction Flag                                      */
      __IM  uint32_t EP0_SETUP  : 1;            /*!< [23..23] EP0 Setup Transaction Flag                                       */
      __IM  uint32_t EP0_PRESETUP : 1;          /*!< [24..24] EP0 Setup Token Packet Flag                                      */
      __IM  uint32_t BUS_WAKEUP : 1;            /*!< [25..25] Bus Wakeup Flag                                                  */
      __IM  uint32_t USB_SOF    : 1;            /*!< [26..26] USB SOF packet received flag                                     */
            uint32_t            : 2;
      __IM  uint32_t BUS_RESUME : 1;            /*!< [29..29] USB Bus Resume signal flag                                       */
      __IM  uint32_t BUS_SUSPEND : 1;           /*!< [30..30] USB Bus Suspend signal flag                                      */
      __IM  uint32_t BUS_RESET  : 1;            /*!< [31..31] USB Bus Reset signal flag                                        */
    } INSTS_b;
  } ;
  
  union {
    __OM  uint32_t INSTSC;                      /*!< (@ 0x00000008) Offset:0x08 USB Interrupt Event Status Clear
                                                                    Register                                                   */
    
    struct {
      __OM  uint32_t EP1_NAKC   : 1;            /*!< [0..0] EP1 NAK clear bit                                                  */
      __OM  uint32_t EP2_NAKC   : 1;            /*!< [1..1] EP2 NAK clear bit                                                  */
      __OM  uint32_t EP3_NAKC   : 1;            /*!< [2..2] EP3 NAK clear bit                                                  */
      __OM  uint32_t EP4_NAKC   : 1;            /*!< [3..3] EP4 NAK clear bit                                                  */
            uint32_t            : 4;
      __OM  uint32_t EP1_ACKC   : 1;            /*!< [8..8] EP1 ACK clear bit                                                  */
      __OM  uint32_t EP2_ACKC   : 1;            /*!< [9..9] EP2 ACK clear bit                                                  */
      __OM  uint32_t EP3_ACKC   : 1;            /*!< [10..10] EP3 ACK clear bit                                                */
      __OM  uint32_t EP4_ACKC   : 1;            /*!< [11..11] EP4 ACK clear bit                                                */
            uint32_t            : 5;
      __OM  uint32_t ERR_TIMEOUTC : 1;          /*!< [17..17] Timeout Error clear bit                                          */
      __OM  uint32_t ERR_SETUPC : 1;            /*!< [18..18] Error Setup clear bit                                            */
      __OM  uint32_t EP0_OUT_STALLC : 1;        /*!< [19..19] EP0 OUT STALL clear bit                                          */
      __OM  uint32_t EP0_IN_STALLC : 1;         /*!< [20..20] EP0 IN STALL clear bit                                           */
      __OM  uint32_t EP0_OUTC   : 1;            /*!< [21..21] EP0 OUT clear bit                                                */
      __OM  uint32_t EP0_INC    : 1;            /*!< [22..22] EP0 IN clear bit                                                 */
      __OM  uint32_t EP0_SETUPC : 1;            /*!< [23..23] EP0 SETUP clear bit                                              */
      __OM  uint32_t EP0_PRESETUPC : 1;         /*!< [24..24] EP0 PRESETUP clear bit                                           */
      __OM  uint32_t BUS_WAKEUPC : 1;           /*!< [25..25] Bus Wakeup clear bit                                             */
      __OM  uint32_t USB_SOFC   : 1;            /*!< [26..26] USB SOF clear bit                                                */
            uint32_t            : 2;
      __OM  uint32_t BUS_RESUMEC : 1;           /*!< [29..29] USB Bus Resume clear bit                                         */
            uint32_t            : 1;
      __OM  uint32_t BUS_RESETC : 1;            /*!< [31..31] USB Bus Reset clear bit                                          */
    } INSTSC_b;
  } ;
  
  union {
    __IOM uint32_t ADDR;                        /*!< (@ 0x0000000C) Offset:0x0C USB Device Address Register                    */
    
    struct {
      __IOM uint32_t UADDR      : 7;            /*!< [6..0] USB device's address                                               */
            uint32_t            : 25;
    } ADDR_b;
  } ;
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000010) Offset:0x10 USB Configuration Register                     */
    
    struct {
      __IOM uint32_t EP1_DIR    : 1;            /*!< [0..0] Endpoint 1 IN/OUT direction setting                                */
      __IOM uint32_t EP2_DIR    : 1;            /*!< [1..1] Endpoint 2 IN/OUT direction setting                                */
      __IOM uint32_t EP3_DIR    : 1;            /*!< [2..2] Endpoint 3 IN/OUT direction setting                                */
      __IOM uint32_t EP4_DIR    : 1;            /*!< [3..3] Endpoint 4 IN/OUT direction setting                                */
            uint32_t            : 22;
      __IOM uint32_t DIS_PDEN   : 1;            /*!< [26..26] Enable internal D+ and D- 175k pull-down resistor                */
      __IOM uint32_t ESD_EN     : 1;            /*!< [27..27] Enable USB anti-ESD protection                                   */
      __IOM uint32_t SIE_EN     : 1;            /*!< [28..28] USB Serial Interface Engine Enable                               */
      __IOM uint32_t DPPU_EN    : 1;            /*!< [29..29] Enable internal D+ 1.5k pull-up resistor                         */
      __IOM uint32_t PHY_EN     : 1;            /*!< [30..30] PHY Transceiver Function Enable                                  */
      __IOM uint32_t VREG33_EN  : 1;            /*!< [31..31] Enable the internal VREG33 ouput                                 */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t SGCTL;                       /*!< (@ 0x00000014) Offset:0x14 USB Signal Control Register                    */
    
    struct {
      __IOM uint32_t BUS_DN     : 1;            /*!< [0..0] USB D- state                                                       */
      __IOM uint32_t BUS_DP     : 1;            /*!< [1..1] USB DP state                                                       */
      __IOM uint32_t BUS_DRVEN  : 1;            /*!< [2..2] Enable to drive USB bus                                            */
            uint32_t            : 29;
    } SGCTL_b;
  } ;
  
  union {
    __IOM uint32_t EP0CTL;                      /*!< (@ 0x00000018) Offset:0x18 USB Endpoint 0 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 7;            /*!< [6..0] Endpoint byte count                                                */
            uint32_t            : 20;
      __IOM uint32_t OUT_STALL_EN : 1;          /*!< [27..27] Enable EP0 OUT STALL handshake                                   */
      __IOM uint32_t IN_STALL_EN : 1;           /*!< [28..28] Enable EP0 IN STALL handshake                                    */
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Enable Endpoint 0 Function                                       */
    } EP0CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP1CTL;                      /*!< (@ 0x0000001C) Offset:0x1C USB Endpoint 1 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 7;            /*!< [6..0] Endpoint byte count                                                */
            uint32_t            : 22;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 1 Function enable bit                                   */
    } EP1CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP2CTL;                      /*!< (@ 0x00000020) Offset:0x20 USB Endpoint 2 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 7;            /*!< [6..0] Endpoint byte count                                                */
            uint32_t            : 22;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 2 Function enable bit                                   */
    } EP2CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP3CTL;                      /*!< (@ 0x00000024) Offset:0x24 USB Endpoint 3 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 7;            /*!< [6..0] Endpoint byte count                                                */
            uint32_t            : 22;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 3 Function enable bit                                   */
    } EP3CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP4CTL;                      /*!< (@ 0x00000028) Offset:0x28 USB Endpoint 4 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 7;            /*!< [6..0] Endpoint byte count                                                */
            uint32_t            : 22;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 4 Function enable bit                                   */
    } EP4CTL_b;
  } ;
  __IM  uint32_t  RESERVED[4];
  
  union {
    __IOM uint32_t EPTOGGLE;                    /*!< (@ 0x0000003C) Offset:0x3C USB Endpoint Data Toggle Register              */
    
    struct {
      __IOM uint32_t ENDP1_DATA01 : 1;          /*!< [0..0] Endpoint 1 data toggle bit                                         */
      __IOM uint32_t ENDP2_DATA01 : 1;          /*!< [1..1] Endpoint 2 data toggle bit                                         */
      __IOM uint32_t ENDP3_DATA01 : 1;          /*!< [2..2] Endpoint 3 data toggle bit                                         */
      __IOM uint32_t ENDP4_DATA01 : 1;          /*!< [3..3] Endpoint 4 data toggle bit                                         */
            uint32_t            : 28;
    } EPTOGGLE_b;
  } ;
  __IM  uint32_t  RESERVED1[2];
  
  union {
    __IOM uint32_t EP1BUFOS;                    /*!< (@ 0x00000048) Offset:0x48 USB Endpoint 1 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 6;            /*!< [7..2] The offset address for endpoint data buffer                        */
            uint32_t            : 24;
    } EP1BUFOS_b;
  } ;
  
  union {
    __IOM uint32_t EP2BUFOS;                    /*!< (@ 0x0000004C) Offset:0x4C USB Endpoint 2 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 6;            /*!< [7..2] The offset address for endpoint data buffer                        */
            uint32_t            : 24;
    } EP2BUFOS_b;
  } ;
  
  union {
    __IOM uint32_t EP3BUFOS;                    /*!< (@ 0x00000050) Offset:0x50 USB Endpoint 3 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 6;            /*!< [7..2] The offset address for endpoint data buffer                        */
            uint32_t            : 24;
    } EP3BUFOS_b;
  } ;
  
  union {
    __IOM uint32_t EP4BUFOS;                    /*!< (@ 0x00000054) Offset:0x54 USB Endpoint 4 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 6;            /*!< [7..2] The offset address for endpoint data buffer                        */
            uint32_t            : 24;
    } EP4BUFOS_b;
  } ;
  __IM  uint32_t  RESERVED2[2];
  
  union {
    __IM  uint32_t FRMNO;                       /*!< (@ 0x00000060) Offset:0x60 USB Frame Number Register                      */
    
    struct {
      __IM  uint32_t FRAME_NO   : 11;           /*!< [10..0] The 11-bit frame number of the SOF packet                         */
            uint32_t            : 21;
    } FRMNO_b;
  } ;
  
  union {
    __IOM uint32_t PHYPRM;                      /*!< (@ 0x00000064) Offset:0x64 USB PHY Parameter Register                     */
    
    struct {
      __IOM uint32_t PHY_PARAM  : 6;            /*!< [5..0] USB PHY parameter                                                  */
            uint32_t            : 26;
    } PHYPRM_b;
  } ;
  __IM  uint32_t  RESERVED3;
  
  union {
    __IOM uint32_t PHYPRM2;                     /*!< (@ 0x0000006C) Offset:0x6C USB PHY Parameter 2 Register                   */
    
    struct {
      __IOM uint32_t PHY_PS     : 15;           /*!< [14..0] USB PHY parameter 2                                               */
            uint32_t            : 17;
    } PHYPRM2_b;
  } ;
  
  union {
    __IOM uint32_t PS2CTL;                      /*!< (@ 0x00000070) Offset:0x70 PS/2 Control Register                          */
    
    struct {
      __IOM uint32_t SCKM       : 1;            /*!< [0..0] PS/2 SCK mode control bit                                          */
      __IOM uint32_t SDAM       : 1;            /*!< [1..1] PS/2 SDA mode control bit                                          */
      __IOM uint32_t SCK        : 1;            /*!< [2..2] PS/2 SCK data buffer                                               */
      __IOM uint32_t SDA        : 1;            /*!< [3..3] PS/2 SDA data buffer                                               */
            uint32_t            : 27;
      __IOM uint32_t PS2ENB     : 1;            /*!< [31..31] PS/2 internal 5kohm pull-up resistor control bit                 */
    } PS2CTL_b;
  } ;
  __IM  uint32_t  RESERVED4;
  
  union {
    __IOM uint32_t RWADDR;                      /*!< (@ 0x00000078) Offset:0x78 USB Read/Write Address Register                */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t RWADDR     : 6;            /*!< [7..2] USB FIFO address to be read or written from/to USB FIFO            */
            uint32_t            : 24;
    } RWADDR_b;
  } ;
  
  union {
    __IOM uint32_t RWDATA;                      /*!< (@ 0x0000007C) Offset:0x7C USB Read/Write Data Register                   */
    
    struct {
      __IOM uint32_t RWDATA     : 32;           /*!< [31..0] Data to be read or written from/to USB FIFO                       */
    } RWDATA_b;
  } ;
  
  union {
    __IOM uint32_t RWSTATUS;                    /*!< (@ 0x00000080) Offset:0x80 USB Read/Write Status Register                 */
    
    struct {
      __IOM uint32_t W_STATUS   : 1;            /*!< [0..0] Write status of USB FIFO                                           */
      __IOM uint32_t R_STATUS   : 1;            /*!< [1..1] WRead status of USB FIFO                                           */
            uint32_t            : 30;
    } RWSTATUS_b;
  } ;
  
  union {
    __IOM uint32_t RWADDR2;                     /*!< (@ 0x00000084) Offset:0x84 USB Read/Write Address Register 2              */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t RWADDR     : 6;            /*!< [7..2] USB FIFO address to be read or written from/to USB FIFO            */
            uint32_t            : 24;
    } RWADDR2_b;
  } ;
  
  union {
    __IOM uint32_t RWDATA2;                     /*!< (@ 0x00000088) Offset:0x88 USB Read/Write Data Register 2                 */
    
    struct {
      __IOM uint32_t RWDATA     : 32;           /*!< [31..0] Data to be read or written from/to USB FIFO                       */
    } RWDATA2_b;
  } ;
  
  union {
    __IOM uint32_t RWSTATUS2;                   /*!< (@ 0x0000008C) Offset:0x8C USB Read/Write Status Register 2               */
    
    struct {
      __IOM uint32_t W_STATUS   : 1;            /*!< [0..0] Write status of USB FIFO                                           */
      __IOM uint32_t R_STATUS   : 1;            /*!< [1..1] WRead status of USB FIFO                                           */
            uint32_t            : 30;
    } RWSTATUS2_b;
  } ;
} SN_USB_Type;                                  /*!< Size = 144 (0x90)                                                         */



/* =========================================================================================================================== */
/* ================                                         SN_FLASH                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief FLASH Memory Control Registers (SN_FLASH)
  */

typedef struct {                                /*!< (@ 0x40062000) SN_FLASH Structure                                         */
  
  union {
    __IOM uint32_t LPCTRL;                      /*!< (@ 0x00000000) Offset:0x00 Flash Low Power Control Register               */
    
    struct {
      __IOM uint32_t LPMODE     : 4;            /*!< [3..0] Flash Low Power mode selection bit                                 */
            uint32_t            : 12;
      __OM  uint32_t FMCKEY     : 16;           /*!< [31..16] FMC verify key                                                   */
    } LPCTRL_b;
  } ;
  
  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x00000004) Offset:0x04 Flash Status Register                          */
    
    struct {
      __IM  uint32_t BUSY       : 1;            /*!< [0..0] Busy flag                                                          */
            uint32_t            : 1;
      __IOM uint32_t ERR        : 1;            /*!< [2..2] Erase/Error flag                                                   */
            uint32_t            : 29;
    } STATUS_b;
  } ;
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000008) Offset:0x08 Flash Control Register                         */
    
    struct {
      __IOM uint32_t PG         : 1;            /*!< [0..0] Flash program mode chosen bit                                      */
      __IOM uint32_t PER        : 1;            /*!< [1..1] Page erase mode chosen bit                                         */
      __IOM uint32_t MER        : 1;            /*!< [2..2] Mass erase mode chosen bit                                         */
            uint32_t            : 3;
      __IOM uint32_t START      : 1;            /*!< [6..6] Start erase/program operation                                      */
      __IOM uint32_t CHK        : 1;            /*!< [7..7] Checksum calculation chosen                                        */
            uint32_t            : 24;
    } CTRL_b;
  } ;
  __IOM uint32_t  DATA;                         /*!< (@ 0x0000000C) Offset:0x0C Flash Data Register                            */
  __IOM uint32_t  ADDR;                         /*!< (@ 0x00000010) Offset:0x10 Flash Address Register                         */
  
  union {
    __IM  uint32_t CHKSUM;                      /*!< (@ 0x00000014) Offset:0x14 Flash Checksum Register                        */
    
    struct {
      __IM  uint32_t UserROM    : 16;           /*!< [15..0] Checksum of User ROM                                              */
      __IM  uint32_t BootROM    : 16;           /*!< [31..16] Checksum of Boot ROM                                             */
    } CHKSUM_b;
  } ;
} SN_FLASH_Type;                                /*!< Size = 24 (0x18)                                                          */



/* =========================================================================================================================== */
/* ================                                           SN_UC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief UC Registers (SN_UC)
  */

typedef struct {                                /*!< (@ 0x1FFF2228) SN_UC Structure                                            */
  __IM  uint32_t  L4BYTE;                       /*!< (@ 0x00000000) Offset:0x00 UC Low 4 Byte Register                         */
  __IM  uint32_t  H4BYTE;                       /*!< (@ 0x00000004) Offset:0x04 UC High 4 Byte Register                        */
} SN_UC_Type;                                   /*!< Size = 8 (0x8)                                                            */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define SN_SYS0_BASE                0x40060000UL
#define SN_SYS1_BASE                0x4005E000UL
#define SN_PMU_BASE                 0x40032000UL
#define SN_PFPA_BASE                0x40042000UL
#define SN_GPIO0_BASE               0x40044000UL
#define SN_GPIO1_BASE               0x40046000UL
#define SN_GPIO2_BASE               0x40048000UL
#define SN_GPIO3_BASE               0x4004A000UL
#define SN_ADC_BASE                 0x40026000UL
#define SN_CT16B0_BASE              0x40000000UL
#define SN_CT16B1_BASE              0x40002000UL
#define SN_WDT_BASE                 0x40010000UL
#define SN_SPI0_BASE                0x4001C000UL
#define SN_I2C0_BASE                0x40018000UL
#define SN_UART0_BASE               0x40016000UL
#define SN_UART1_BASE               0x40014000UL
#define SN_UART2_BASE               0x40012000UL
#define SN_USB_BASE                 0x4005C000UL
#define SN_FLASH_BASE               0x40062000UL
#define SN_UC_BASE                  0x1FFF2228UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define SN_SYS0                     ((SN_SYS0_Type*)           SN_SYS0_BASE)
#define SN_SYS1                     ((SN_SYS1_Type*)           SN_SYS1_BASE)
#define SN_PMU                      ((SN_PMU_Type*)            SN_PMU_BASE)
#define SN_PFPA                     ((SN_PFPA_Type*)           SN_PFPA_BASE)
#define SN_GPIO0                    ((SN_GPIO0_Type*)          SN_GPIO0_BASE)
#define SN_GPIO1                    ((SN_GPIO0_Type*)          SN_GPIO1_BASE)
#define SN_GPIO2                    ((SN_GPIO0_Type*)          SN_GPIO2_BASE)
#define SN_GPIO3                    ((SN_GPIO3_Type*)          SN_GPIO3_BASE)
#define SN_ADC                      ((SN_ADC_Type*)            SN_ADC_BASE)
#define SN_CT16B0                   ((SN_CT16B0_Type*)         SN_CT16B0_BASE)
#define SN_CT16B1                   ((SN_CT16B1_Type*)         SN_CT16B1_BASE)
#define SN_WDT                      ((SN_WDT_Type*)            SN_WDT_BASE)
#define SN_SPI0                     ((SN_SPI0_Type*)           SN_SPI0_BASE)
#define SN_I2C0                     ((SN_I2C0_Type*)           SN_I2C0_BASE)
#define SN_UART0                    ((SN_UART0_Type*)          SN_UART0_BASE)
#define SN_UART1                    ((SN_UART1_Type*)          SN_UART1_BASE)
#define SN_UART2                    ((SN_UART2_Type*)          SN_UART2_BASE)
#define SN_USB                      ((SN_USB_Type*)            SN_USB_BASE)
#define SN_FLASH                    ((SN_FLASH_Type*)          SN_FLASH_BASE)
#define SN_UC                       ((SN_UC_Type*)             SN_UC_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


#ifdef __cplusplus
}
#endif

#endif /* SN32F240B_H */


/** @} */ /* End of group SN32F240B */

/** @} */ /* End of group SONiX Technology Co., Ltd. */
