<?php
/*-----------------------------------------------------------------------------
cheetan is licensed under the MIT license.
copyright (c) 2006 cheetan all right reserved.
http://php.cheetan.net/
-----------------------------------------------------------------------------*/
class CDBPgsql extends CDBCommon
{
	function connect( $host, $user, $pswd, $db )
	{
		$connect	= pg_connect( "host=$host port=5432 dbname=$db user=$user password=$pswd" );
		return $connect;
	}
	
	
	function query( $query, $connect )
	{
		return pg_query( $connect, $query );
	}
	
	
	function find( $query, $connect )
	{
		$ret	= array();
		if( $res = $this->query( $query, $connect ) )
		{
			$rownum	= pg_num_rows( $res );
			for( $i = 0; $i < $numrow; $i++ )
			{
				$row	= pg_fetch_array( $res, $i, PGSQL_ASSOC );
				array_push( $ret, $row );
				$rownum++;
			}
			pg_free_result( $res );
		}
		
		return $ret;
	}
	
	
	function count( $query, $connect )
	{
		if( $res = $this->query( $query, $connect ) )
		{
			$count	= pg_num_rows( $res );
			pg_free_result( $res );
			return $count;
		}
		
		return 0;
	}
	
	
	function escape( $str )
	{
		if( function_exists( 'pg_escape_string' ) )
		{
			return pg_escape_string( $str );
		}
		
		return addslashes( $str );
	}
}
?>