<?php
/*-----------------------------------------------------------------------------
cheetan is licensed under the MIT license.
copyright (c) 2006 cheetan all right reserved.
http://www.cheetan.net/
-----------------------------------------------------------------------------*/
class CModel extends CObject
{
	var	$id				= "id";
	var	$name			= "";
	var $table			= "";
	var	$db;
	var	$controler;
	var $validatefunc	= array();
	var $validatemsg	= array();
	var $validateresult	= array();
	
	
	function SetController( &$controller )
	{
		$this->controller	= &$controller;
		$this->SetDatabase( $controller->GetDatabase() );
	}
	
	
	function SetDatabase( &$db )
	{
		$this->db	= $db;
	}
	
	
	function query( $query )
	{
		$this->db->query( $query, $this->name );
	}
	
	
	function findquery( $query, $condition = "", $order = "", $group = "" )
	{
		if( $condition )	$query .= " WHERE $condition";
		if( $group )		$query .= " GROUP BY $group";
		if( $order )		$query .= " ORDER BY $order";
		return $this->db->find( $query, $this->name );
	}


	function find( $condition = "", $order = "" )
	{
		$query	= "SELECT * FROM $this->table";
		return $this->findquery( $query, $condition, $order );
	}
	
	
	function findone( $condition = "", $order = "" )
	{
		$query	= "SELECT * FROM $this->table";
		if( $condition )	$query .= " WHERE $condition";
		if( $order )		$query .= " ORDER BY $order";
		$result	= $this->db->find( $query, $this->name );
		if( count( $result ) )	return $result[0];
		return FALSE;
	}
	
	
	function getcount( $condition = "", $order = "" )
	{
		$query	= "SELECT * FROM $this->table";
		if( $condition )	$query .= " WHERE $condition";
		if( $order )		$query .= " ORDER BY $order";
		return $this->db->count( $query, $this->name );
	}


	function insert( $datas )
	{
		$count	= count( $datas );
		$query	= "INSERT INTO $this->table(";
		$i		= 0;
		foreach( $datas as $key => $data )
		{
			$query .= "$key";
			if( $i < $count - 1 )
			{
				$query .= ",";
			}
			$i++;
		}
		$query	.= ") VALUES(";
		$i		= 0;
		foreach( $datas as $key => $data )
		{
			$query .= "'$data'";
			if( $i < $count - 1 )
			{
				$query .= ",";
			}
			$i++;
		}
		$query	.= ")";
		return $this->query( $query );
	}


	function updateby( $datas, $condition )
	{
		$count	= count( $datas );
		$query	= "UPDATE $this->table SET ";
		$i		= 0;
		foreach( $datas as $key => $data )
		{
			if( $key != $this->id )
			{
				$query .= "$key='$data'";
				if( $i < $count - 1 )
				{
					$query .= ",";
				}
			}
		}
		$query	= substr( $query, 0, strlen( $query ) - 1 );
		$query	.= " WHERE $condition";
		return $this->query( $query );
	}
	
	
	function update( $datas )
	{
		if( array_key_exists( $this->id, $datas ) )
		{
			$query	= "UPDATE $this->table SET ";
			foreach( $datas as $key => $data )
			{
				if( $key == $this->id )
				{
					$condition	= " WHERE id=$data";
				}
				else
				{
					$query		.= "$key='$data',";
				}
			}
			$query	= substr( $query, 0, strlen( $query ) - 1 );
			$query	.= $condition;
			return $this->query( $query );
		}
		
		return FALSE;
	}


	function del( $condition )
	{
		$query	= "DELETE FROM $this->table WHERE $condition";
		return $this->query( $query );
	}
	
	
	function validate( $datas )
	{
		$ret		= TRUE;
		$validater	= &$this->controller->validate;
		foreach( $datas as $key => $data )
		{
			if( array_key_exists( $key, $this->validatefunc ) )
			{
				$func	= $this->validatefunc[$key];
				if( method_exists( $validater, $func ) )
				{
					$this->validateresult[$key]	= $validater->$func( $data );
					if( !$this->validateresult[$key] )
					{
						$ret	= FALSE;
					}
				}
			}
		}
		
		return $ret;
	}
	
	
	function validatemsg( $datas )
	{
		$ret		= "";
		$validater	= &$this->controller->validate;
		foreach( $datas as $key => $data )
		{
			if( array_key_exists( $key, $this->validatefunc ) )
			{
				$func	= $this->validatefunc[$key];
				if( method_exists( $validater, $func ) )
				{
					$this->validateresult[$key]	= $validater->$func( $data );
					if( !$this->validateresult[$key] && array_key_exists( $key, $this->validatemsg ) )
					{
						$ret	.= $this->validatemsg[$key];
					}
				}
			}
		}
		
		return $ret;
	}
	
	
	function GetValidateError()
	{
		return $this->validateerror;
	}
	
	
	function to_datetime( $time = "" )
	{
		if( !$time )	$time = time();
		return date( "Y-m-d H:i:s", $time );
	}
}
?>
