/*-
 * chalib.h
 *
 * Copyright (c) 1996,1997 Nara Institute of Science and Technology
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Nara Institute of 
 *      Science and Technology.
 * 4. The name Nara Institute of Science and Technology may not be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *    
 *
 * THIS SOFTWARE IS PROVIDED BY Nara Institute of Science and Technology 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE Nara Institute
 * of Science and Technology BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: chalib.h,v 1.8.4.1 2000/12/18 20:08:31 masayu-a Exp $
 */
#ifndef __CHALIB_H__
#define __CHALIB_H__

#include "chadic.h"
#include "chasen.h"

#if defined _WIN32 && ! defined __CYGWIN__
#define	strcasecmp	stricmp
#define	strncasecmp	strnicmp
#endif /* _WIN32 */

#define CHA_PATH_NUM            1024
#define CHA_INPUT_SIZE      8192
#define UNDEF_HINSI_MAX     256
#define PAT_DIC_NUM 5 /* Ʊ˻Ȥ뼭οξ (ChaSen) */

/*
 * structures
 */

typedef struct _mrph2_t {
    char *midasi;
    char *yomi;
    char *info;
    char *base;
    char *pron;
    char *comp;
    short base_length;

    unsigned short hinsi;
    unsigned char ktype;
    unsigned char kform;
    char  is_undef;

    unsigned short weight;
    short  length;
    short  con_tbl;
} mrph2_t;

typedef struct _path_t {
    int   mrph_p;
    short state;
    short start;
    short end;
    short do_print;
    int   cost;
    int   *path;
} path_t;

typedef struct _anno_info {
    int  hinsi;
    char *str1, *str2;
    int  len1, len2;
    char *format;
} anno_info;

typedef struct _undef_info {
    int  cost, cost_step;
    int  con_tbl;
    int  hinsi;
} undef_info;

/*
 * global variables
 */
extern mrph2_t *Cha_mrph;
extern path_t *Cha_path;
extern int Cha_path_num;
extern int Cha_con_cost_weight, Cha_con_cost_undef;
extern int Cha_mrph_cost_weight, Cha_cost_width;
extern int Space_pos_hinsi;
extern anno_info Cha_anno_info[UNDEF_HINSI_MAX];
extern undef_info Cha_undef_info[UNDEF_HINSI_MAX];
extern int Cha_undef_info_num;
extern int Cha_lang_j, Cha_lang_e;
extern char *Cha_bos_string;
extern char *Cha_eos_string;
extern int Cha_output_compo;

/*
 * functions
 */

/* init.c */
void cha_read_rcfile_fp(FILE*);
void cha_init(void);

/* print.c */
char *cha_get_output(void);
void cha_set_fput(int);
void cha_set_output(FILE*);
void cha_set_sentence(char*, short*, char*);
void cha_printf_mrph(int, mrph2_t*, char*);
void cha_print_path(int, int, char*);
void cha_print_bos_eos(int);
void cha_print_hinsi_table(void);
void cha_print_ctype_table(void);
void cha_print_cform_table(void);

/* parse.c */
void cha_get_mrph_data(mrph2_t*, char*, char*);
int cha_parse_sentence(char*, int, int);

/* chalib.c */
void cha_version(FILE*);
void cha_set_opt_form(char*);
void cha_set_cost_width(int);
void cha_set_language(char*);
char *cha_fgets(char*, int, FILE*);
void cha_read_patdic(chasen_cell_t*);
void cha_read_sufdic(chasen_cell_t*);

/* cha_jfgets.c */
void cha_set_jfgets_delimiter();
char *cha_fget_line();
char *cha_jfgets();
int cha_jistoeuc();

#endif /* __CHALIB_H__ */
