extern int th_hash_dummy; /* avoid warning */
#if defined(USE_HASH) && defined(NO_MMAP)
#include <stdio.h>
#include "t-hash.h"

#define DOUBLE_HASH_SIZE 33331

/****************************************************
* th_hash_function --- ϥåؿ
* 
* ѥ᡼
*   key --- (ʸ)
*   hash_size --- ϥå׻λMOD͡
* 
* ֤
*   ϥå
****************************************************/
int th_hash_function(x, hash_size)
  long x;
  int hash_size;
{
  return((int)x % hash_size);
}


/****************************************************
* th_hash_initialize --- ϥåν
* 
* ѥ᡼
*   heads --- ϥåؤΥݥ
*   hash_size --- ϥå礭ϥå׻λMOD
****************************************************/
void th_hash_initialize(heads, hash_size)
  th_hash_node *heads;
  int hash_size;
{
  int i;

  for(i = 0;i < hash_size; i++){
    (heads + i)->key[0] = '\0';
  }
}


/****************************************************
* th_hash_in --- ϥåؤΥȥ꡼
* 
* ѥ᡼
*   hash_array --- ϥåؤΥݥ
*   hash_size --- ϥåΥ
*   key --- 
*   content --- 
****************************************************/
void th_hash_in(hash_array, hash_size, x, content, f)
  th_hash_node* hash_array;
  int hash_size;
  long x;
  char *content;
  FILE *f;
{
  char key[20];
  th_hash_node *ptr;
  int hash_v, i = 1, jmp;
  static int ctr;

  sprintf(key,"%x%x",x,(unsigned int)f);

  hash_v = x % hash_size;

  jmp = x % DOUBLE_HASH_SIZE + 1;

/*  printf("### %i <%s>\n",th_hash_function(x,hash_size),key);*/

  ptr = hash_array + hash_v;
  while((ptr->key)[0] != '\0'){
/*    printf("### liner searching.\n"); */
    hash_v = (hash_v + jmp) % hash_size;
    ptr = hash_array + hash_v;
    i++;
  }

  strcpy(ptr->key,key);
  
  ptr->content = (char *)malloc(strlen(content)+1);
  strcpy(ptr->content,content);

  ctr++;

/*  printf("### %i\n",ctr);*/

/*  if(ctr % 1000 == 0) {fprintf(stderr,":\n");fflush(stderr);}*/
}


/****************************************************
* th_hash_out --- ϥå夫μФ
* 
* ѥ᡼
*   hash_array --- ϥåؤΥݥ
*   hash_size --- ϥåΥ
*   key --- 
*
* ֤  ȥ꡼ƤȤ     ȡפؤʸݥ
*         ȥ꡼ƤʤȤ     NULL
****************************************************/
char* th_hash_out(hash_array ,hash_size, x, f)
  th_hash_node* hash_array;
  int hash_size;
  long x;
  FILE *f;
{
  char key[20];
  th_hash_node *ptr;
  int hash_v, i = 1, jmp;

  sprintf(key,"%x%x",x,(unsigned int)f);

  hash_v = x % hash_size;

  jmp = x % DOUBLE_HASH_SIZE + 1;

/*  printf("#@@ %i\n",jmp);*/

  ptr = hash_array + hash_v;

  while((ptr->key)[0] != '\0'){
    if(strcmp(key,ptr->key) == 0){
/*      printf("##key[%s] == [%s] OK!\n",key,ptr->key);*/
      return(ptr->content);
    }
/*    printf("##key[%s] <> [%s]\n",key,ptr->key);*/
    hash_v = (hash_v + jmp) % hash_size;
    ptr = hash_array + hash_v;
    i++;
  }

  return(NULL);

}

/****************************************************
* th_show_hash --- ǡν for DEBUG
*
* ѥ᡼
*   hash_array --- ϥåؤΥݥ
*   hash_size --- ϥåΥ
****************************************************/
void th_show_hash(heads, hash_size)
  th_hash_node* heads;
  int hash_size;
{
  int i,ctr = 0;
  th_hash_node *ptr;

  for(i = 0; i < hash_size; i++){ /* ϥåơ֥ƤˤĤƤν */
    if(((heads + i)->key)[0] != '\0') {printf("*");ctr++;}
    else printf(".");
    if(i % 50 == 0){printf("  %i\n",i);fflush(stdout);}
  }
  printf("\n### *.  %i : %i\n",i,ctr);
}



/**

: 

1.  th_hash_out_and_in() 롥
    Ф˼ԤȤ롥

2.  ʸߤ뤿ˤȤĤ򡤺ٸƤӽФƤޤäƤ롥

**/

#endif /* USE_HASH && !USE_MAAP */
