/*
 * init.c - initialization of ChaSen
 *
 * Copyright (C) 1996,1997 Nara Institute of Science and Technology
 *
 * Modified by A.Kitauchi <akira-k@is.aist-nara.ac.jp> Sep. 1996
 *
 */

#include "chalib.h"
#include "pat.h"

#define DEF_UNDEF       "̤"
#define DEF_U_CLASS     "̤ʻ"
#define DEF_CLASS_C     "ʻ쥳"
#define DEF_RENSETSU_W  "ϢܥȽŤ"
#define DEF_KEITAISO_W  "ǥȽŤ"
#define DEF_COST_HABA   ""
#define DEF_U_CON_COST  "̤Ϣܥ"
#define DEF_COMPOSITION "Ϣʻ"
/*#define DEF_DIC_FILE    "ե"*/
#define DEF_DIC_FILE    "PATDIC" /* changed by Tatuo 960920 */
#define DEF_FORMAT      "ϥեޥå"
#define DEF_DELIMITER   "ڤʸ"

/* .chasenrc default values */
#define CLASS_COST_DEFAULT	10
#define RENSETSU_WEIGHT_DEFAULT	10
#define KEITAISO_WEIGHT_DEFAULT	1
#define COST_WIDTH_DEFAULT	20
#define UNDEF_WORD_DEFAULT	10000

int Cha_server_mode;

int Con_cost_weight = RENSETSU_WEIGHT_DEFAULT * MRPH_DEFAULT_WEIGHT;
int Mrph_cost_weight = KEITAISO_WEIGHT_DEFAULT;
int Undef_cost = UNDEF_WORD_DEFAULT;  
int Undef_con_cost = 0;
int Undef_hinsi, Undef_con_tbl;
#ifndef VGRAM
int Undef_bunrui;
#endif

/***********************************************************************/
static void read_class_cost(cell)
    cell_t *cell;
{
    cell_t *cell1;
    int hinsi, cost;

#ifdef VGRAM
    char *s;

    for (; !nullp(cell); cell = cdr(cell)) {
	cell1 = car(cell);
	cost = atoi(s_atom(car(cdr(cell1))));
	s = s_atom(car(car(cell1)));
	if (!strcmp(s, DEF_UNDEF))
	  Undef_cost = cost;
	else if (!strcmp(s, "*")) {
	    for (hinsi = 1; Hinsi[hinsi].name; hinsi++)
	      if (Hinsi[hinsi].cost == 0)
		Hinsi[hinsi].cost = cost;
	} else {
	    int match = 0;
	    for (hinsi = 1; Hinsi[hinsi].name; hinsi++) {
		if (match_nhinsi(car(cell1), hinsi)) {
		    Hinsi[hinsi].cost = cost;
		    match = 1;
		}
	    }
	    if (!match) {
		cha_exit_file(-1, "invalid hinsi name `");
		s_print(stderr, cell1);
		fputs("'\n", stderr); 
		exit(1);
	    }
	}
    }

    /* default */
    for (hinsi = 1; Hinsi[hinsi].name; hinsi++) 
      if (Hinsi[hinsi].cost == 0)
	Hinsi[hinsi].cost = CLASS_COST_DEFAULT;

    /* ʸƬ ʸ */
    Hinsi[0].cost = 0;
#else
    int bunrui;

    for (; !nullp(cell); cell = cdr(cell)) {
	cell1 = car(cell);
	cost = atoi(s_atom(car(cdr(cell1))));
	if (!strcmp(s_atom(car(car(cell1))), DEF_UNDEF))
	  Undef_cost = cost;
	else {
	    get_hinsi_bunrui_id(car(cell1), &hinsi, &bunrui);
	    if (hinsi == 0) {
		for (hinsi = 1; Class[hinsi][0].id; hinsi++)
		  for (bunrui = 0; Class[hinsi][bunrui].id; bunrui++)
		    if (Class[hinsi][bunrui].cost == 0)
		      Class[hinsi][bunrui].cost = cost;
	    } else if (bunrui == 0) {
		for (bunrui = 0; Class[hinsi][bunrui].id; bunrui++)
		  Class[hinsi][bunrui].cost = cost;
	    } else {
		Class[hinsi][bunrui].cost = cost;
	    }
	}
    }

    /* default */
    for (hinsi = 1; Class[hinsi][0].id; hinsi++) 
      for (bunrui = 0; Class[hinsi][bunrui].id; bunrui++)
	if (Class[hinsi][bunrui].cost == 0)
	  Class[hinsi][bunrui].cost = CLASS_COST_DEFAULT;

    /* For ʸƬ ʸ added by S.Kurohashi */
    Class[0][0].cost = 0;
#endif
}

/***********************************************************************/
static void read_composition(cell)
    cell_t *cell;
{
#ifdef VGRAM
    int comp, pos;

    for (; !nullp(cell); cell = cdr(cell)) {
	comp = get_nhinsi_id(car(cell));
	for (pos = 1; Hinsi[pos].name; pos++)
	  if (match_nhinsi(car(cell), pos))
	    Hinsi[pos].comp = comp;
    }
#else
    int comp_hinsi, comp_bunrui, i;

    for (; !nullp(cell); cell = cdr(cell)) {
	get_hinsi_bunrui_id(car(cell), &comp_hinsi, &comp_bunrui);
	if (comp_bunrui)
	  Class[comp_hinsi][comp_bunrui].comp = 2;
	else {
	    for (i = 0; Class[comp_hinsi][i].id; i++)
	      Class[comp_hinsi][i].comp = 1;
	}
    }
#endif		
}

/***********************************************************************/
void eval_chasenrc_sexp(cell1)
    cell_t *cell1;
{
    char *cell1_str;
    cell_t *cell2;

    cell1_str = s_atom(car(cell1));
    cell2 = car(cdr(cell1));
    if (Cha_errno)
      return;

    /* ե */
    if (!strcmp(cell1_str, DEF_DIC_FILE))
      read_patdic(cdr(cell1));
    /* ̤ʻ */
    else if (!strcmp(cell1_str, DEF_U_CLASS)) {
#ifdef VGRAM
	Undef_hinsi = get_nhinsi_id(cell2);
#else
	get_hinsi_bunrui_id(cell2, &Undef_hinsi, &Undef_bunrui);
#endif
#if 0
	if (!Undef_hinsi)
	  exit(1);
#endif
    }
    /* ϢܥȽŤ */
    /* modified by S.Kurohashi 93/03/04 
       for balancing connect-weigh with morph-weight */
    else if (!strcmp(cell1_str, DEF_RENSETSU_W))
      Con_cost_weight = atoi(s_atom(cell2)) * MRPH_DEFAULT_WEIGHT;
    /* ǥȽŤ */
    else if (!strcmp(cell1_str, DEF_KEITAISO_W))
      Mrph_cost_weight = atoi(s_atom(cell2));
    /*  */
    /* modified by S.Kurohashi 93/03/04 
       for balancing connect-weigh with morph-weight */
    else if (!strcmp(cell1_str, DEF_COST_HABA))
      set_cost_width(atoi(s_atom(cell2)));
    /* ʻ쥳 */
    else if (!strcmp(cell1_str, DEF_CLASS_C))
      read_class_cost(cdr(cell1));
    /* ̤Ϣܥ */
    else if (!strcmp(cell1_str, DEF_U_CON_COST))
      Undef_con_cost = (int) atoi(s_atom(cell2));
    /* Ϣʻ */
    else if (!strcmp(cell1_str, DEF_COMPOSITION))
	  read_composition(cdr(cell1));
    /* ϥեޥå */
    else if (!strcmp(cell1_str, DEF_FORMAT))
      set_opt_form(s_atom(cell2));
    /* ڤʸ */
    else if (!strcmp(cell1_str, DEF_DELIMITER))
      set_jfgets_delimiter(s_atom(cell2));
}

/***********************************************************************
 * read_chasenrc_fp()
 ***********************************************************************/
void read_chasenrc_fp(fp)
    FILE *fp;
{
    cell_t *cell;

    while (!s_feof(fp)) {
	cell = s_read(fp);
	if (!Cha_errno)
	  eval_chasenrc_sexp(cell);
    }
}

/***********************************************************************/
static void read_chasenrc()
{
    FILE *fp;
    char *rcpath;

    rcpath = get_chasenrc_path();

    fp = cha_fopen(rcpath, "r", 1);
    read_chasenrc_fp(fp);
    fclose(fp);

    if (number_of_tree == 0)
      cha_exit(1, "%s: no patricia dictionary is specified",
	       get_chasenrc_path());
}

/*
 * chasen_init - ChaSen's initialization
 */
void chasen_init()
{
    /* ϴؿؤΥݥ */
    set_cha_fput(Cha_server_mode);

    /* ϴؿؤΥݥ */
    set_cha_getc_alone();

    /* cost width */
    set_cost_width(COST_WIDTH_DEFAULT);

    read_grammar_dir();
    read_grammar(NULL, 1, 1);

    read_chasenrc();

    read_katuyou(NULL, 1);
    read_table(NULL, 1);
    read_matrix(NULL);
#ifdef VGRAM
    Undef_con_tbl = check_table_for_undef(Undef_hinsi);
#else
    Undef_con_tbl = check_table_for_undef(Undef_hinsi, Undef_bunrui);
#endif
}

