/*
==============================================================================
        chadic.h
                1990/12/06/Thu  Yutaka MYOKI(Nagao Lab., KUEE)
                1990/01/09/Wed  Last Modified
                                          >>> 94/02 changed by T.Nakamura <<<
==============================================================================
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <limits.h>

#include <sys/types.h>
#include <sys/stat.h>
#ifdef _WIN32
#include <io.h>
#else
#include <sys/file.h>
#endif
#include <time.h>

#include <stdlib.h>
#include <fcntl.h>

/*
 * macros
 */

#ifndef FALSE
#define         FALSE           ((int)(0))
#endif
#ifndef TRUE
#define         TRUE            (!(FALSE))
#endif

#ifdef _WIN32
#define PATH_DELIMITER  '\\'
#else
#define PATH_DELIMITER  '/'
#endif

#ifndef SEEK_SET
#define SEEK_SET        0       /* use in "fseek()"         */
#define SEEK_CUR        1       /* use in "fseek()"         */
#define SEEK_END        2       /* use in "fseek()"         */
#endif

#define CHA_FILENAME_MAX 1024

#define MIDASI_MAX	129		/* maximum length of MIDASI */
#define YOMI_MAX	129		/* maximum length of YOMI   */

#define CLASSIFY_NO	128

#define TYPE_NO		256
#define FORM_NO		128

#define BUNTO           "ʸƬ"
#define BUNMATSU        "ʸ"

#define VCHA_CONNECTFILE "connect.cha"
#define VCHA_GRAMMARFILE "grammar.cha"
#define VCHA_KATUYOUFILE "cforms.cha"
#define VCHA_KANKEIFILE  "ctypes.cha"
#define VCHA_TABLEFILE   "table.cha"
#define VCHA_MATRIXFILE  "matrix.cha"
#define CHA_CONNECTFILE  "chasen.connect"
#define CHA_GRAMMARFILE  "chasen.grammar"
#define CHA_KATUYOUFILE  "chasen.cforms"
#define CHA_KANKEIFILE   "chasen.ctypes"
#define CHA_TABLEFILE    "chasen.table"
#define CHA_MATRIXFILE   "chasen.matrix"
#define JM_CONNECTFILE   "JUMAN.connect"
#define JM_GRAMMARFILE   "JUMAN.grammar"
#define JM_KATUYOUFILE   "JUMAN.katuyou"
#define JM_KANKEIFILE    "JUMAN.kankei"
#define JM_TABLEFILE     "JUMANTREE.table"
#define JM_MATRIXFILE    "JUMANTREE.matrix"
#ifdef VGRAM
#define CONNECTFILE	VCHA_CONNECTFILE
#define GRAMMARFILE	VCHA_GRAMMARFILE
#define KATUYOUFILE	VCHA_KATUYOUFILE
#define KANKEIFILE	VCHA_KANKEIFILE
#define TABLEFILE	VCHA_TABLEFILE
#define MATRIXFILE	VCHA_MATRIXFILE
#else
#define CONNECTFILE	CHA_CONNECTFILE
#define GRAMMARFILE	CHA_GRAMMARFILE
#define KATUYOUFILE	CHA_KATUYOUFILE
#define KANKEIFILE	CHA_KANKEIFILE
#define TABLEFILE	CHA_TABLEFILE
#define MATRIXFILE	CHA_MATRIXFILE
#endif

#define CONS		0
#define ATOM		1
#define NIL		((cell_t *)(NULL))

#define s_tag(cell)	(((cell_t *)(cell))->tag)
#define consp(x)	(!nullp(x) && (s_tag(x) == CONS))
#define atomp(x)	(!nullp(x) && (s_tag(x) == ATOM))
#define nullp(cell)	((cell) == NIL)
#define s_atom_val(cell) (((cell_t *)(cell))->value.atom)

/* added by T.Utsuro for weight of rensetu matrix */
#define DEFAULT_C_WEIGHT  10

/* added by S.Kurohashi for mrph weight default values */
#define MRPH_DEFAULT_WEIGHT	10

/* rensetu matrix */
typedef struct _connect_rule_t {
    short next;
    short cost;
} connect_rule_t;

/*
 * structures
 */

/* <car>  <cdr> ؤΥݥ󥿤ɽ줿 */
typedef struct _bin_t {
    void *car;			/* address of <car> */
    void *cdr;			/* address of <cdr> */
} bin_t;

/* <BIN> ޤ ʸ ɽ봰ʹ¤ */
typedef struct _cell {
    int tag;			/* tag of <cell> 0:cons 1:atom */
    union {
	bin_t	cons;
	char	*atom;
    } value;
} cell_t;

/* changed by T.Nakamura and S.Kurohashi 
	¤ mrph_t ٤Ƥξ 
	¤ MORPHEME Ϥʤʤä */
typedef struct _mrph {
    char	midasi[MIDASI_MAX];
    char	yomi[YOMI_MAX];
    cell_t	*imi;

#ifdef VGRAM
    unsigned short hinsi;
#else
    unsigned char hinsi;
    unsigned char bunrui;
#endif
    unsigned char ktype;
    unsigned char kform;

    short	con_tbl;
    short	length;
    unsigned char weight;

    char	is_undef;
} mrph_t;

#ifdef VGRAM
typedef struct _hinsi_t {
    short *path;
    short *daughter;
    char  *name;
    short comp; /* Ϣʻֹ */
    char  depth;
    char  kt;
    unsigned char cost;
} hinsi_t;
#else
/* ʻʬࡦʬ */
typedef struct _class {
    char *id;
    unsigned char comp; /* 1:ʬबϢʻ 2:ʬबϢʻ */
    char kt;
    unsigned char cost; /*ʻ쥳 by k.n*/
} class_t;
#endif

/* ѷ */
typedef struct _ktype {
    char	*name;
} ktype_t;

/* ѷ */
typedef struct _kform {
    char	*name;
    char	*gobi;
    char	*ygobi;
} kform_t;

/* Ϣɽ */
typedef struct _rensetu_pair {
    short  index;
    short  i_pos;
    short  j_pos;

#ifdef VGRAM
    unsigned short hinsi;
#else
    unsigned char hinsi;
    unsigned char bunrui;
#endif
    unsigned char type;
    unsigned char form;
    char   *goi;
} rensetu_pair_t;


/*
 * global variables
 */

#ifdef VGRAM
#define HINSI_MAX     4096
hinsi_t Hinsi[HINSI_MAX];
#else
extern class_t Class[CLASSIFY_NO][CLASSIFY_NO];
#endif
extern ktype_t Type[TYPE_NO];
extern kform_t Form[TYPE_NO][FORM_NO];
extern int LineNo, LineNoForError;

/* getopt.c */
extern int Cha_optind;
extern char *Cha_optarg;

extern int Cha_server_mode;
extern int Cha_errno;
extern FILE *Cha_stderr;

/*
 * functions
 */

/* iotool.c */
extern void set_progpath();
extern void set_chasenrc_path();
extern char *get_chasenrc_path();
extern char *get_grammar_dir();
extern void set_filepath();
extern FILE *cha_fopen();
extern FILE *cha_fopen2();
extern FILE *cha_fopen_grammar();
extern FILE *cha_fopen_grammar2();
extern int  cha_feof();
extern void *cha_malloc();
extern char *cha_strdup();

extern void cha_fexit();
extern void cha_exit();
extern void cha_exit_file();
extern void cha_perror();
extern void cha_exit_perror();
extern FILE *fopen_chasenrc();
extern void read_grammar_dir();


/* lisp.c */
extern void set_cha_getc_alone();
extern void set_cha_getc_server();
extern int s_feof();
extern cell_t *tmp_atom();
extern cell_t *cons();
extern cell_t *car();
extern cell_t *cdr();
extern char *s_atom();
extern int equal();
extern int s_length();
extern cell_t *s_read();
extern cell_t *assoc();
extern cell_t *s_print();

/* grammar.c */
extern int match_nhinsi();
extern void read_grammar();

/* katuyou.c */
extern void read_katuyou();

/* connect.c */
extern void read_table();
extern int check_table(); /* 970301 tatuo: void -> int for  */
extern int check_table_for_undef();
extern void read_matrix();
extern int check_automaton();
/* for EDR dic */
extern void check_edrtable();
extern void check_edrtable_str();

/* getid.c */
#ifdef VGRAM
extern int get_nhinsi_str_id();
extern int get_nhinsi_id();
#else
extern int get_hinsi_id();
extern int get_bunrui_id();
extern void get_hinsi_bunrui_id();
#endif
extern int get_type_id();
extern int get_form_id();

/* zentohan.c */
extern char *zentohan();
extern char *hantozen();
extern unsigned char *euc2sjis();
extern unsigned char *sjis2euc();
extern unsigned char *hankana2zenkana();

/* getopt.c */
extern int cha_getopt();
extern int cha_getopt_chasen();

