/*
==============================================================================
	trans.c
		1990/11/12/Mon Yutaka MYOKI(Nagao Lab., KUEE)
==============================================================================
*/

#include "chadic.h"

/*
------------------------------------------------------------------------------
	FUNCTION:
	<compare_end_str>: if <s1> = <...s2> or <s2> = <...s1> return 0
------------------------------------------------------------------------------
*/

static int strcmp_tail(s1, s2)
    char *s1, *s2;
{
    int diff_len;

    diff_len = strlen(s1) - strlen(s2);

    if (diff_len >= 0)
      return strcmp(s1 + diff_len, s2);
    else
      return strcmp(s2 - diff_len, s1);
}

/*
------------------------------------------------------------------------------
	PROCEDURE:
	<init_mrph>:
------------------------------------------------------------------------------
*/

static void init_mrph(mrph_p)
    mrph_t *mrph_p;
{
     mrph_p->hinsi    = 0;
#ifndef VGRAM
     mrph_p->bunrui   = 0;
#endif
     mrph_p->ktype = 0;
     mrph_p->kform = 0;
     mrph_p->weight   = 0;
     mrph_p->con_tbl  = 0;
}

/*
------------------------------------------------------------------------------
	PROCEDURE:
	<print_mrph>:
------------------------------------------------------------------------------
*/

static void print_mrph(fp, mrph_p)
    FILE *fp;
    mrph_t *mrph_p;
{
#ifdef SJIS
    sjis2euc(mrph_p->midasi);
    sjis2euc(mrph_p->yomi);
/*    sjis2euc(mrph_p->imi);*/
#endif

#ifdef VGRAM
    fprintf(fp, "%s\t%d %d %d %d %s %d ",
	    mrph_p->midasi, mrph_p->hinsi,
	    mrph_p->ktype, mrph_p->kform, mrph_p->weight,
	    mrph_p->yomi, mrph_p->con_tbl);
#else
    fprintf(fp, "%s\t%d %d %d %d %d %s %d ",
	    mrph_p->midasi, mrph_p->hinsi, mrph_p->bunrui,
	    mrph_p->ktype, mrph_p->kform, mrph_p->weight,
	    mrph_p->yomi, mrph_p->con_tbl);
#endif
    s_print(fp, mrph_p->imi);
    fputc('\n', fp);
}

static void print_mrph_loop(fp, mrph_p)
    FILE *fp;
    mrph_t *mrph_p;
{
    int i;

    for ( i=1; Form[mrph_p->ktype][i].name; i++ ) {
	if ( strlen(Form[mrph_p->ktype][i].gobi) ) {
#ifdef SJIS
	    sjis2euc(Form[mrph_p->ktype][i].gobi);
/*            s_print(fp, sjis2euc(mrph_p->imi));*/
#endif
#ifdef VGRAM
            fprintf(fp, "%s\t%d %d %d %d %s %d ",
                    Form[mrph_p->ktype][i].gobi, mrph_p->hinsi,
                    mrph_p->ktype, i, mrph_p->weight,
                    Form[mrph_p->ktype][i].ygobi, mrph_p->con_tbl + i - 1);
#else
            fprintf(fp, "%s\t%d %d %d %d %d %s %d ",
                    Form[mrph_p->ktype][i].gobi, mrph_p->hinsi, mrph_p->bunrui,
		    mrph_p->ktype, i, mrph_p->weight,
                    Form[mrph_p->ktype][i].ygobi, mrph_p->con_tbl + i - 1);
#endif
            s_print(fp, mrph_p->imi);
	    fputc('\n', fp);
        }
    }
}

/*
------------------------------------------------------------------------------
	PROCEDURE:
	<error_in_trans>: local cha_exit processing
------------------------------------------------------------------------------
*/

static void trans_exit(msg, cell)
    char *msg;
    cell_t *cell;
{
    cha_exit_file(-1, "`");
    s_print(stderr, cell);
    fprintf(stderr, "' %s\n", msg);
    exit(1);
}

/*
------------------------------------------------------------------------------
	FUNCTION:	** not used now ** 1992/9/10
	<midasi>: sub-routine of <trans>
------------------------------------------------------------------------------
*/

static char *midasi(x)
    cell_t *x;
{
    cell_t *y;
    char *s;

    if (nullp(y = assoc(tmp_atom("Ф"), x)))
      trans_exit("doesn't contain a list for midasi", x);

    s = hantozen(s_atom(car(cdr(y))));

    if (strlen(s) > MIDASI_MAX)
      cha_exit_file(1, "midashi `%s' is too long", s);

    return s;
}

/*
------------------------------------------------------------------------------
	FUNCTION:
	<midasi_list>: sub-routine of <trans>
------------------------------------------------------------------------------
*/

static cell_t *midasi_list(x)
    cell_t *x;
{
    cell_t *y;
    char *s;

    if (nullp(y = assoc(tmp_atom("Ф"), x)))
      trans_exit("doesn't contain a list for midasi", x);

    return cdr(y);
}

/*
------------------------------------------------------------------------------
	FUNCTION
	<yomi>: sub-routine of <trans>
------------------------------------------------------------------------------
*/

static char *yomi(x)
    cell_t *x;
{
    cell_t *y;
    char *s;

    if (nullp(y = assoc(tmp_atom("ɤ"), x)))
#ifdef KOCHA2
      return "";
#else
      trans_exit("doesn't contain a list for yomi", x);
#endif
    s = hantozen(s_atom(car(cdr(y))));

    if (strlen(s) > YOMI_MAX)
      cha_exit_file(1, "yomi `%s' is too long", s);

    return s;
}

/*
------------------------------------------------------------------------------
	FUNCTION:
	<ktype>: sun-routine of <trans>
------------------------------------------------------------------------------
*/

static int ktype(x)
    cell_t *x;
{
    cell_t *y;
    int i;

    if (nullp(y = assoc(tmp_atom("ѷ"), x)))
      trans_exit("doesn't contain a list for katsuyou", x);

    return get_type_id(s_atom(car(cdr(y))));
}

/* for EDRdic '94.Mar */
/*
------------------------------------------------------------------------------
        FUNCTION:
        <edrconnect>: sub-routine of <trans>
------------------------------------------------------------------------------
*/

static cell_t *edrconnect(x)
    cell_t *x;
{
    cell_t *y;

    y = assoc(tmp_atom("Ϣ°"), x);
    return car(cdr(y));
}

/*
------------------------------------------------------------------------------
	FUNCTION:
	<imi>: sub-routine of <trans>
------------------------------------------------------------------------------
*/

static cell_t *imi(x)
    cell_t *x;
{
    cell_t *y;

    y = assoc(tmp_atom("̣"), x);
    /* JUMAN2.0 Ǥ cdr(y) ֤褦ˤʤäƤ */
    return car(cdr(y));
}

/*
------------------------------------------------------------------------------
	PROCEDURE:
	<trim_yomi_gobi> <trim_midasi_gobi>: sub-routine of <trans>
------------------------------------------------------------------------------
*/

static void trim_yomi_gobi(mrph_p)
    mrph_t *mrph_p;
{
    char *str = "ܷ";
    int i;

    for (i = 1; strcmp(Form[mrph_p->ktype][i].name, str); i++);

    mrph_p->yomi[strlen(mrph_p->yomi) - 
		 strlen(Form[mrph_p->ktype][i].gobi)]='\0';
}

static void trim_midasi_gobi(mrph_p)
    mrph_t *mrph_p;
{
    char *str = "ܷ";
    int	i;
    
    for (i = 1; strcmp(Form[mrph_p->ktype][i].name, str); i++);
    
    if (!strcmp_tail(mrph_p->midasi, Form[mrph_p->ktype][i].gobi))
      mrph_p->midasi[strlen(mrph_p->midasi) - 
		    strlen(Form[mrph_p->ktype][i].gobi)]='\0';
    else
      cha_exit_file(1, "midashi `%s' conflicts katsuyou form", mrph_p->midasi);
}
/*
------------------------------------------------------------------------------
	PROCEDURE:
	<trans>: translate from <fp_in> to <fp_out>
------------------------------------------------------------------------------
*/

static void trans_main(block, mrph_p, fp_out)
    cell_t *block;
    mrph_t *mrph_p;
    FILE *fp_out;
{
    cell_t *loop, *midasi_cell;
    char   *midasi_cp = NULL;
#ifdef KOCHA2
    char   *midasi_last;
#endif
    float  float_weight;
    int    int_weight;
    cell_t *connect_cell; /* EDRdic '94.Mar */
    int    katuyou;

    strcpy(mrph_p->yomi, yomi(block)); /* ɤ */
    mrph_p->imi = imi(block);          /* ̣ */
#ifdef VGRAM
    katuyou = Hinsi[mrph_p->hinsi].kt;
#else
    katuyou = Class[mrph_p->hinsi][mrph_p->bunrui].kt;
#endif

    if (katuyou == 1) {
	mrph_p->ktype = ktype(block);    /* ѷ   */
	trim_yomi_gobi(mrph_p);
    } else
      mrph_p->ktype = 0;

    loop = midasi_list(block);         /* Ф */
    while (!nullp(midasi_cell = car(loop))) {

	/* (Ф ߡߡ) ξ */
	if (atomp(midasi_cell)) {
	    midasi_cp = s_atom_val(midasi_cell);
	    mrph_p->weight = MRPH_DEFAULT_WEIGHT;
	} 
	
	/* (Ф (ߡߡ weight)) ξ */
	else if (atomp(car(midasi_cell))) {
	    midasi_cp = s_atom_val(car(midasi_cell));

	    if (nullp(cdr(midasi_cell)))
	      mrph_p->weight = MRPH_DEFAULT_WEIGHT;
	    else if (atomp(car(cdr(midasi_cell)))) {
		if (sscanf(s_atom_val(car(cdr(midasi_cell))),"%f",
			   &float_weight) == 0)
		  trans_exit("has illegal form", midasi_cell);
		int_weight = (int)(float_weight * MRPH_DEFAULT_WEIGHT);
		if (int_weight > 255)
		  int_weight = 255;
		if (int_weight < 0 || int_weight > 255)
		  trans_exit(": weight must be between 0.0 and 25.5", midasi_cell);
		mrph_p->weight = (unsigned char)int_weight;
	    }
	    else 
	      trans_exit("has illegal form", midasi_cell);
	} else {
	    trans_exit("has illegal form", midasi_cell);
	}

	midasi_cp = hantozen(midasi_cp);
	if (strlen(midasi_cp) > MIDASI_MAX)
	  cha_exit_file(1, "midashi `%s' is too long", midasi_cp);
	strcpy(mrph_p->midasi, midasi_cp);
#ifdef KOCHA2
	if (*mrph_p->yomi == '\0') 
	  strcpy(mrph_p->yomi, mrph_p->midasi);
	if (katuyou == 2) {
	    midasi_last = mrph_p->yomi + strlen(mrph_p->yomi) - 2;
	    if (is_moeum(midasi_last))
		mrph_p->ktype = get_type_id("첻");
	    else if (!strcmp(midasi_last, ""))
		mrph_p->ktype = get_type_id("");
	    else
		mrph_p->ktype = get_type_id("Ҳ");
	}
#endif
        if( nullp(connect_cell = edrconnect(block)) ){
            check_table(mrph_p);                            /* Ϣܾ */
        }
        else{                                         /* for EDRdic '94.Mar */
            check_edrtable(mrph_p, connect_cell);
        }

	if (katuyou == 1) {
	    trim_midasi_gobi(mrph_p);
	    if (strlen(mrph_p->midasi) > 0) {
		print_mrph(fp_out, mrph_p);
	    } else {
		/* 촴̵ʤƤγѷϿ */
		print_mrph_loop(fp_out, mrph_p);
	    }
	} else {
	    print_mrph(fp_out, mrph_p);
	}
	
	loop = cdr(loop);
    }
}

void trans(fp_in, fp_out)
    FILE *fp_in, *fp_out;
{
    mrph_t mrph, *mrph_p;
    cell_t *cell, *main_loop, *main_block, *sub_loop, *sub_block;
    int hinsi;

    mrph_p = &mrph;
    init_mrph(mrph_p);
    hinsi = -1;

    while (!s_feof(fp_in)) {
	cell = s_read(fp_in);

	if (atomp(cell))
	  trans_exit("is not list", cell);

#ifdef VGRAM
	if (atomp(car(cell))) {
	    if (!strcmp(s_atom_val(car(cell)), "ʻ"))
	      hinsi = get_nhinsi_id(car(cdr(cell)));
	    else {
		/* upper compatible for old format */
		char *hinsi_str[256];
		char **hinsi = hinsi_str;
		for (; atomp(car(cell)); cell = car(cdr(cell)))
		  *hinsi++ = s_atom_val(car(cell));
		*hinsi = NULL;
		mrph_p->hinsi = get_nhinsi_str_id(hinsi_str);
		trans_main(cell, mrph_p, fp_out);
	    }
	} else {
	    if (hinsi < 0)
	      cha_exit_file(1, "hinsi is not defined");
	    mrph_p->hinsi = hinsi;
	    trans_main(cell, mrph_p, fp_out);
	}
#else
	/* ʻ */
	mrph_p->hinsi = get_hinsi_id(s_atom(car(cell)));
	main_loop = cdr(cell);
	while (!nullp(main_block = car(main_loop))) {
	    /* ʬब */
	    if (atomp(car(main_block))) {
		mrph_p->bunrui =
		  get_bunrui_id(s_atom_val(car(main_block)), mrph_p->hinsi);
		sub_loop = cdr(main_block);
		while (!nullp(sub_block = car(sub_loop))) {
		    trans_main(sub_block, mrph_p, fp_out);
		    sub_loop = cdr(sub_loop);
		}
	    } 
	    /* ʬबʤ */
	    else {
		mrph_p->bunrui = 0;
		trans_main(main_block, mrph_p, fp_out);
	    }
	    main_loop = cdr(main_loop);
	}
#endif
	s_free(cell);
    }
}
