/*
==============================================================================
	getid.c
==============================================================================
*/

#include "chadic.h"

#ifdef VGRAM
int get_nhinsi_str_id(hinsi)
    char **hinsi;
{
    int id, i, d;
    char *name;

    if (!*hinsi) {
	cha_exit_file(1, "null string for hinsi");
	return 0;
    }

    for (id = 0; *hinsi && **hinsi; hinsi++) {
	for (i = 0; d = Hinsi[id].daughter[i]; i++) {
	    if (!strcmp(Hinsi[d].name, *hinsi))
	      break;
	}
	if (!d){
	  cha_exit_file(-1, "hinsi `%s' is undefined\n", *hinsi);
	  return 0; /* 970301 tatuo: $BLdBj$"$k;~$O(B 0 $B$rJV$9(B */
	}
	id = d;
    }

    return id;
}

int get_nhinsi_id(cell)
    cell_t *cell;
{
    char *hinsi_str[256];
    char **hinsi = hinsi_str;

    for (; !nullp(cell); cell = cdr(cell))
      *hinsi++ = s_atom(car(cell));

    *hinsi = NULL;

    return get_nhinsi_str_id(hinsi_str);
}

#else /* !VGRAM */

int get_hinsi_id(x)
    char *x;
{
    int i;

    if (x == NULL) {
	cha_exit_file(1, "null string for hinsi.");
	return 0;
    }

    if (x[0] == '*' && x[1] == '\0')
      return 0;

    for (i = 1; strcmp(Class[i][0].id, x); )
      if (!Class[++i][0].id){
	cha_exit_file(-1, "hinsi `%s' is undefined\n", x);
	return 0; /* 970301 tatuo: $BLdBj$"$k;~$O(B 0 $B$rJV$9(B */
      }
    return i;
}

int get_bunrui_id(x, hinsi)
    char *x;
    int hinsi;
{
    int i;

    if (x == NULL) {
	cha_exit_file(1, "null string for bunrui");
	return 0;
    }

    if (x[0] == '*' && x[1] == '\0')
      return 0;

    if (!Class[hinsi][1].id) {
	cha_exit_file(1, "hinsi `%s' has no bunrui", Class[hinsi][0].id);
	return 0;
    }

    for (i = 1; strcmp(Class[hinsi][i].id, x); ) {
	if (!Class[hinsi][++i].id) {
	    cha_exit_file(1, "hinsi `%s' has no bunrui `%s'", Class[hinsi][0].id, x);
	    return 0;
	}
    }

    return i;
}

void get_hinsi_bunrui_id(cell, hinsip, bunruip)
    cell_t *cell;
    int *hinsip, *bunruip;
{
    *hinsip = get_hinsi_id(s_atom(car(cell)));

    if (*hinsip && !nullp(car(cdr(cell))))
      *bunruip = get_bunrui_id(s_atom(car(cdr(cell))), *hinsip);
    else
      *bunruip = 0;
}
#endif /* !VGRAM */

int get_type_id(x)
    char *x;
{
    int i;

    if (x==NULL) {
	cha_exit_file(1, "null string for type");
	return 0;
    }

    if (x[0] == '*' && x[1] == '\0')
      return 0;

    for (i = 1; strcmp(Type[i].name, x); ) {
	if (!Type[++i].name) {
	    cha_exit_file(-1, "type `%s' is undefined\n", x);
	    return 255; /* 970301 tatuo: $BLdBj$"$k;~$O(B 255 $B$rJV$9(B($B;CDj(B) */	
	}
    }

    return i;
}

int get_form_id(x, type)
    char *x;
    int type;
{
    int i;

    if (x == NULL) {
	cha_exit_file(1, "null string for form");
	return 0;
    }

    if (x[0] == '*' && x[1] == '\0')
      return 0;

    if (type == 0) {
	cha_exit_file(1, "Invalid type number for type `%s'", x);
	return 0;
    }

    for (i = 1; strcmp(Form[type][i].name, x); ) {
	if (!Form[type][++i].name) {
	    cha_exit_file(1, "type `%s' has no katuyou `%s'", Type[type].name, x);
	    return 0;
	}
    }

    return i;
}

