#include "chadic.h"

#define PATH_NUM            1024
#define INFO_MAX            129 /* ̣ʸȤƳǼ륹åȤΥ */
#define CHA_INPUT_SIZE      8192
#define UNDEF_HINSI_MAX     256

/* for debug */
#if 0
#define debug_print(s) {printf("[%s:%d:%s]\n",__FILE__,__LINE__,s);fflush(stdout);}
#else
#define debug_print(s)
#endif


/*
 * structures
 */

typedef struct _mrph2_t {
    char	*midasi;
    char	*yomi;
    char        *info; /* ̣ʸȤƳǼ륹å */
#ifdef VGRAM
    char	*base;
#endif
    short	base_length;

#ifdef VGRAM
    unsigned short hinsi;
#else
    unsigned char hinsi;
    unsigned char bunrui;
#endif
    unsigned char ktype;
    unsigned char kform;
    char	is_undef;

    unsigned short weight;
    short	length;
    short	con_tbl;
} mrph2_t;

typedef struct _path_t {
    int   mrph_p;
    short state;
    short start;
    short end;
    int   cost;
    int   *path;     /* Υѥξ */
    int   do_print;
} path_t;

typedef struct _undef_info {
    int cost, cost_step;
    int con_tbl;
    int hinsi;
#ifndef VGRAM
    int bunrui;
#endif
} undef_info;

/*
 * global variables
 */

extern mrph2_t *Mrph;
extern path_t *Path;
extern int Path_num;
extern int Con_cost_weight, Con_cost_undef, Mrph_cost_weight, Cost_width;
extern undef_info Undef_info[UNDEF_HINSI_MAX];
extern int Undef_info_num;
extern int Lang_j, Lang_e;
extern char *Bos_string;
extern char *Eos_string;

/*
 * functions
 */

/* init.c */
extern void read_chasenrc_fp();
extern void chasen_init();

/* print.c */
extern char *get_cha_output();
extern void set_cha_fput();
extern void set_cha_output();
extern void print_mrph();
extern void cha_print_path();
extern void cha_print_bos_eos();

/* parse.c */
extern char *take_data();
extern int chasen_sent();

/* chalib.c */
extern void cha_version();
extern void set_opt_form();
extern void set_cost_width();
extern int chasen_getopt_argv();
extern int chasen_fparse();
extern int chasen_sparse();
extern char *chasen_fparse_tostr();
extern char *chasen_sparse_tostr();
extern char *cha_fgets();
extern void read_patdic();

/* jfgets.c */
extern void set_jfgets_delimiter();
extern char *fget_line();
extern char *jfgets();
extern int cha_jistoeuc();

