<?php
/**
* loader for module
*
* PHP version 5
*
* @package    core
* @author     CharcoalPHP Development Team
* @copyright  2008 - 2013 CharcoalPHP Development Team
*/

class Charcoal_ModuleLoader
{
	/*
	 * load module files
	 */
	public static function loadModule( Charcoal_ObjectPath $module_path, Charcoal_ITaskManager $task_manager )
	{
		log_info( "system", "module", "loadModule called by:" . print_r(debug_backtrace(),true) );

		log_info( "system", "module", "started loading module: [$module_path]");

		// create module object
		$module = Charcoal_Factory::createObject( s($module_path->toString()), s('module'), s('Charcoal_IModule'), s('Charcoal_SimpleModule') );

		log_info( "system", "module", "created module object: [$module_path]");

		// load module tasks
		$loaded_tasks = $module->loadTasks( $task_manager );
		if ( $loaded_tasks ){
			log_info( "system", "module", "loaded module tasks: " . print_r($loaded_tasks,true) );
		}

		// load module events
		$loaded_events = $module->loadEvents( $task_manager );
		if ( $loaded_events ){
			log_info( "system", "module", "loaded module events: " . print_r($loaded_events,true) );
		}

		log_info( "system", "module", "finished loading module: [$module_path]");

		// load required modules
		$required_modules = $module->getRequiredModules();
		if ( $required_modules ){
			$loaded_modules = NULL;
			foreach( $required_modules as $module_name ){
				$obj_path = new Charcoal_ObjectPath( s($module_name) );
				$module = Charcoal_ModuleLoader::loadModule( $obj_path, $task_manager );
				$loaded_modules[] = $module;
			}
			if ( $loaded_modules ){
				log_info( "system", "module", "loaded required modules: " . print_r($loaded_modules,true) );
			}
		}

		return $module;
	}


}
return __FILE__;
