<?php
/**
* Smartyレンダラタスク
*
* PHP version 5
*
* @package    renderers
* @author     CharcoalPHP Development Team
* @copyright  2008 - 2013 CharcoalPHP Development Team
*/
require_once( 'Smarty/Smarty.class.php' );

class Charcoal_SmartyRendererTask extends Charcoal_Task implements Charcoal_ITask
{
	var $_template_files;
	var $_smarty;

	/*
	 *	コンストラクタ
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_template_files = array();
		$this->_smarty = new Smarty();

		log_debug( "smarty", "SMARTY_DIR: " . SMARTY_DIR );
	}

	/*
	 * Initialize instance
	 *
	 * @param Charcoal_Config $config   configuration of component
	 */
	public function configure( Charcoal_Config $config )
	{
		parent::configure( $config );

		$this->_smarty->caching 			= 0;	//$config->getBoolean( s('caching') )->getValue();
		$this->_smarty->compile_check 		= $config->getBoolean( s('compile_check'), b(FALSE) )->getValue();
		$this->_smarty->template_dir 		= $config->getString( s('template_dir'), s('') )->getValue();
		$this->_smarty->compile_dir 		= $config->getString( s('compile_dir'), s('') )->getValue();
		$this->_smarty->config_dir 			= $config->getString( s('config_dir'), s('') )->getValue();
		$this->_smarty->cache_dir 			= $config->getString( s('cache_dir'), s('') )->getValue();
		$this->_smarty->_default_modifiers 	= $config->getArray( s('default_modifiers'), v(array()) )->getValue();

		$plugins_dir = $config->getArray( s('plugins_dir'), v(array()) );
		if ( $plugins_dir->isEmpty() ){
			$this->_smarty->plugins_dir	= 'plugins';
		}
		else{
			$this->_smarty->plugins_dir	= $plugins_dir->getValue();
		}

		$left_delimiter = $config->getString( s('left_delimiter'), s('{') );
		if ( !$left_delimiter->isEmpty() ){
			$this->_smarty->left_delimiter 	= $left_delimiter->getValue();
		}
		$right_delimiter = $config->getString( s('right_delimiter'), s('}') );
		if ( !$right_delimiter->isEmpty() ){
			$this->_smarty->right_delimiter = $right_delimiter->getValue();
		}
	}

	/**
	 * Process events
	 *
	 * @param Charcoal_IEventContext $context   event context
	 */
	public function processEvent( Charcoal_IEventContext $context )
	{
		$event    = $context->getEvent();
		$response = $context->getResponse();
		$sequence = $context->getSequence();

		// output response headers
		$response->flushHeaders();

		// レイアウトを取得
		$layout = $event->getLayout();

		log_info( "system,smarty", "SmartyRendererによるレンダリングを行います。layout:" . print_r($layout,true) );

		log_info( "smarty", "caching=" . $this->_smarty->caching );
		log_info( "smarty", "template_dir=" . $this->_smarty->template_dir );
		log_info( "smarty", "compile_dir=" . $this->_smarty->compile_dir );
		log_info( "smarty", "config_dir=" . $this->_smarty->config_dir );
		log_info( "smarty", "cache_dir=" . $this->_smarty->cache_dir );

		try{
			$charcoal = array();

			// リダイレクト
			if ( $layout instanceof Charcoal_IRedirectLayout ){
	
				// リダイレクト先を取得
				$url = $layout->makeRedirectURL();

				// リダイレクト
				$response->redirect( s($url) );

				log_info( "system,smarty", "ページはリダイレクトされました。リダイレクト先:$url" );
			}
			else if ( $event instanceof Charcoal_URLRedirectEvent ){
	
				// リダイレクト先を取得
				$url = $event->getURL();

				// リダイレクト
				$response->redirect( s($url) );

				log_info( "system,smarty", "ページはリダイレクトされました。リダイレクト先:$url" );
			}
			else{

				// Charcoal_EncodingConverterを作成
				$conv = Charcoal_EncodingConverter::fromString( s('PHP'), s('HTML') );

				// フレームワーク情報
				$charcoal['version']['major']    = Charcoal_Framework::getMajorVersion();
				$charcoal['version']['minor']    = Charcoal_Framework::getMinorVersion();
				$charcoal['version']['revision'] = Charcoal_Framework::getRevision();
				$charcoal['version']['build']    = Charcoal_Framework::getBuildNumber();

				// ページ情報
				$page_info = $layout->getAttribute( s('page_info') );
				log_info( "smarty", "page_info:" . print_r($page_info,true) );

				// プロファイル情報
				$profile_config = Charcoal_Profile::getConfig();
				if ( $profile_config && is_array($profile_config) ){
					foreach( $profile_config as $key => $value ){
						$charcoal['profile'][$key] = $value;
					}
				}

				// クッキー情報
				$cookies = $response->getCookies();
				if ( $cookies && is_array($cookies) ){
					foreach( $cookies as $key => $value ){
						$charcoal['cookie'][$key] = $value;
					}
				}

				// Smartyオブジェクトを取得
				$smarty = $this->_smarty;

				// ページ情報をすべてSmartyにassignする
				if ( $page_info && is_array($page_info) ){
					foreach( $page_info as $key => $value ){
						$smarty->assign( $key, $value );
						log_info( "smarty", "page_info [$key]=" . print_r($value,true) );
					}
				}

				// シーケンス情報をすべてシステムデータに設定する
				$charcoal['sequence'] = $sequence;

				// リクエストIDとリクエストパスを設定
				$charcoal['request']['id']   = Charcoal_Framework::getRequestID();
				$charcoal['request']['path'] = Charcoal_Framework::getRequestPath();

				// レスポンスデータをすべてシステムデータに設定する
				$charcoal['response'] = $response;

				// システムデータをassignする
				$smarty->assign( 'charcoal', $charcoal );

				// レスポンスデータをすべてSmartyにassignする
				$keys = $response->getKeys();
				foreach( $keys as $key ){
					$value = $response->get( s($key) );
					$smarty->assign( $key, $value );
					log_info( "smarty", "response [$key]=" . print_r($value,true) );
				}

				// レスポンスオブジェクトをオブジェクトとして登録
				log_info( "smarty", "response:" . print_r($response,true) );
				$smarty->register_object( 'response', $response );

				// テンプレートを展開、表示
				$template = $layout->getAttribute( s('layout') );

				log_info( "smarty", "template=$template" );
				$html = $smarty->fetch( $template );
				log_info( "smarty", "html=$html" );

		log_info( "smarty", "caching=" . $smarty->caching );
				echo $html;

				log_info( "system,smarty", "テンプレートファイルを表示しました。テンプレートファイル名:$template" );
			}
		}
		catch ( Exception $ex )
		{
			_catch( $ex );

			_throw( new Charcoal_SmartyRendererTaskException( s("rendering failed"), $ex ) );
		}

		log_info( "system,smarty", "SmartyRendererによるレンダリングを行いました。" );

		return b(TRUE);
	}
}

return __FILE__;