<?php
/**
* プロファイルのスキーマ情報を扱うクラス
*
* PHP version 5
*
* @package    core
* @author     CharcoalPHP Development Team
* @copyright  2008 - 2013 CharcoalPHP Development Team
*/

class Charcoal_ProfileSchema
{

	/*
	 * プロファイルスキーマ情報
	 */
	public static function getSchema()
	{
		return array(
				'PROC_KEY'             => array(
											'type' => 'S',
											'mandatory' => true,
										),
				'DEFAULT_PROCPATH'    => array(
											'type' => 'S',
											'mandatory' => false,
										),
				'USE_EXTLIB'           => array(
											'type' => 'B',
											'mandatory' => false,
										),
				'EXTLIB_DIR'           => array(
											'type' => 'S',
											'mandatory' => false,
										),
				'DEFAULT_TIMEZONE'     => array(
											'type' => 'S',
											'mandatory' => true,
										),
				'USE_SESSION'          => array(
											'type' => 'B',
											'mandatory' => true,
										),
				'SESSION_HANDLER_NAME' => array(
											'type' => 'S',
											'mandatory' => false,
										),
				'CLASS_LOADERS'        => array(
											'type' => 'S',
											'mandatory' => true,
										),
				'USE_DB'               => array(
											'type' => 'B',
											'mandatory' => false,
										),
				'DB_DATA_SOURCE'       => array(
											'type' => 'S',
											'mandatory' => false,
										),
				'LOG_ENABLED'          => array(
											'type' => 'B',
											'mandatory' => true,
										),
				'LOG_LEVEL'            => array(
											'type' => 'S',
											'mandatory' => false,
										),
				'LOG_LOGGERS'          => array(
											'type' => 'A',
											'mandatory' => false,
										),
				'HTML_CODE'            => array(
											'type' => 'S',
											'mandatory' => true,
										),
				'PHP_CODE'             => array(
											'type' => 'S',
											'mandatory' => true,
										),
				'DB_CODE'              => array(
											'type' => 'S',
											'mandatory' => true,
										),
				'LOG_CODE'             => array(
											'type' => 'S',
											'mandatory' => true,
										),
				'TM_MAX_EVENT_LOOP'    => array(
											'type' => 'I',
											'mandatory' => false,
										),
				'TM_MAX_EVENT_TIME'    => array(
											'type' => 'I',
											'mandatory' => false,
										),
				'ROUTERS'      => array(
											'type' => 'A',
											'mandatory' => false,
										),
				'ROUTING_RULE'      => array(
											'type' => 'S',
											'mandatory' => false,
										),
			);
	}


	/*
	 * プロファイルの内容をダンプ
	 */
	public static function dumpProfileData()
	{
		$schema = self::getSchema();

		// プロファイルログ出力
		$keys = Charcoal_Profile::getKeys();
		foreach( $keys as $key ){

			$type = isset($schema[$key]['type']) ? $schema[$key]['type'] : 'S';
			switch( $type ){
			case 'S':	$method = 'getString';	break;
			case 'I':	$method = 'getInteger';	break;
			case 'B':	$method = 'getBoolean';	break;
			case 'A':	$method = 'getArray';	break;
			}
			$value = Charcoal_Profile::$method(s($key));

			log_info( 'profile', $key . '=' . Charcoal_System::toString($value) );
		}
	}
}

return __FILE__;