<?php
/**
* オブジェクトクラス
*
* PHP version 5
*
* @package    base
* @author     CharcoalPHP Development Team
* @copyright  2008 - 2013 CharcoalPHP Development Team
*/

class Charcoal_Object
{
	/*
	 *	コンストラクタ
	 */
	public function __construct()
	{
	}

	/*
	 *	ハッシュ
	 */
	public function hash()
	{
		return object_hash($this);
	}

	/*
	 *	比較
	 */
	public function equals( Charcoal_Object $object )
	{
		return $this->hash() === $object->hash();
	}

	/**
	 *  Check if an object implements or extends target
	 */
	public function isInstanceOf( Charcoal_String $target )
	{
		$target = us( $target );
		return $this instanceof $target;
	}

	/**
	 * Get class name
	 */
	public function getClassName()
	{
		return get_class($this);
	}

	/**
	 * Get class 
	 */
	public function getClass()
	{
		return new Charcoal_Class( s($this->getClassName()) );
	}

	/*
	 *  String expression of this object
	 *
	 * @return string
	 */
	public final function __toString()
	{
		return us($this->toString());	// __toString() must return string type only!
	}

	/*
	 *  String expression of this object
	 *
	 * @return string
	 */
	public function toString()
	{
		return '[class=' . get_class($this) . ' hash=' . $this->hash() . ']';
	}
}
return __FILE__;
