<?php
/**
* ñʥޥ͡륯饹
*
* PHP version 5
*
* @package    task_managers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class DefaultTaskManager extends CharcoalComponent implements ITaskManager
{
	private $_tasks;
	private $_queue;

	/*
	 * 󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_tasks  = new Vector();
		$this->_queue  = new EventQueue();
	}

	/*
	 * Ͽ
	 */
	public function registerTask( String $task_name )
	{
		// Ѥߤʤ鲿⤷ʤ
		if ( isset($this->_tasks["$task_name"]) ){
			return;
		}

		// 
		$task = Factory::createTask( $task_name );

		// ¸
		$this->_tasks["$task_name"] = $task;
	}

	/*
	 * Ͽ
	 */
	private function _unregisterTask( String $task_name )
	{
		// ¸
		unset( $this->_tasks["$task_name"] );
	}

	/*
	 * ϿƤ뤫
	 */
	public function isTaskRegistered( String $task_name )
	{
		return isset($this->_tasks["$task_name"]);
	}

	/*
	 * 
	 */
	public function getTask( String $task_name )
	{
		if ( isset($this->_tasks["$task_name"]) ){
			return $this->_tasks["$task_name"];
		}

		throw new TaskNotRegisteredException( $task_name );
	}

	/*
	 * ʥåץåȤ
	 */
	public function getSnapshot()
	{
		$snapshot = new TaskSnapshot();

		foreach( $this->_tasks as $task ){
			$snapshot->set( $task );
		}

		return $snapshot;
	}

	/**
	 *   ơȥե륿¸Ԥ
	 *
	 */
	public function saveStatefulTasks( Session $session )
	{
		foreach( $this->_tasks as $task ){
			if ( $task instanceof IStateful ){
				$data_id = "task://" . $task->getName();
				$session->set( s($data_id), $task->serializeContents() );
			}
		}
	}

	/**
	 *   ơȥե륿Ԥ
	 *
	 */
	public function restoreStatefulTasks( Session $session )
	{
		foreach( $this->_tasks as $task ){
			if ( $task instanceof IStateful ){
				$data_id = "task://" . $task->getName();
				if ( isset($_SESSION[ $data_id ]) ){
					$data = $_SESSION[ $data_id ];
					$task->deserializeContents( unserialize($data) );
				}
			}
		}
	}

	/*
	 * ٥ȥǥѥåԤ
	 *
	 */
	public function dispatchEvents( IRequest $request )
	{
		log_info( "system",  "٥ȥǥѥå򳫻Ϥޤ", __FILE__, __LINE__ );

		$queue = $this->_queue;

		// 
		log_info( 'event', "starting to dispatch events.", __FILE__, __LINE__ );

		// ꥯȥ٥Ȥκ
		$event = Factory::createRequestEvent( s('http_request'), $request );

		// ٥Ȥ򥤥٥ȥ塼ɲ
		$queue->enqueue( $event );

		// 
		log_info( 'event', "request event[$event] wad dispatched.", __FILE__, __LINE__ );

		log_info( "system",  "٥ȥǥѥåλޤ", __FILE__, __LINE__ );
	}

	/**
	 *   ٥ȽԤ
	 *
	 */
	public function processEvents()
	{
//		try{
			$queue = $this->_queue;

			// ¹ԥꥹ
			$task_exec_list = clone $this->_tasks;

			// 祤٥Ƚ
			$max_event_loop = Profile::getInteger( s('TM_MAX_EVENT_LOOP'), 100 )->getValue();

			// 祤٥Ƚ
			$max_event_time = Profile::getInteger( s('TM_MAX_EVENT_TIME'), 10 )->getValue();

			$start = Benchmark::nowTime();

			$event_count = 0;
			while( !$queue->isEmpty() ){
				// 
				log_info( 'event', "loop count: $event_count", __FILE__, __LINE__ );
				log_info( 'event', "event queue: [ " . implode( ',', $queue->toArray() ) . " ]", __FILE__, __LINE__ );

				// ٥Ȥ
				$event = $queue->dequeue();
				$event_name = $event->getName();

				// 
				log_info( 'event', "starting process an event[$event].", __FILE__, __LINE__ );

				// ٤ƤΥ˥٥Ȥǥѥå
				$next_task_exec_list = clone $task_exec_list;
				log_info( 'event', "task execution list $task_exec_list.", __FILE__, __LINE__ );
				foreach( $task_exec_list as $task ){
					log_info( 'event', "event[$event] is dispatching to task[$task].", __FILE__, __LINE__ );

					// ٥ȥե륿
					$process = FALSE;
					$event_filters = $task->getEventFilters();
					log_info( 'event', "task[$task] event filter: $event_filters.", __FILE__, __LINE__ );
					foreach( $event_filters as $filter ){
						if ( $event_name->equals( s($filter) ) ){
							$process = TRUE;
							break;
						}
					}

					if ( !$process ){
						log_info( 'event', "event[$event] is not in the event filters $event_filters.", __FILE__, __LINE__ );
						continue;
					}

					// ɾȽ
					$process = TRUE;
					$guard_conditions = $task->getGuardConditions();
					log_info( 'event', "task[$task]'s guard conditions are $guard_conditions", __FILE__, __LINE__ );
					foreach( $guard_conditions as $task_name => $conditions ){
						if ( $this->isTaskRegistered(s($task_name)) ){
							$guard_task = $this->getTask( s($task_name) );
							foreach( $conditions as $key => $value ){
								// value̾ͤʬ
								$pos = strpos($value,':');
								if ( $pos === FALSE ){
									// ꤬ʤ硢ǥեȤʸ
									$value = s($value);
								}
								else{
									$type = substr($value,0,$pos);
									$value = substr($value,$pos+1);
									switch( $type ){
									case 'b':	$value = boolval($value);		break;
									case 'i':	$value = intval($value);		break;
									case 's':	$value = $value;				break;
									default:
										_throw ( new TaskGuardConditionException($task,$guard_task,$key,"invalid data type in guard value[$value]" ) );
									}
								}
								if ( $guard_task->$key !== $value ){
									// ɾʤΤǽʤ
									$type = gettype($guard_task->$key);
									$type2 = gettype($value);
									log_info( 'event', "guard task[$guard_task] status[$key => $type:{$guard_task->$key}] did not meet the guard conditions: task[$task_name] status[$key => $type2:{$value}].", __FILE__, __LINE__ );
									$process = FALSE;
									break 2;
								}
							}
						}
					}

					if ( !$process ){
						continue;
					}

					// ٥Ƚ
					$result = $task->processEvent( $event, $this->getSnapshot() );

					// 㳰å򥯥ꥢ
					ExceptionStack::clear();

					// 
					log_info( 'event', "[$event] was processed by task[$task]: result=[$result]", __FILE__, __LINE__ );

					// ̤IEventǤBooleanǤʤХ顼
					if ( $result instanceof IEvent ){
						// ٥Ȥ򥭥塼˺
						$queue->enqueue( $result );
						log_info( 'event', "event[$result] was enqueued[$queue].", __FILE__, __LINE__ );	
					}
					else if ( !($result instanceof Boolean) ){
						_throw( new ProcessEventException( $event, $task, $result, s('ITask::processEvent() must return a [Boolean] or [IEvent] value.') ) );
					}

					// ݥȥ
					$post_actions = $task->getPostActions();
					log_info( 'event', "task[$task] post actions $post_actions .", __FILE__, __LINE__ );	
					if ( isset($post_actions[$event_name]) ){
						// ݥȥ¹
						$actions = $post_actions[$event_name];
						// ʣΥ
						$actions = v(explode( ',', $actions ));
						log_info( 'event', "post actions for the event[$event] are [$actions].", __FILE__, __LINE__ );	
						foreach( $actions as $key => $action ){
							$action = trim($action);
							log_info( 'event', "executing post action[$action].", __FILE__, __LINE__ );	
							switch( $action ){
							case 'remove_task';
								// ¹ԥꥹȤ饿
								$task_name = $task->getName();
								unset( $next_task_exec_list["$task_name"] );
								log_info( 'event', "task[$task] was unregistered from execution list: $next_task_exec_list.", __FILE__, __LINE__ );
								break;
							case 'remove_event':
								// ٥Ȥ
								log_info( 'event', "event[$event] was removed.", __FILE__, __LINE__ );		
								$event = NULL;
								break;
							case 'continue_event':
								// ٥Ȥ򥭥塼˺						
								break;
							}
						}
					}
					else{
						log_info( 'event', "no post action is  defined for event[$event].", __FILE__, __LINE__ );	
					}

					// ٥Ⱥʤ롼פȴ
					if ( !$event ){
						break;
					}
				}

				// Υ٥ȤǻȤ¹ԥꥹ
				$task_exec_list = $next_task_exec_list;

				// ٥ȥȤΥ󥯥
				$event_count ++;
				// ٥ȥȤĶƤ˥󥰤Фƽλ
				if ( $event_count > $max_event_loop ){
					log_warning( 'event', "٥Ƚ[$max_event_loop]Ķᡢ٥ȽǤޤ", __FILE__, __LINE__ );
					break;
				}

				// в֥å
				$now = Benchmark::nowTime();
				if ( $now - $start > $max_event_time ){
					log_warning( 'event', "٥ȼ¹Ի֤[$max_event_time]Ķᡢ٥ȽǤޤ", __FILE__, __LINE__ );
					break;
				}
			}

			if ( $queue->isEmpty() ){
				log_info( 'event', "event queue is empty.", __FILE__, __LINE__ );	
			}

			// 
			$now = Benchmark::nowTime();
			$elapse = round( $now - $start, 4 );
			log_info( 'event', "event loop end. count=[$event_count] time=[$elapse]sec.", __FILE__, __LINE__ );
//		}
//		catch( Exception $ex ){
//			print "catch: $ex <BR>";
//		}
	}



}

return __FILE__;
