<?php
/**
* ååפ륯饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class Session extends Object
{
	var $_data;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_data = array();
	}

	/*
	 *	å̾
	 */
	public function getName()
	{
		return session_name();
	}

	/*
	 *	å¸
	 */
	public function getSavePath()
	{
		return session_save_path();
	}

	/*
	 *	å󥯥åΥѥ᡼
	 */
	public function getCookieParameter( String $key )
	{
		$a = session_get_cookie_params();
		return $a[ "$key" ];
	}

	/*
	 *	å󥯥åΥѥ᡼򤹤٤Ƽ
	 */
	public function getCookieParameters()
	{
		return session_get_cookie_params();
	}

	/*
	 *	
	 */
	public function clear()
	{
		$this->_data = array();
	}

	/*
	 *    
	 */
	public function getKeys()
	{
		return array_keys( $this->_data );
	}

	/*
	 *    ѥ᡼
	 */
	public function get( String $key )
	{
		if ( !isset($this->_data[ "$key" ]) ){
			return NULL;
		}
		$value = $this->_data[ "$key" ];
		return $value;
	}

	/*
	 *    ѥ᡼
	 */
	public function set( String $key, $value )
	{
		$this->_data[ "$key" ] = $value;
	}

	/*
	 *    ѥ᡼
	 */
	public function remove( String $key )
	{
		if ( !isset( $this->_data[ "$key" ] ) ){
			return NULL;
		}
		$value = $this->_data[ "$key" ];
		unset( $this->_data[ "$key" ] );
		return $value;
	}

	/**
	 * å򳫻Ϥ
	 */
	public function start()
	{
		session_cache_limiter('private, must-revalidate');
		session_start();
	}

	/**
	 * åλ
	 */
	public function close()
	{
		session_write_close();
	}

	/*
	 *    å˴
	 */
	public function destroy()
	{
		$this->clear();
		session_unset();
		session_destroy();
	}

	/**
	 * å
	 */
	public function restore()
	{
		// ν
		$this->clear();


		// ͤǥꥢ饤
		$keys = array_keys( $_SESSION );
		if ( $keys ){
			foreach( $keys as $key ){
				$value = unserialize( $_SESSION[$key] );
				$this->set( s($key), $value );
			}
		}
	}

	/**
	 * å¸
	 */
	public function save()
	{
		// Ƥ
		$_SESSION = array();

		$keys = $this->getKeys();

		// ꤵ줿ͤ򥷥ꥢ饤
		foreach( $keys as $key ){
			$value = $this->get( s($key) );
			$_SESSION[ $key ] = serialize($value);
		}
	}

	/*
	 *    ʸ
	 */
	public function __toString()
	{
		return System::arrayToString( $this->_data );
	}
}
