<?php

/**
* SmartGateway饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
class SmartGateway extends Object
{
	private $_source;
	private $_builder;
	private $_models;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->refresh();
	}

	/*
	 *	ǡ
	 */
	public function getDataSource()
	{
		return $this->_source;
	}

	/*
	 *	SQLӥ
	 */
	public function getSQLBuilder()
	{
		return $this->_builder;
	}

	/*
	 *	³
	 */
	public function refresh()
	{
		// ǡɤ߹
		$data_source_name = Profile::getString( s('DB_DATA_SOURCE') );
		$this->_source = Factory::createDataSource( $data_source_name );

		// SQLӥɤ߹
		$builder_name = $this->_source->getBackend();
		if ( $builder_name && !$builder_name->isEmpty() ){
			$this->_builder = Factory::createSQLBuilder( $builder_name );
		}
	}

	/*
	 *	ơ֥ǥμ
	 */
	public function getModel( String $model_name )
	{
		// åˤФ֤
		if ( isset($this->_models["$model_name"]) ){
			return $this->_models["$model_name"];
		}
		// ʤΤǺ
		$model = Factory::createTableModel( $model_name );

		$this->_models["$model_name"] = $model;

		return $model;
	}

	/*
	 *	¸
	 */
	public  function save( String $model_name, DTO $dto, String $converter_str = NULL )
	{
		$conv = $converter_str ? EncodingConverter::fromString($converter_str) : NULL;

		// ơ֥ǥ
		$model = $this->getModel( $model_name );

		try{
			// UPDATEINSERTȽ
			$pk = $model->getPrimaryKey();

			if ( isset($dto["$pk"]) ){
				// ץ饤ޥꥭǸƤߤƥ쥳ɤʤINSERTUPDATE
				$db_dto = $this->findByID( $model_name, s($dto["$pk"]) );
				$is_new = ($db_dto === NULL);
			}
			else{
				// ץ饤ޥꥭͤꤵƤʤINSERT
				$is_new = TRUE;
			}


			// SQL
			if ( $is_new ){
				list( $sql, $params ) = $this->_builder->buildInsertSQL( $model, $dto );
			}
			else{
				list( $sql, $params ) = $this->_builder->buildUpdateSQL( $model, $dto );
			}

			// ʸѴmagic_quote_gpcˤ뼫ưײ
			if ( $conv ){
				foreach( $params as $key => $value ){
					if ( is_string($value) ){
						$value = $conv->convertEncoding( $value );
						if ( get_magic_quotes_gpc() ) {
							$value = stripslashes( $value );
						}
						$params[$key] = $value;
					}
				}
			}

			// SQL¹
			$this->_source->prepareExecute( s($sql), v($params) );

			// ID֤
			if ( $is_new ){
				$sql = $this->_builder->buildLastIdSQL();
				
				// ¹
				$result = $this->_source->prepareExecute( s($sql) );

				// եå
				$row = $this->_source->fetchArray( $result );

				$new_id = $row[0];
			}
			else{
				$new_id = $dto["$pk"];
			}

			return $new_id;
		}
		catch ( Exception $e )
		{
			_throw( new DBException( "SmartGateway#save failed" ) );
		}
	}

	/*
	 *	SQL¹(INSERT/DELETE/UPDATE)
	 */
	public  function execute( String $sql, Vector $params = NULL )
	{
		try{
			// ¹
			$this->_source->prepareExecute( $sql, $params );
		}
		catch ( Exception $e ) 
		{
			// ̤throw
			_throw( new DBException( "exec_SQL failed" ) );
		}
	}

	/*
	 *	SQL¹(SELECT)
	 */
	public  function query( String $sql, Vector $params = NULL, String $converter_str = NULL )
	{
		try{

			$conv = $converter_str ? EncodingConverter::fromString($converter_str) : NULL;

			// ƥʤDataSourceݡͥȤ
			$ds = $this->_source;

			$a = array();

			// ¹
			$result = $ds->prepareExecute( $sql, $params );

			// եå
			while( $row = $ds->fetchAssoc( $result ) ){
				foreach( $row as $key => $value ){
					// ʸʤ饨󥳡ǥѴ
					if ( $conv && is_string($value) ){
						$value = $conv->convertEncoding($value);
						$row[$key] = $value;
					}
				}
				$a[] = $row;
			}
		}
		catch ( Exception $e ) 
		{
			// ̤throw
			_throw( new DBException( "exec_SQL failed" ) );
		}

		return $a;
	}

	/*
	 *	SQL
	 */
	public  function findBySQL( String $model_name, $sql, $params = NULL, String $converter_str = NULL, HashMap $model_count = NULL ) 
	{
		try{
			$conv = $converter_str ? EncodingConverter::fromString($converter_str) : NULL;

			// ơ֥ǥ
			$model = $this->getModel( $model_name );

			if ( $model_count === NULL ){
				$model_id = $model->getModelID();
				$model_count = new HashMap( array( "$model_id" => 1 ) );
			}
			else{
				$model_id = $model->getModelID();
				$model_count->set( $model_id, 1 );
			}

			$a = new Vector;

			// Ϣ
			$relation_list = $model->getRelationList();
			$relation_map = array();
			foreach ($relation_list as $field) 
			{
				// @target
				$target = $model->getAnnotationValue( s($field), s('target') );
				if ( !$target ){
					_throw( new DBException( "@target is missing for @relation: field=$field" ) );
				}
				$target = $this->getModel( $target );

				// @foreign_key
				$foreign_key = $model->getAnnotationValue( s($field), s('foreign_key') );

				// @key_field
				$key_field = $model->getAnnotationValue( s($field), s('key_field') );

				// @linkage
				$linkage = $model->getAnnotationValue( s($field), s('linkage'), s('inner') );
				if ( !$linkage->equals( s('inner') ) && !$linkage->equals( s('outer') ) ){
					_throw( new DBException( "Invalid linkage anottation : $linkage" ) );
				}

				// @extract
				$extract = $model->getAnnotationValue( s($field), s('extract') );

				// ȥեɤά줿ν
				if ( !$foreign_key ){
					if ( $linkage->equals( s('inner') ) ){
						$foreign_key = $model->getForeignKey( $target->getModelID() );
					}
					else if ( $linkage->equals( s('outer') ) ){
						$foreign_key = $target->getForeignKey( $model->getModelID() );
					}
				}
				if ( !$key_field ){
					if ( $linkage->equals( s('inner') ) ){
						$key_field = $target->getPrimaryKey();
					}
					else if ( $linkage->equals( s('outer') ) ){
						$key_field = $model->getPrimaryKey();
					}
				}

				// ޥåפ¸Ƥ

				$relation_map[ $field ] = new DBRelation( $target, $foreign_key, $key_field, $linkage, $extract );
			}

			// DataSource
			$ds = $this->_source;

			// եɰ
			$field_list = $model->getFieldList();

			// ¹
			$result = $ds->prepareExecute( s($sql), v($params) );

			// եå
			while( $row = $ds->fetchAssoc( $result ) )
			{
				$dto = $model->createDTO();

				// SQL̥åȤDTOͤ򥳥ԡ
				foreach ($field_list as $name) 
				{
					// ե
					$value = isset($row[$name]) ? $row[ $name ] : NULL;
					// ʸʤ饨󥳡ǥѴ
					if ( $conv && is_string($value) ){
						$value = $conv->convertEncoding($value);
					}
					// ֵ
					$dto->$name = $value;
				}

				// ץ饤ޥꥭ
				$pk = $model->getPrimaryKey();
				$id = $row[ "$pk" ];
				// Ϣ
				foreach ($relation_list as $field) 
				{
					// Ϣ
					$relation = $relation_map[ $field ];
					// Ϣơ֥ǥ
					$target = $relation->getTarget();
					// ̾
					$foreign_key = $relation->getForeignKey();
					// ե̾
					$key_field = $relation->getKeyField();
					// 󥱡
					$linkage = $relation->getLinkage();
					// Ÿե
					$extract = $relation->getExtract();
					// Ϣơ֥̾
					$table_name = $target->getTableName();

					// SQL
					switch ( $linkage ){
					case 'inner':
						{
							// 󥱡 : ơ֥¦ˤ
							$key_value = $row[ "$foreign_key" ];
							$sql = "select * from $table_name where $key_field = ?";
						}
						break;
					case 'outer':
						{
							// 󥱡 : Ϣơ֥¦ˤ
							$key_value = $row[ "$key_field" ];
							$sql = "select * from $table_name where $foreign_key = ?";
						}
						break;
					default:
						{
							// ˤϤʤϤ
							_throw( new DBException( "Invalid linkage anottation : $linkage" ) );
						}
						break;
					}
					// Ƶ롼ץå
					$target_model_id = $target->getModelID();
					$cnt = $model_count->get( $target_model_id );
					if ( $cnt === NULL ){
						// ̤DTO˥ޡ
						$child_result = $this->findBySQL( $target->getModelID(), $sql, array($key_value), $converter_str, $model_count );
						switch ( $extract ){
						case 'field':
							{
								// եɤŸ
								if ( $child_result ){
									$child = $child_result->shift();
									if ( $child ){
										// ΥơեɼΤˤDTO򥻥å
										$dto->$field = $child;
										// @extractν
										foreach( $child as $key => $value ){
											// @extractǻꤵƤեɤŸ
											$extract_field = $model->getExtractField( $target->getModelID(), s($key) );
											if ( $extract_field ){
												$dto->$extract_field = $value;
											}
										}
									}
								}
							}
							break;
						case 'array':
						default:
							{
								// ˥å
								$dto->$field = $child_result;
							}
							break;
						}
					}
				}
				$a->add( $dto );
			}
		}
		catch ( Exception $e ) 
		{
			_catch( $e );

			// ̤throw
			_throw( new DBException( "findBySQL failed" ) );
		}

		return $a;
	}

	/*
	 *	ǽΣ
	 */
	public  function findFirst( String $model_name, SQLCriteria $criteria = NULL, String $converter_str = NULL ) 
	{
		try{
			if ( !$criteria ){
				$criteria = new SQLCriteria();
			}

			// LIMIT=1
			$criteria->setLimit( i(1) );

			// ¹
			$result = $this->findAll( $model_name, $criteria, $converter_str );

			return $result ? $result->shift() : NULL;
		}
		catch ( Exception $e )
		{
			_catch( $e );

			_throw( new DBException( "SmartGateway#findFirst failed" ) );
		}
	}

	/*
	 *	
	 */
	public  function findAll( String $model_name, SQLCriteria $criteria = NULL, String $converter_str = NULL ) 
	{
		try{
			// ơ֥ǥ
			$model = $this->getModel( $model_name );

			// ơ֥̾
			$table = $model->getTableName();

			// SQLӥ
			$builder = $this->_builder;

			// SQLκ
			$sql = $builder->buildSelectSQL( $model, $criteria );

			// ѥ᡼
			$params = $criteria ? $criteria->getParams() : NULL;

			// ¹
			$result = $this->findBySQL( $model_name, $sql, $params, $converter_str );

			return $result;
		}
		catch ( Exception $e )
		{
			_catch( $e );

			_throw( new DBException( "SmartGateway#findAll failed" ) );
		}
	}

	/*
	 *	ĤΥեɤΤߤǸ
	 */
	public  function findAllBy( String $model_name, $field, $value, SQLCriteria $criteria = NULL, String $converter_str = NULL )
	{
		try{
			if ( !$criteria ){
				$criteria = new SQLCriteria();
			}

			$criteria->setWhereClause( "$field = ?" );
			$criteria->setParams( array( $value ) );

			$a = $this->findAll( $model_name, $criteria, $converter_str );

			return $a;
		}
		catch ( Exception $e )
		{
			_throw( new DBException( "SmartGateway#findAllBy failed" ) );
		}
	}

	/*
	 *	ID鸡(Ĥꤷ)
	 */
	public  function findByID( String $model_name, String$id, String $converter_str = NULL ) 
	{
		try{
			// Ĥꤷ
			$where_clause = s('id = ?');
			$params = v(array( $id ));

			$criteria = new SQLCriteria( $where_clause, $params );

			return $this->findFirst( $model_name, $criteria, $converter_str );
		}
		catch ( Exception $e )
		{
			_throw( new DBException( "SmartGateway#findByID failed" ) );
		}
	}

	/*
	 *	ID鸡
	 */
	public  function findAllByID( String $model_name, Vector $id_array ) 
	{
		try{
			// ơ֥ǥ
			$model = $this->getModel( $model_name );

			// ʣĻꤷ
			$where = array();
			$params = array();
			
			foreach( $id_array as $id ){
				$where[] = "?";
				$params[] = $id;
			}

			$where_clause = "id in (" . implode(",",$where) . ")";

			$condition = new SQLCriteria( $where_clause, $params );

			$a = $this->findAll( $dto, $condition );

			return $a;
		}
		catch ( Exception $e )
		{
			_throw( new DBException( "SmartGateway#findAllByID failed" ) );
		}
	}

	/*
	 *	ʣĤꤷ
	 */
	public  function destroyById( String $model_name, String $id ) 
	{
		try{
			// ơ֥ǥ
			$model = $this->getModel( $model_name );

			// ե̾
			$pk = $model->getPrimaryKey();

			// SQLѥ᡼
			$params = array( "$id" );

			// 
			$criteria = new SQLCriteria();
			$criteria->setWhereClause( s("$pk = ?") );
			$criteria->setParams( v($params) );

			// SQLӥȤSQL
			$sql = $this->_builder->buildDeleteSQL( $model, $criteria );

			$this->execute( s($sql), v($params) );
		}
		catch ( Exception $e )
		{
			_throw( new DBException( "SmartGateway#destroyById failed" ) );
		}
	}

	/*
	 *	ʣꤷ
	 */
	public  function destroyAllById( String $model_name, Vector $id_array ) 
	{
		try{
			// ơ֥ǥ
			$model = $this->getModel( $model_name );

			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto );

			// ʣĻꤷ
			$where = array();
			$params = array();
			
			foreach( $id_array as $id ){
				$where[] = "?";
				$params[] = $id;
			}

			$sql = "delete from $table where id in (" . implode(",",$where) . ")";

			$this->execute( $sql, $params );
		}
		catch ( Exception $e )
		{
			_throw( new DBException( "SmartGateway#destroyById failed" ) );
		}
	}

	/*
	 *	ĤΥեɤ˹פ쥳ɤ
	 */
	public  function destroyBy( String $model_name, String $field, $value )
	{
		$where_clause = "$field = ?";
		$params = array( $value );

		$this->destroyAll( $dto, $where_clause, $params );
	}


	/*
	 *	˹פ쥳ɤ
	 */
	public  function destroyAll( String $model_name, String $where_clause = NULL, Vector $params = NULL ) 
	{
		try{
			// ơ֥ǥ
			$model = $this->getModel( $model_name );

			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto );

			$sql = "delete from $table where $where_clause";

			$this->execute( $sql, $params );
		}
		catch ( Exception $e )
		{
			_throw( new DBException( "SmartGateway#destroyAll failed" ) );
		}
	}

	/*
	 *	ơ֥Υ쥳ɿ
	 */
	private function _checkSQLBuilder() 
	{
		// ֥ȤʤХ顼
		if ( !$this->_builder ){
			_throw( new DBException( 'No SQL Builder Specified' ) );
		}
	}

	/*
	 *	ơ֥Υ쥳ɿ
	 */
	public  function count( String $model_name, String $where_clause = NULL, Vector $params = NULL ) 
	{
		try{
			// ơ֥ǥ
			$model = $this->getModel( $model_name );

			// SQLӥΥå
			$this->_checkSQLBuilder();

			// WHERE
			if ( $where_clause ){
				$criteria = new SQLCriteria();
				$criteria->setWhereClause( $where_clause );
				$criteria->setParams( $params );
			}
			else{
				$criteria = NULL;
			}

			// SQL
			$sql = $this->_builder->buildCountSQL( $model, $criteria );

			// SQL¹
			$result = $this->_source->prepareExecute( s($sql), v($params) );

			// եå
			$rows = $this->_source->fetchArray( $result );

			return $rows[0];
		}
		catch ( Exception $e )
		{
			_catch( $e );
			_throw( new DBException( "SmartGateway#count failed" ) );
		}
	}

	/*
	 *	եɤκͤ
	 */
	public  function max( String $model_name, String $field, String $where_clause = NULL, Vector $params = NULL ) 
	{
		try{
			// ơ֥ǥ
			$model = $this->getModel( $model_name );

			if ( $where_clause ){
				$criteria = new SQLCriteria();
				$criteria->setWhereClause( $where_clause );
				$criteria->setParams( $params );
			}
			else{
				$criteria = NULL;
			}

			// SQL
			$sql = $this->_builder->buildMaxSQL( $model, $field, $criteria );

			// SQL¹
			$result = $this->_source->prepareExecute( $sql, $params );

			// եå
			$rows = $this->_source->fetchArray( $result );

			return $rows[0];
		}
		catch ( Exception $e )
		{
			_throw( new DBException( "SmartGateway#count failed" ) );
		}
	}


	/*
	 *	DB
	 */
	public  function createDatabase( String $db_name, String $charset ) 
	{
		try{
			// SQLӥȤSQL
			$sql = $this->_builder->buildCreateDatabaseSQL( $db_name, $charset );

			// SQL¹
			$this->_source->execute( s($sql) );

		}
		catch ( Exception $e )
		{
			_throw( new DBException( "SmartGateway#createDatabase failed" ) );
		}
	}

	/*
	 *	ơ֥
	 */
	public  function createTable( String $model_name ) 
	{
		try{
			// ơ֥ǥ
			$model = $this->getModel( $model_name );

			// SQLӥȤSQL
			$sql = $this->_builder->buildCreateTableSQL( $model );

			// SQL¹
			$this->_source->execute( s($sql) );

		}
		catch ( Exception $e )
		{
			_throw( new DBException( "SmartGateway#createTable failed" ) );
		}
	}
}
return __FILE__;
