<?php
/**
* Ūʴؿ򽸤᤿饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class System
{
	/**
	 *	ƤӽФս
	 *
	 *	@return list($file,$line) եֹ̾
	 */
	public static function caller( $back = 0 )
	{
		$bt = debug_backtrace();
		$trace = $bt[1 + $back];

		return array( $trace['file'], $trace['line'] );
	}

	/*
	 *    ߻֤
	 */
	public static function now(){ 
		list($msec,$sec) = explode(' ',microtime()); 
		return ( (float)$msec + (float)$sec );
	}

	/**
	 *	Ĥդκʬñ̤ǵ
	 */
	public static function dateDiff( $date1, $date2 = NULL ){
		if ( $date2 == NULL ){
			// 
			$date2 = date("Y/m/d");
		}
		$result = strtotime($date2) - strtotime($date1);
		$result = intval( $result / (24 * 60 * 60));
		return $result;
	}

	/**
	 *	Ĥդ
	 */
	public static function compareDate( $date1, $date2 = NULL ){
		if ( $date2 == NULL ){
			// 
			$date2 = date("Y/m/d");
		}
		$result = strtotime($date1) - strtotime($date2);
		return $result;
	}

	/**
	 *    ѿפ
	 *
	 */
	public static function dump( $var, $depth = 0, $max_string_length = 40 )
	{
		$type = gettype($var);
		switch( $type ){
		case 'string':
		case 'integer':
		case 'double':
		case 'boolean':
		case 'NULL':
		case 'unknown type':
			{
				$str = strval($var);
				if ( strlen($str) > $max_string_length ){
					$str = substr( $str, 0, $max_string_length ) . '...';
				}
				$str = htmlspecialchars( $str, ENT_QUOTES );
				echo str_repeat( '-', $depth * 4 ) . "[$type]$str<br>";
			}
			break;
		case 'array':
			{
				echo str_repeat( '-', $depth * 4 ) . "[array]<br>";
				foreach( $var as $key => $value ){
					echo str_repeat( '-', ($depth + 1)*4 ) . "[$key]==&gt;<br>";
					System::dump( $value, $depth + 2 );
				}
			}
			break;
		case 'object':
			{
				$obj_vars = get_object_vars( $var );
				$clazz = get_class( $var );
				echo str_repeat( '-', $depth * 4 ) . "[object]$clazz<br>";
				foreach( $obj_vars as $key => $value ){
					echo str_repeat( '-', ($depth + 1)*4 ) . "[$key]==&gt;<br>";
					System::dump( $value, $depth + 2 );
				}
			}
			break;
		}
	}

	/** 
	 *	ʸΥ󥳡ǥȽ
	 */
	public static function detectEncoding( $str, $detect_order = "EUC-JP, SJIS, JIS, UTF-8" ){

		return mb_detect_encoding( $str, $detect_order, TRUE );

	}

	/**
	 *	󥳡Ѵ
	 */
	public static function convertEncoding( $str, $to_encoding = NULL, $from_encoding = NULL )
	{
		if ( is_string($str) && $to_encoding ){
			// 󥳡ɤ
			return mb_convert_encoding($str,$to_encoding, $from_encoding);
		}
		// 󥳡̵
		return $str;
	}

	/**
	 *	Ƶ󥳡Ѵ
	 */
	public static function convertEncodingRecursive( $var, $to_encoding = NULL, $from_encoding = NULL )
	{
		$type = gettype($var);
		switch( $type ){
		case 'string':
			{
				return mb_convert_encoding($var,$to_encoding, $from_encoding);
			}
			break;
		case 'integer':
		case 'double':
		case 'boolean':
		case 'NULL':
		case 'unknown type':
			break;
		case 'array':
			{
				$newArray = array();
				foreach( $var as $key => $value ){
					$newArray[ $key ] = System::convertEncodingRecursive( $value, $to_encoding, $from_encoding );
				}
				return $newArray;
			}
			break;
		case 'object':
			{
				$newObject = clone $var;
				$obj_vars = get_object_vars( $var );
				foreach( $obj_vars as $key => $value ){
					$newObject->$key = System::convertEncodingRecursive( $value, $to_encoding, $from_encoding );
				}
				return $newObject;
			}
			break;
		}

		return $var;
	}

}

return __FILE__;
