<?php
/**
* ե졼ѥ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class FrameworkClassLoader
{
	static $class_paths;

	/*
	 * 饹ѥν
	 */
	public static function initClassPath()
	{
		self::$class_paths = array(

		// base classes
				'Boolean'					=> 'base',
				'CharcoalComponent'			=> 'base',
				'CharcoalException'			=> 'base',
				'ConfigException'			=> 'base',
				'HashMap'					=> 'base',
				'Integer'					=> 'base',
				'Object'					=> 'base',
				'Stack'						=> 'base',
				'String'					=> 'base',
				'Vector'					=> 'base',
				'Queue'						=> 'base',

		// class loaders
				'UserClassLoader'			=> 'class_loaders',

		// debug classes
				'BackTrace'					=> 'debug',
				'BackTraceElement'			=> 'debug',
				'MethodSpec'				=> 'debug',
				'FunctionSpec'				=> 'debug',
				'CallHistory'				=> 'debug',
				'PhpSourceElement'			=> 'debug',
				'PhpSourceInfo'				=> 'debug',
				'PhpSourceParser'			=> 'debug',
				'PhpSourceRenderer'			=> 'debug',

		// core classes
				'Annotation'				=> 'core',
				'AnnotationUtil'			=> 'core',
				'Benchmark'					=> 'core',
				'ClassLoader'				=> 'core',
				'ClassUtil'					=> 'core',
				'CommandLineUtil'			=> 'core',
				'Config'					=> 'core',
				'ConfigLoader'				=> 'core',
				'ConfigUtil'				=> 'core',
				'DBRelation'				=> 'core',
				'DIContainer'				=> 'core',
				'DTO'						=> 'core',
				'EncodingConverter'			=> 'core',
				'EventQueue'				=> 'core',
				'ExceptionStack'			=> 'core',
				'ExceptionStackEntry'		=> 'core',
				'Factory'					=> 'core',
				'File'						=> 'core',
				'Framework'					=> 'core',
				'Logger'					=> 'core',
				'MemoryUsage'				=> 'core',
				'Profile'					=> 'core',
				'ProfileSchema'				=> 'core',
				'ResourceLocator'			=> 'core',
				'Response'					=> 'core',
				'Session'					=> 'core',
				'SmartGateway'				=> 'core',
				'SQLCriteria'				=> 'core',
				'System'					=> 'core',
				'TaskSnapshot'				=> 'core',

		// interface classes
				'IClassLoader'				=> 'interfaces',
				'IComponent'				=> 'interfaces',
				'IConfigProvider'			=> 'interfaces',
				'IDataSource'				=> 'interfaces',
				'IDomainModel'				=> 'interfaces',
				'IEvent'					=> 'interfaces',
				'IFilter'					=> 'interfaces',
				'IForm'						=> 'interfaces',
				'IFormModel'				=> 'interfaces',
				'ILogger'					=> 'interfaces',
				'IModel'					=> 'interfaces',
				'IModule'					=> 'interfaces',
				'IObject'					=> 'interfaces',
				'IPageSelector'				=> 'interfaces',
				'IProcedure'				=> 'interfaces',
				'IRenderer'					=> 'interfaces',
				'IRequest'					=> 'interfaces',
				'IRequestEvent'				=> 'interfaces',
				'ISessionHandler'			=> 'interfaces',
				'ISQLBuilder'				=> 'interfaces',
				'ITableModel'				=> 'interfaces',
				'ITask'						=> 'interfaces',
				'ITaskManager'				=> 'interfaces',
				'ITransformer'				=> 'interfaces',
				'IURLMapper'				=> 'interfaces',
				'IValidator'				=> 'interfaces',

		// HTML objects
				'HTMLChoiceGroupObject'		=> 'html_objects',
				'HTMLContainerObject'		=> 'html_objects',
				'HTMLFormFactory'			=> 'html_objects',
				'HTMLFormObject'			=> 'html_objects',
				'HTMLInputObject'			=> 'html_objects',
				'HTMLLeafObject'			=> 'html_objects',
				'HTMLListObject'			=> 'html_objects',
				'HTMLObject'				=> 'html_objects',
				'HTMLPanelObject'			=> 'html_objects',
				'HTMLSelectObject'			=> 'html_objects',
				'HTMLTextObject'			=> 'html_objects',
				'HTMLTextAreaObject'		=> 'html_objects',

		// event classes
				'Event'						=> 'events',
				'HttpRequestEvent'			=> 'events',
				'SystemEvent'				=> 'events',
				'UserEvent'					=> 'events',

		// logger classes
				'FileLogger'					=> 'loggers',
				'ScreenLogger'					=> 'loggers',
				'PopupScreenLogger'				=> 'loggers',
				'ConsoleLogger'					=> 'loggers',

		// constant classes
				'ComponentScope'			=> 'constants',

		// exception classes
				'AnnotaionException'				=> 'exceptions',
				'ArrayFormatException'				=> 'exceptions',
				'BooleanFormatException'			=> 'exceptions',
				'ClassLoaderConfigException'		=> 'exceptions',
				'ClassNotFoundException'			=> 'exceptions',
				'ComponentConfigException'			=> 'exceptions',
				'ComponentNotRegisteredException'	=> 'exceptions',
				'ConfigFileNotFoundException'		=> 'exceptions',
				'DataSourceConfigException'			=> 'exceptions',
				'DomainModelConfigException'		=> 'exceptions',
				'DBException'						=> 'exceptions',
				'EmptyStackException'				=> 'exceptions',
				'EncodingConverterException'		=> 'exceptions',
				'EventConfigException'				=> 'exceptions',
				'FilterConfigException'				=> 'exceptions',
				'FormConfigException'				=> 'exceptions',
				'HttpException'						=> 'exceptions',
				'InterfaceImplementException'		=> 'exceptions',
				'InternalException'					=> 'exceptions',
				'IntegerFormatException'			=> 'exceptions',
				'InvalidClassNameException'			=> 'exceptions',
				'InvalidDBRelationException'		=> 'exceptions',
				'LoggerConfigException'				=> 'exceptions',
				'MakeDirectoryException'			=> 'exceptions',
				'ModuleConfigException'				=> 'exceptions',
				'NonArrayException'					=> 'exceptions',
				'NonBooleanException'				=> 'exceptions',
				'NonIntegerException'				=> 'exceptions',
				'NonObjectException'				=> 'exceptions',
				'NonStringException'				=> 'exceptions',
				'NullPointerException'				=> 'exceptions',
				'PageSelectorConfigException'		=> 'exceptions',
				'ParameterException'				=> 'exceptions',
				'PhpSourceParserException'			=> 'exceptions',
				'ProcedureConfigException'			=> 'exceptions',
				'ProcessEventException'				=> 'exceptions',
				'ProfileException'					=> 'exceptions',
				'ProfileException'					=> 'exceptions',
				'RendererException'					=> 'exceptions',
				'RendererConfigException'			=> 'exceptions',
				'SessionHandlerConfigException'		=> 'exceptions',
				'SQLBuilderConfigException'			=> 'exceptions',
				'SQLBuilderException'				=> 'exceptions',
				'StringFormatException'				=> 'exceptions',
				'TableModelException'				=> 'exceptions',
				'TableModelConfigException'			=> 'exceptions',
				'TaskConfigException'				=> 'exceptions',
				'TaskGuardConditionException'		=> 'exceptions',
				'TaskNotRegisteredException'		=> 'exceptions',
				'TemplateFileNotFoundException'		=> 'exceptions',
				'TransformerConfigException'		=> 'exceptions',
				'UnexpectedRunModeException'		=> 'exceptions',
				'URLMapperConfigException'			=> 'exceptions',


		// config provider classes
				'IniConfigProvider'					=> 'config_providers',
				'PhpConfigProvider'					=> 'config_providers',
				'SpycConfigProvider'				=> 'config_providers',
				'CachedSpycConfigProvider'			=> 'config_providers',

		// page selector classes
				'DefaultPageSelector'				=> 'page_selectors',

		// task manager classes
				'DefaultTaskManager'				=> 'task_managers',

		// task classes
				'ComponentTask'						=> 'tasks',
				'DatabaseTask'						=> 'tasks',
				'DomainModelTask'					=> 'tasks',
				'FormTask'							=> 'tasks',
				'ModuleDelegateTask'				=> 'tasks',
				'SimpleTask'						=> 'tasks',
				'Task'								=> 'tasks',

		// table model classes
				'DefaultTableModel'					=> 'table_models',

		// domain model classes
				'DefaultDomainModel'				=> 'domain_models',

		// form model classes
				'DefaultFormModel'					=> 'form_models',

		// data source classes
				'PearDbDataSource'					=> 'data_sources',

		// request classes
				'ShellRequest'						=> 'requests',
				'HttpRequest'						=> 'requests',

		// session hanlder classes
				'DefaultSessionHandler'				=> 'session_handlers',

		// SQL Builder classes
				'DefaultSQLBuilder'					=> 'sql_builders',
				'MySQL_SQLBuilder'					=> 'sql_builders',
				'PostgreSQL_SQLBuilder'				=> 'sql_builders',

		// form classes
				'SimpleForm'						=> 'forms',

		// procedure classes
				'HttpProcedure'						=> 'procedures',
				'ShellProcedure'					=> 'procedures',

		// renderer classes
				'SmartyRenderer'					=> 'renderers',
				'PHPTALRenderer'					=> 'renderers',
				'CurvyRenderer'						=> 'renderers',

		// filter classes
				'FormOutputFilter'					=> 'filters',
				'FormReadOnlyOutputFilter'			=> 'filters',
				'EncodingInputFilter'				=> 'filters',
				'EncodingOutputFilter'				=> 'filters',
				'CharcoalPagerOutputFilter'			=> 'filters',

		// component classes
				'Linker'							=> 'components/charcoal',
				'BreadcrumbList'					=> 'components/charcoal',
				'CharcoalPager'						=> 'components/charcoal',
				'Calendar'							=> 'components/charcoal',
				'CharcoalMail'						=> 'components/mail/CharcoalMail.class.php',

		// transformer classes
				'SimpleTransformer'					=> 'transformers',

		// URL Mapper classes
				'SimpleURLMapper'					=> 'url_mappers',

		);

		return self::$class_paths;
	}

	/*
	 * 饹
	 */
	public static function loadClass( $class_name )
	{
		$class_paths = self::$class_paths;
		if ( !$class_paths ){
			// 饹ѥν
			$class_paths = self::initClassPath();
		}

		// ե졼Υ饹ǤϤʤFALSEֵ
		if ( !isset($class_paths[ $class_name ]) ){
			return FALSE;
		}

		// 饹̾饯饹ѥ
		$class_path = $class_paths[ $class_name ] . "/$class_name.class.php";

		// ɤ߹
		require_once( 'ClassUtil.class.php' );
		$loaded = ClassUtil::loadClass( $class_path, $class_name );

//		require( $class_path );

		return $loaded;
	}
}
return __FILE__;
