<?php
/**
* ǥեȤΥɥᥤǥ
*
* PHP version 5
*
* @package    table_models
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
class DefaultDomainModel extends CharcoalComponent implements IDomainModel
{
	private $_model_id;
	private $_class_name;
	private $_class_vars;
	private $_annotations;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct( String $name = NULL )
	{
		parent::__construct(s($name));

		$this->_model_id    = NULL;
		$this->_class_name  = get_class($this);
		$this->_class_vars  = get_class_vars($this->_class_name);

		$this->_annotation_list = array();
		foreach( $this->_class_vars as $key => $var ){
			$this->_annotations[$key] = AnnotationUtil::parse( $key, $var );
		}
	}

	/**
	 * ǥID
	 */
	public function setModelID( String $model_id )
	{
		$this->_model_id = $model_id;
	}

	/**
	 * ǥID
	 */
	public function getModelID()
	{
		return $this->_model_id;
	}

	/**
	 * եɤ¸ߤ뤫
	 */
	public function fieldExists( String $field_name )
	{
		return isset($this->_class_vars[$field_name]);
	}

	/*
	 *   °
	 */
	private function getAttributeList( String $name, String $value )
	{
		$result = array();

		$annotations = $this->_annotations;
		if ( $annotations ){
			foreach( $annotations as $attr => $annot_list ){
				foreach( $annot_list as $annot ){
					// °ξȽ
					if ( $annot->getName()->equals($name) && $annot->getValue()->equals($value) ){
						$result[] = $attr;
					}
				}
			}
		}

		return $result;
	}

	/*
	 *   եɰ
	 */
	public function getFieldList()
	{
		return $this->getAttributeList( s('field'), s('') );
	}

	/*
	 *   Υơ
	 */
	public function getAnnotation( String $field, String $annotation_name )
	{
		$annot_map = $this->getAnnotationMap( $field );
		if ( is_null($annot_map) || !isset($annot_map["$annotation_name"]) ){
			return NULL;
		}
		return $annot_map["$annotation_name"];
	}

	/*
	 *   ꤷեɤΥΥơޥåפ
	 */
	public function getAnnotationMap( String $field )
	{
		if ( !isset($this->_annotations["$field"]) ){
			return NULL;
		}
		return $this->_annotations["$field"];
	}

	/*
	 *   Υơͤ
	 */
	public function getAnnotationValue( String $field, String $annotation_name, $defaultValue = NULL )
	{
		$annot = $this->getAnnotation( $field, $annotation_name );

		return $annot ? $annot->getValue() : $defaultValue;
	}

	/*
	 *   Υơͤ
	 */
	public function setAnnotationValue( String $field, String $annotation_name, String $value )
	{
		$annot = $this->getAnnotation( $field, $annotation_name );

		if ( $annot ){
			$annot->setValue( $value );
		}
	}

	/*
	 *   ʸ
	 */
	public function __toString()
	{
		return "[DomainModel:" . get_class($this) . "]";
	}

}

return __FILE__;