<?php
/**
* ⥸塼˽ܾ륿
*
* PHP version 5
*
* @package    tasks
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class ModuleDelegateTask extends Task implements ITask
{
	private $_params;
	private $_module;
	private $_action;
	private $_ret_prop;


	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_params = array();
		$this->_module = NULL;
		$this->_action = NULL;
	}

	/**
	 * 
	 */
	public function init( Config $config )
	{
		parent::init($config);

		$this->_module     = $config->getString( s('module') );
		$this->_action     = $config->getString( s('action') );
		$this->_ret_prop   = $config->getString( s('ret_prop') );
	}

	/**
	 * ѥ᡼Υ
	 */
	public function getKeys()
	{
		return array_keys( $this->_params );
	}

	/**
	 * ѥ᡼
	 */
	public function get( $key )
	{
		return isset($this->_params[$key]) ? $this->_params[$key] : NULL;
	}

	/**
	 * ѥ᡼ꤹ
	 */
	public function set( $key, $value )
	{
		$this->_params[$key] = $value;
	}

	/**
	 * ٥Ȥ
	 */
	public function processEvent( IEvent $event )
	{
		$module_name = $this->_module;
		if ( $module_name && !$module_name->isEmpty() ){
			// ⥸塼
			$module = Factory::createModule( $module_name );
			// ƤӽФ
			$ret = $module->execute( $this->_action, $event );
			// ꥿ץѥƥꤵƤʤ顢åȤ
			if ( $this->_ret_prop && !$this->_ret_prop->isEmpty() ){
				$prop = $this->_ret_prop->getValue();
				$this->$prop = $ret;
			}
		}

		return b(TRUE);
	}

}

return __FILE__;