<?php
/**
* 󥯥饹
*
* PHP version 5
*
* @package    base
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class Vector extends Object implements Iterator, ArrayAccess
{
	private $_value;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct( $value = array() )
	{
		parent::__construct();

		if ( $value ){
			if ( is_array($value) ){
				$this->_value = array_diff( $value, array() );	// deep copy
			}
			else{
				_throw( new NonArrayException($value) );
			}
		}
		else{
			$this->_value = array();
		}
	}

	/*
	 *	Iterator󥿥ե:rewidμ
	 */
	public function rewind() {
		reset($this->_value);
	}

	/*
	 *	Iterator󥿥ե:currentμ
	 */
	public function current() {
		$var = current($this->_value);
		return $var;
	}

	/*
	 *	Iterator󥿥ե:keyμ
	 */
	public function key() {
		$var = key($this->_value);
		return $var;
	}

	/*
	 *	Iterator󥿥ե:nextμ
	 */
	public function next() {
		$var = next($this->_value);
		return $var;
	}

	/*
	 *	Iterator󥿥ե:validμ
	 */
	public function valid() {
		$var = $this->current() !== false;
		return $var;
	}

	/*
	 *	Ƭ
	 */
	public function getHead()
	{
		$cnt = count( $this->_value );
		if ( $cnt > 0 ){
			return $this->_value[ 0 ];
		}
		return NULL;
	}

	/*
	 *	Ǹ
	 */
	public function getTail()
	{
		$cnt = count( $this->_value );
		if ( $cnt > 0 ){
			return $this->_value[ $cnt - 1 ];
		}
		return NULL;
	}


	/*
	 *	Ǹ
	 */
	public function removeTail()
	{
		return array_pop( $this->_value );
	}

	/*
	 *	
	 */
	public function isEmpty()
	{
		return count( $this->_value ) === 0;
	}

	/*
	 *	Ǹɲ
	 */
	public function add( $item )
	{
		array_push( $this->_value, $item );
	}

	/*
	 *	ͤ
	 */
	public function getValue()
	{
		return $this->_value;
	}

	/*
	 *	ͤ
	 */
	public function get( String $key )
	{
		return isset($this->_value["$key"]) ? $this->_value["$key"] : NULL;
	}

	/*
	 *	ͤ򹹿
	 */
	public function set( String $key, $value )
	{
		$this->_value["$key"] = $value;
	}

	/*
	 * ץѥƥμ
	 */
	public function __get( $name )
	{
if ( !is_string($name) ){
	_throw( new NonStringException( $offset ) );
}
		$data =  isset($this->_value[ $name ]) ? $this->_value[ $name ] : NULL;
		return $data;
	}

	/*
	 * ץѥƥ
	 */
	public function __set( $name, $value )
	{
		$this->_value[ $name ] = $value;
	}

	/*
	 *	ArrayAccess󥿥ե:offsetGetμ
	 */
	public function offsetGet($offset)
	{
		if ( $offset instanceof String ){
			return isset($this->_value[ "$offset" ]) ? $this->_value[ "$offset" ] : NULL;
		}
		else{
			return isset($this->_value[ $offset ]) ? $this->_value[ $offset ] : NULL;
		}
	}

	/*
	 *	ArrayAccess󥿥ե:offsetSetμ
	 */
	public function offsetSet($offset, $value)
	{
		if ( $offset instanceof String ){
			$this->_value[ "$offset" ] = $value;
		}
		else{
			$this->_value[ $offset ] = $value;
		}
	}

	/*
	 *	ArrayAccess󥿥ե:offsetExistsμ
	 */
	public function offsetExists($offset)
	{
		if ( $offset instanceof String ){
			return isset($this->_value["$offset"]);
		}
		return isset($this->_value[$offset]);
	}

	/*
	 *	ArrayAccess󥿥ե:offsetUnsetμ
	 */
	public function offsetUnset($offset)
	{
		unset($this->_value[$offset]);
	}

	/*
	 *	
	 */
	public function keys()
	{
		return new Vector( array_keys( $this->_value ) );
	}

	/*
	 *	
	 */
	public function toArray()
	{
		return array_diff( $this->_value, array() );
	}

	/*
	 *	սˤ
	 */
	public function reverse()
	{
		return new Vector( array_reverse( $this->_value ) );
	}

	/*
	 *	ϢڤʸǤĤʤʸˤ֤
	 */
	public function implodeAssoc( $glue = ',' )
	{
		$array = $this->_value;
		$str = '[';
		foreach( $array as $key => $value ){
			if ( strlen($str) > 1 ){
				$str .= $glue;
			}
			$str .= "$key=$value";
		}
		$str .= "]";

		return $str;
	}

	/*
	 *	ʸ
	 */
	public function toString()
	{
		return $this->implodeAssoc();
	}

}
return __FILE__;
