<?php
/**
* ֥饦˥ݥåץå׽Ϥ饹ʼ˥ǥХåѡ
*
* PHP version 5
*
* @package    loggers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class PopupScreenLogger extends CharcoalComponent implements ILogger
{
	private $_window_open;
	private $_line;

	/*
	 * 󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_window_open = FALSE;

		$this->_line = 0;
	}

	/*
	 * 򥷥åȥ
	 */
	public function terminate()
	{
		$window_id = $this->hashCode();

		echo ('<script language="JavaScript">' . PHP_EOL);
		echo ("w_$window_id.document.writeln('</table></body></html>');" . PHP_EOL);
		echo ("</script>" . PHP_EOL);
	}

	/*
	 * Խ
	 */
	public function writeln( $key, $level, $message, $file, $line )
	{
		$window_id = $this->hashCode();

		if ( $this->_window_open === FALSE ){

			$html_code = Profile::getString( s('HTML_CODE') );

			echo ('<script language="JavaScript">' . PHP_EOL);
			echo ("var w_$window_id = window.open('', $window_id, 'toolbar=no,scrollbars,width=600,height=650');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('<html><head>');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('<title>Log Window[ $key ]</title>');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('<META http-equiv=\"Content-Type\" content=\"text/html; charset=$html_code\">');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('<style type=\"text/css\">');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('* { font-family: Courier New; font-size: 8pt; }');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('td.b0 { background-color:#ffffff; }');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('td.b1 { background-color:#CFCFCF; }');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('th { border-bottom: #4169e1 3px solid; }');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('h2 { font-size: 14pt; font-weight: bold; }');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('</style>');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('</head><body>');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('<h2>$key Log</h2>');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('<table border=0 cellspacing=0>');" . PHP_EOL);
			echo ("w_$window_id.document.writeln('<tr><th>Date</th><th>Level</th><th>Message</th><th>File</th><th>Line</th></tr>');" . PHP_EOL);
			echo ("</script>" . PHP_EOL);

			$this->_window_open = TRUE;
		}

		$time = date("y/m/d H:i:s");
		$file = basename($file);

		// 󥳡ǥѴ
		$conv = EncodingConverter::fromString( 'PHP_TO_HTML' );
		$message = $conv->convertEncoding( $message );

		// 򡿤Ѵ
		$message = str_replace( '\\', '/', $message );

		// ̽
		$message = h($message);
		$clazz = 'b' . ($this->_line % 2);
		$msg  = '<tr>';
		$msg .= '<td class="' . $clazz . '">' . $time . '</td>';
		$msg .= '<td class="' . $clazz . '" style="text-align:center">' . $level . '</td>';
		$msg .= '<td class="' . $clazz . '">' . $message . '</td>';
		$msg .= '<td class="' . $clazz . '">' . $file . '</td>';
		$msg .= '<td class="' . $clazz . '">' . $line . '</td>';
		$msg .= '</tr>'; 

		echo '<script language="JavaScript">' . PHP_EOL;
		echo "w_$window_id.document.writeln('$msg');" . PHP_EOL;
		echo '</script>' . PHP_EOL;

		$this->_line ++;
	}

	/**
	 * ʸ
	 */
	public function __toString()
	{
		return $this->getLoggerName();
	}
}

return __FILE__;