<?php
/**
* ǥեȤΥåϥɥ
*
* PHP version 5
*
* @package    components.db
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class DefaultSessionHandler implements ISessionHandler
{
	static $save_path;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
	}

	/**
	 * åϥɥ̾
	 */
	public function getSessionHandlerName()
	{
		return "Default Session Handler";
	}

	/**
	 * åϥɥ
	 */
	public function init( Config $config )
	{
		$session_name  = $config->getString( 'session_name' );
		$save_path     = $config->getString( 'save_path' );
		$lifetime      = $config->getInteger( 'lifetime' );
		$valid_path    = $config->getString( 'valid_path' );
		$valid_domain  = $config->getString( 'valid_domain' );
		$ssl_only      = $config->getBoolean( 'ssl_only' );

		// ǥեȤΥå¸
		if ( !$save_path || !is_file($save_path) ){
			$save_path = ResourceLocator::getWebAppPath( 'sessions' );
		}

		// å
		session_set_cookie_params( $lifetime, "$valid_path", "$valid_domain", $ssl_only );
		session_save_path( $save_path );
		session_name( $session_name ? $session_name : APPLICATION );
		//session_regenerate_id( TRUE );

		// С¸
		self::$save_path = $save_path;
	}

	/**
	 * åեѥ
	 */
	public static function getSessionFile( $id )
	{
		return self::$save_path . "/sess_$id";
	}

	/**
	 * Хåؿץ
	 */
	public static function open( $save_path, $session_name )
	{
		return true;
	}

	/**
	 * Хåؿ
	 */
	public static function close()
	{
		return true;
	}

	/**
	 * Хåؿɤ߼
	 */
	public static function read( $id )
	{
		$file = self::getSessionFile( $id );

		return (string) @file_get_contents( $file );
	}

	/**
	 * Хåؿ񤭹
	 */
	public static function write( $id, $sess_data )
	{
		$file = self::getSessionFile( $id );

		$fp = @fopen($file,'w');
		if ( !$fp ){
			return false;
		}
		$write = fwrite($fp, $sess_data);
		fclose($fp);

		return $write;
	}

	/**
	 * Хåؿ˴
	 */
	public static function destroy( $id )
	{
		$file = self::getSessionFile( $id );

		return @unlink($file);
	}

	/**
	 * Хåؿ١쥯
	 */
	public static function gc( $max_lifetime )
	{
		$find_path = self::getSessionFile( '*' );

		foreach( glob($find_path) as $file ){
			if ( filemtime($file) + $max_lifetime < time() ){
				@unlink( $file );
			}
		}
		return true;
	}

}
