<?php

/**
* PostgreSQLѤSQLӥ
*
* PHP version 5
*
* @package    components.db
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
class PostgreSQL_SQLBuilder extends DefaultSQLBuilder
{
	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
	}

	/*
	 * SQLӥ̾
	 */
	public function getSQLBuilderName()
	{
		return "MySQL SQL builder";
	}

	/*
	 *	SQL(CREATE DATABASE)
	 */
	public  function buildCreateDatabaseSQL( $db_name, $charset = NULL )
	{
		return "CREATE DATABASE $db_name WITH ENCODING='$charset'";
	}

	/*
	 *	SQL(CREATE TABLE)
	 */
	public  function buildCreateTableSQL( ITableModel $model )
	{
		$field_list = $model->getFieldList();

		$SQL_field_list = array();

		foreach( $field_list as $name )
		{
			$pk       = $model->getAnnotation( $name, 'pk' );
			$type     = $model->getAnnotation( $name, 'type' );
			$notnull  = $model->getAnnotation( $name, 'notnull' );
			$charset  = $model->getAnnotation( $name, 'charset' );
			$serial   = $model->getAnnotation( $name, 'serial' );
			$default  = $model->getAnnotation( $name, 'default' );

			$type_name = $this->mapType( $type->getValue() );
			$length    = $type->getParameter();

			if ( $length ){
				$field_expr = "$name $type_name($length)";
			}
			else{
				$field_expr = "$name $type_name";
			}

			if ( $pk ){
				if ( $serial ){
					$field_expr = "$name serial primary key";
				}
				if ( $notnull ){
					$field_expr .= ' NOT NULL';
				}
			}
			else{
				if ( $default ){
					$field_expr .= ' DEFAULT ' . $default->getValue();
				}
				if ( $charset ){
					$field_expr .= " CHARACTER SET $charset";
				}
				if ( $notnull ){
					$field_expr .= ' NOT NULL';
				}
			}

			$SQL_field_list[] = $field_expr;
		}

		$SQL_field_list = implode( ",\n", $SQL_field_list );

		$table_name = $model->getTableName();
		$sql = "CREATE TABLE $table_name (\n $SQL_field_list \n ) \n";

		return $sql;
	}

	/*
	 *	SQL(LAST_INSERT_ID)
	 */
	public  function buildLastIdSQL()
	{
		return "select LASTVAL()";
	}

}
